#include <stdio.h>
#include <libc.h>
#include "pxo2gif.h"

/* extern */
int verbose = 0;

static void usage(void)
{
	fprintf(stderr, "pxo2gif (2000-03-24)\n");
	fprintf(stderr, "Usage: pxo2gif [-i][-v] [pxo_file]\n");
	fprintf(stderr, "\t-i\tInterlace\n");
	fprintf(stderr, "\t-v\tVerbose\n");
}

int main(int argc, char **argv)
{
	FILE	*fp;
	int	ac;
	int	intlflag = 0;
	commonInfo *cinf;

	for (ac = 1; ac < argc && argv[ac][0] == '-'; ac++) {
		switch (argv[ac][1]) {
		case 'i':
			intlflag = 1;	break;
		case 'v':
			verbose = 1;	break;
		case 'h':
			usage();
			return 1;
		default:
			fprintf(stderr, 
				"Warning: Unknown option: %s\n", argv[ac]);
			break;
		}
	}
	if (ac >= argc)
		fp = stdin;
	else {
		if ((fp = fopen(argv[ac], "r")) == NULL) {
			fprintf(stderr, "ERROR: Can't open %s\n", argv[ac]);
			return 1;
		}
	}
	cinf = pxoread(fp);
	GIFEncode( stdout, cinf, intlflag );
	freePxoInfo(cinf);
	(void)fclose(fp);
	return 0;
}
