
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTMenu.h"
#import "GLUTWindow.h"
#import "GLUTView.h"


GLUTMenu *							__glutLeftButtonMenu = nil;
GLUTMenu *							__glutMiddleButtonMenu = nil;
GLUTMenu *							__glutRightButtonMenu = nil;







/* ***************** GLUTMenu class implementation ******************** */


@implementation GLUTMenu

- (id)initWithCallback: (GLUTMenuCallback)func
{
	if((self = [super init]) != nil)
	{
		_menu = [[NSMenu allocWithZone: [NSMenu menuZone]] initWithTitle: @""];
		if(_menu == nil)
			return nil;

		_callback	= func;
		
		return self;
	}

	return nil;
}

- (void)dealloc
{
	NSMenuItem *	menuItem = [[NSApp mainMenu] itemWithTitle: [_menu title]];
	
	if(menuItem)
		[[NSApp mainMenu] removeItem: menuItem];
	
	[_menu release];
	[super dealloc];
}

- (int)numberOfItems
{
	return [_menu numberOfItems];
}

	/* Makes the receiver the current menu */
- (void)makeCurrent
{
	__glutCurrentMenu = self;
}

	/* Method called by the OS if user selected a menu item. */
- (IBAction)menuItemAction: (id)sender
{
	if(_callback)
	{
		[self makeCurrent];
			// ugly hack necessary simply because some people draw inside the menu callback,
			// which is a very bad idea, really.
		if([__glutCurrentWindow isMemberOfClass: [GLUTView class]] == YES)
		{
			[((GLUTView *) __glutCurrentWindow) lockFocus];
				(*_callback)([sender tag]);
				glFlush();
#if defined(GFXLIB_MESA26)
			[((GLUTView *) __glutCurrentWindow) flushGraphics];
#endif
			[((GLUTView *) __glutCurrentWindow) unlockFocus];
		}
		else
		{
			[[((GLUTWindow *) __glutCurrentWindow) contentView] lockFocus];	
				(*_callback)([sender tag]);
				glFlush();
#if defined(GFXLIB_MESA26)
			[[((GLUTWindow *) __glutCurrentWindow) contentView] flushGraphics];
#endif
			[[((GLUTWindow *) __glutCurrentWindow) contentView] unlockFocus];
		}
	
		if(__glutDebug)
			glutReportErrors();
	}
}

- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem
{
	return YES;
}

	/* Adds a new menu item to the end of the receiver. "value" is stored as the menu item's tag value. */
- (void)addMenuItemWithTitle: (NSString *)title tag: (int)value
{
/*	if(([title isEqualToString: @"Quit"] == NO) &&
		([title isEqualToString: @"Exit"] == NO))*/
	{
		NSMenuItem *	menuItem = [[NSMenuItem allocWithZone: [NSMenu menuZone]]	initWithTitle: title
																											action: @selector(menuItemAction:)
																											keyEquivalent: @""];
		
		[menuItem setTag: value];
		[menuItem setTarget: self];
		[_menu addItem: menuItem];
		[menuItem release];
	}
}

	/* Adds the given menu as a submenu to the receiver. */
- (void)addSubMenuWithTitle: (NSString *)title menu: (GLUTMenu *)submenu
{
	NSMenuItem *	menuItem = [[NSMenuItem allocWithZone: [NSMenu menuZone]]	initWithTitle: title
																										action: @selector(menuItemAction:)
																										keyEquivalent: @""];
	
	if([[submenu nativeMenu] supermenu] == nil)
		[menuItem setSubmenu: [submenu nativeMenu]];

	[_menu addItem: menuItem];
	[menuItem release];
}

	/* Changes the given menu item's title and tag to the given values. */
- (void)setMenuItemAtIndex: (int)index toTitle: (NSString *)title tag: (int)value
{
	NSMenuItem *	menuItem = [_menu itemAtIndex: index];
	
	[menuItem setTitle: title];
	[menuItem setTag: value];
	if([menuItem hasSubmenu] == YES)
		[menuItem setSubmenu: nil];
}

	/* Changes the given menu item to a submenu. */
- (void)setMenuItemAtIndex: (int)index toTitle: (NSString *)title menu: (GLUTMenu *)submenu
{
	NSMenuItem *	menuItem = [_menu itemAtIndex: index];
	
	[menuItem setTitle: title];
	[menuItem setSubmenu: [submenu nativeMenu]];
}

	/* Removes the given menu item */
- (void)removeMenuItemAtIndex: (int)index
{
	[_menu removeItemAtIndex: index];
}

- (void)attachToMouseButton: (int)button
{
	NSString *	menuTitle = nil;
	
	switch(button)
	{
		case GLUT_LEFT_BUTTON:
			menuTitle = @"View";
			break;
		case GLUT_RIGHT_BUTTON:
			menuTitle = @"Tools";
			break;
		case GLUT_MIDDLE_BUTTON:
			menuTitle = @"GLUT";
			break;
	}
	
	if(__glutFinishedInitialization == YES)
	{
		if([_menu supermenu] == nil)
		{
			NSMenuItem *	menuItem = nil;
			NSMenu *			mainMenu = [NSApp mainMenu];
			
			menuItem = [[NSMenuItem allocWithZone: [NSMenu menuZone]] initWithTitle: menuTitle action: NULL keyEquivalent: @""];
			
			[_menu setTitle: menuTitle];
			[menuItem setSubmenu: _menu];		
			
			[mainMenu insertItem: menuItem atIndex: [mainMenu indexOfItemWithSubmenu: [NSApp windowsMenu]]];
			[menuItem release];
		}
	}
	else
	{
			// add menu to pool of non owned menus. This menus will be added to the root menu
			// in applicationDidFinishLaunching
		switch(button)
		{
			case GLUT_LEFT_BUTTON:
					__glutLeftButtonMenu = self;
					break;
			case GLUT_MIDDLE_BUTTON:
					__glutMiddleButtonMenu = self;
					break;
			case GLUT_RIGHT_BUTTON:
					__glutRightButtonMenu = self;
					break;
		}
	}
}

- (void)detachFromMouseButton: (int)button
{
	if(__glutFinishedInitialization == YES)
	{
		NSMenu *			mainMenu = [NSApp mainMenu];
		NSMenuItem *	menuItem = [mainMenu itemWithTitle: [_menu title]];
		
		if(menuItem != nil)
			[mainMenu removeItem: menuItem];
	}
	else
	{
		switch(button)
		{
			case GLUT_LEFT_BUTTON:
					__glutLeftButtonMenu = nil;
					break;
			case GLUT_MIDDLE_BUTTON:
					__glutMiddleButtonMenu = nil;
					break;
			case GLUT_RIGHT_BUTTON:
					__glutRightButtonMenu = nil;
					break;
		}

	}
}	

- (NSMenu *)nativeMenu
{
	return _menu;
}

@end
