
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */


#if defined(GFXLIB_MESA26)

#import "GLUTVisual.h"
#import <AppKit/NSBitmapImageRep.h>
#import <GL/osmesa.h>


/* *** mesa visual info *** */

/* *** mesa visual class *** */


@interface GLUTMesaVisual : GLUTVisual
{
	OSMesaContext			_ctx;
	NSBitmapImageRep *	_image;
	unsigned char *		_imageData;
	BOOL						_isBoundToImageData;
}

		/* visual info */
+ (const GLUTVisualInfo *)makeVisualInfos: (int *)numModes;


- (id)initWithString: (const char *)displayString pixelsWide: (int)width pixelsHigh: (int)height requiredCriteria: (const GLUTCriterion *)crits count: (unsigned int)critscount requiredCriteriaMask: (int)mask;
- (void)dealloc;

		/* attributes */
- (void)setSize: (NSSize)newSize;

		/* operations */
- (void)makeCurrent;
- (void)makeNotCurrent;
- (void)swapBuffers;

@end

#endif
