
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */


#import <Foundation/Foundation.h>
#import "macxglut_private.h"





/* *** types *** */

/* *** GLUT overlay class *** */

@class	GLUTVisual, GLUTView;


	/* The overlay pixels get composited ontop of the regular framebuffer contents after the
		client's display callback returned. */

@interface GLUTOverlay : NSObject
{
@private
	
	GLUTView *					_view;					// weak ref	
	GLUTVisual *				_visual;					// visual used to raster into the overlay
	GLUTDisplayCallback		_displayCallback;
	BOOL							_isVisible;
	BOOL							_damagedByUser;		/* YES if redisplay is necessary by the user calling glutPostOverlayRedisplay */
}

+ (BOOL)canCreateInstanceWithString: (const char *)dstring;


- (id)initWithFrame: (NSRect)frame view: (GLUTView *)view;
- (void)dealloc;

- (GLUTVisual *)visual;
- (NSSize)size;
- (void)setSize: (NSSize)size;

- (void)makeCurrent;
- (void)makeNotCurrent;

- (void)displayInRect: (NSRect)rect;
- (void)drawRect: (NSRect)rect;

- (void)setDisplayCallback: (GLUTDisplayCallback)func;

- (void)show;
- (void)hide;
- (void)display;

- (void)update;

@end
