
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTView.h"
#import "GLUTView_Private.h"
#import "GLUTWindow.h"
#import "GLUTOverlay.h"
#import "GLUTApplication.h"
#import "GLUTVisual.h"










/* *** GLUTView class implementation *** */


@implementation GLUTView


static GLUTCriterion	_requiredWindowCriteria[] =
{
	{DS_LEVEL, DS_EQ, 0},
	{DS_TRANSPARENT, DS_EQ, 0}
};
static int				_numRequiredWindowCriteria = sizeof(_requiredWindowCriteria) / sizeof(GLUTCriterion);
static int				_requiredWindowCriteriaMask = (1 << DS_LEVEL) | (1 << DS_TRANSPARENT);



	/* Returns YES if the given mode is supported by the graphics subsystem, NO if not */
+ (BOOL)canCreateInstanceWithString: (const char *)dstring
{
	return [GLUTVisual	canCreateInstanceWithString: dstring
								requiredCriteria: _requiredWindowCriteria
								count: _numRequiredWindowCriteria
								requiredCriteriaMask: _requiredWindowCriteriaMask];
}


		/* designated initializer */
- (id)initWithFrame: (NSRect)frameRect displayString: (const char *)displayString isSubWindow: (BOOL)yesno
{	
	if((self = [super initWithFrame: frameRect]) != nil)
	{
		_visual = [[GLUTVisual allocWithZone: [self zone]]	initWithString: displayString
																			pixelsWide: (int) frameRect.size.width
																			pixelsHigh: (int) frameRect.size.height
																			requiredCriteria: _requiredWindowCriteria
																			count: _numRequiredWindowCriteria
																			requiredCriteriaMask: _requiredWindowCriteriaMask];
		
		[self setAutoresizingMask: (NSViewHeightSizable | NSViewWidthSizable)];
		[self setAutoresizesSubviews: NO];
		[self setPostsBoundsChangedNotifications: NO];
		[self setPostsFrameChangedNotifications: NO];
		
		_flags.cursor					= GLUT_CURSOR_INHERIT;
		_flags.pendingShowHide		= YES;
		_flags.doShowOp				= YES;
		_windowStatus					= GLUT_UNKNOWN_VISIBILITY;
		_flags.isSubWindow			= yesno;
		_flags.drawToOverlay			= NO;		
		_flags.isDrawingLocked		= YES;
		_flags.forceReshapeCall		= YES;
		_flags.pendingReshape		= NO;
		_size								= frameRect.size;
		
		if(yesno == YES)
			[self setNeedsStateUpdate: YES];
		
		return self;
	}
	return nil;
}

- (void)dealloc
{
	if(_flags.isSubWindow)
	{
			/* remove ourselves from the window list */
		NSMapRemove(__glutWindowList, (void *) _windowKey);
		if(self == __glutCurrentWindow)
			__glutCurrentWindow = nil;
	}
	
	if(_cursorObj)
		[_cursorObj release];
	
	if(_trackingRectTag)
		[self removeTrackingRect: _trackingRectTag];

	if(_overlay)
		[_overlay release];
	
	if(_visual)
	{
		[_visual makeNotCurrent];
		[_visual release];
	}
	
	[super dealloc];
}

- (GLUTVisual *)visual
{
	return _visual;
}

- (GLUTOverlay *)overlay
{
	return _overlay;
}

	/* Return window position either in screen or parent coordinates. */
- (NSPoint)windowPositionRelativeToParent: (BOOL)yesno
{
	NSPoint	pt = [self frame].origin;
	
	if(yesno == NO)
	{
		pt = [self convertPoint: pt toView: nil];
		pt = [[self window] convertBaseToScreen: pt];
	}
	
	return pt;
}

	/* Return window size in local coordinates. */
- (NSSize)windowSize
{
	return [self frame].size;
}

- (BOOL)isVisible
{
	return (_windowStatus == GLUT_HIDDEN || _windowStatus == GLUT_FULLY_COVERED) ? NO : YES;
}

- (BOOL)isSubWindow
{
	return YES;
}

- (BOOL)isDamaged
{
	return _flags.isDamaged;
}

- (id <GLUTWindows>)parentWindow
{
	NSView *	sview = [self superview];
	
	if(sview == [[self window] contentView])
		return (GLUTWindow *) [self window];
	else
		return (GLUTView *) sview;
}

- (int)numberOfSubWindows
{
	NSArray *	subviews = [self subviews];
	
	return (subviews != nil) ? (int) [subviews count] : 0;
}

- (NSWindow *)nativeWindow
{
	return [self window];
}

- (void)setWindowKey: (int)key
{
	_windowKey = key;
}

	/* Adds the given view to the subview hierarchy of the receiver. */
- (void)addSubWindow: (id <GLUTWindows>)subwindow
{
	[self addSubview: subwindow];
}

	/* Removes the receiver from it's parent view/window */
- (void)removeFromParent
{
	[self removeFromSuperview];
}


	/* Makes the receiving view the current view where all OpenGL calls are directed to. */
- (void)makeCurrent
{
	id<GLUTWindows>	referenceView = self;
		
	if(_flags.isSubWindow == NO)
		referenceView = (id<GLUTWindows>) [self window];
	
	if(__glutCurrentWindow != referenceView)
	{
	//	NSLog(@"changed context.\n");
		[__glutCurrentWindow makeNotCurrent];
		__glutCurrentWindow = referenceView;
				
		if(_flags.drawToOverlay == NO)
			[_visual makeCurrent];
		else
			[_overlay makeCurrent];
	}
}

	/* Removes the current state from the receiver. */
- (void)makeNotCurrent
{
	if(_flags.drawToOverlay == NO)
		[_visual makeNotCurrent];
	else
		[_overlay makeNotCurrent];
}

- (void)swapBuffers
{
	[_visual swapBuffers];
}


		/* *** event handlers *** */

- (void)setKeyboardCallback: (GLUTKeyboardCallback)func isKeyDown: (BOOL)yesno
{
	if(yesno == YES)
		_keyboardCallback = func;
	else
		_keyUpCallback = func;
}

- (void)setMouseCallback: (GLUTMouseCallback)func
{
	_mouseCallback = func;
}

- (void)setMotionCallback: (GLUTMotionCallback)func
{
	_motionCallback = func;
}

- (void)setPassiveMotionCallback: (GLUTMotionCallback)func
{
	_passiveMotionCallback = func;
		/* handle mouseMoved event generation */
	if(func)
		[[self window] setAcceptsMouseMovedEvents: YES];
	else
		[[self window] setAcceptsMouseMovedEvents: NO];
}
 
- (void)setEntryCallback: (GLUTEntryCallback)func
{
	if(func && _trackingRectTag)
	{
		_entryCallback = func;
		return;
	}
		/* setup our tracking rect */
	if(func && _trackingRectTag == 0)
	{
		BOOL		isInside = NO;
		NSPoint	mouseLoc = [[self window] mouseLocationOutsideOfEventStream];
		
		mouseLoc = [self convertPoint: mouseLoc fromView: nil];
		isInside = NSMouseInRect(mouseLoc, [self bounds], YES);
		_trackingRectTag = [self addTrackingRect: [self bounds] owner: self userData: nil assumeInside: isInside];
		[self setPostsFrameChangedNotifications: YES];
		[[NSNotificationCenter defaultCenter]	addObserver: self
															selector: @selector(_updateTrackingRects:)
															name: NSViewFrameDidChangeNotification
															object: nil];
		_entryCallback = func;
		return;
	}
	
	if(func == NULL && _trackingRectTag)
	{
		[self removeTrackingRect: _trackingRectTag];
		[self setPostsFrameChangedNotifications: NO];
		[[NSNotificationCenter defaultCenter] removeObserver: self];
		_trackingRectTag = 0;
		_entryCallback = NULL;
	}
}

- (void)setSpecialCallback: (GLUTSpecialCallback)func isKeyDown: (BOOL)yesno
{
	if(yesno == YES)
		_specialCallback = func;
	else
		_specialUpCallback = func;
}

- (int)modifierFlags
{
	if(_flags.modifierFlagsValid == YES)
		return _modifierFlags;
	else
	__glutWarning("glutGetModifiers may only be called in a keyboard, special or mouse callback.");
	return 0;
}

- (void)setDisplayCallback: (GLUTDisplayCallback)func	{ _displayCallback = func; }
- (void)setReshapeCallback: (GLUTReshapeCallback)func	{ _reshapeCallback = func; }
- (void)setWindowStatusCallback: (GLUTWindowStatusCallback)func	{ _windowStatusCallback = func; }
- (void)setVisibilityCallback: (GLUTVisibilityCallback)func			{ _visibilityCallback = func; }
- (void)setSpaceballMotionCallback: (GLUTSpaceballMotionCallback)func	{ _spaceballMotionCallback = func; }
- (void)setSpaceballRotateCallback: (GLUTSpaceballRotateCallback)func	{ _spaceballRotateCallback = func; }
- (void)setSpaceballButtonCallback: (GLUTSpaceballButtonCallback)func	{ _spaceballButtonCallback = func; }
- (void)setButtonBoxCallback: (GLUTButtonBoxCallback)func	{ _buttonBoxCallback = func; }
- (void)setDialCallback: (GLUTDialCallback)func	{ _dialCallback = func; }
- (void)setTabletMotionCallback: (GLUTTabletMotionCallback)func	{ _tabletMotionCallback = func; }
- (void)setTabletButtonCallback: (GLUTTabletButtonCallback)func	{ _tabletButtonCallback = func; }

- (void)setJoystickCallback: (GLUTJoystickCallback)func pollInterval: (NSTimeInterval)delay
{
	_joystickCallback	= func;
	_pollInterval		= delay;
}

- (BOOL)ignoreKeyRepeats
{
	return _flags.ignoreKeyRepeats;
}

- (void)setIgnoreKeyRepeats: (BOOL)yesno
{
	_flags.ignoreKeyRepeats = yesno;
}

- (NSTimeInterval)joystickPollInterval
{
	return _pollInterval;
}


		/* cursor */


- (int)cursor
{
	return (int) _flags.cursor;
}

	/* Sets the receiver's cursor according to "cursor". */
- (void)setCursor: (int)cursor
{
	if(_flags.cursor == (unsigned int) cursor)
		return;
	
	[self removeCursorRect: [self visibleRect] cursor: _cursorObj];
	[_cursorObj release];
	_flags.cursor = (unsigned int) cursor;
	
	switch(cursor)
	{
			/* Basic arrows. */
		case GLUT_CURSOR_RIGHT_ARROW:
		case GLUT_CURSOR_LEFT_ARROW:
												_cursorObj = [[NSCursor arrowCursor] retain];
												break;
			/* Symbolic cursor shapes. */
		case GLUT_CURSOR_INFO:
		case GLUT_CURSOR_DESTROY:
		case GLUT_CURSOR_HELP:
		case GLUT_CURSOR_CYCLE:
		case GLUT_CURSOR_SPRAY:
		case GLUT_CURSOR_WAIT:
												_cursorObj = [[NSCursor arrowCursor] retain];
												break;
		case GLUT_CURSOR_TEXT:
												_cursorObj = [[NSCursor IBeamCursor] retain];
												break;
		case GLUT_CURSOR_CROSSHAIR:
			/* Directional cursors. */
		case GLUT_CURSOR_UP_DOWN:
		case GLUT_CURSOR_LEFT_RIGHT:
			/* Sizing cursors. */
		case GLUT_CURSOR_TOP_SIDE:
		case GLUT_CURSOR_BOTTOM_SIDE:
		case GLUT_CURSOR_LEFT_SIDE:
		case GLUT_CURSOR_RIGHT_SIDE:
		case GLUT_CURSOR_TOP_LEFT_CORNER:
		case GLUT_CURSOR_BOTTOM_LEFT_CORNER:
		case GLUT_CURSOR_TOP_RIGHT_CORNER:
		case GLUT_CURSOR_BOTTOM_RIGHT_CORNER:
			/* Inherit from parent window. */
		case GLUT_CURSOR_INHERIT:
												_cursorObj = [[NSCursor arrowCursor] retain];
												break;
			/* Blank cursor. */
		case GLUT_CURSOR_NONE:
												_cursorObj = [[self _unvisibleCursor] retain];
												break; 
			/* Fullscreen crosshair (if available). */
		case GLUT_CURSOR_FULL_CROSSHAIR:
												_cursorObj = [[NSCursor arrowCursor] retain];
												break;
	}
	
	[[self window] invalidateCursorRectsForView: self];
}

	/* creates/replaces the window's overlay plane */
- (void)establishOverlay
{
	[_overlay release];
	_overlay = nil;
	
	_overlay = [[GLUTOverlay alloc] initWithFrame: [self bounds] view: self];
	if(_overlay == nil)
		__glutFatalError("out of memory.");
	
	[self setUsesLayer: GLUT_OVERLAY];
}

	/* If the receiver has currently an overlay established, it is removed. */
- (void)removeOverlay
{
	if(_overlay)
	{
		[_overlay release];
		_overlay = nil;
		[self setUsesLayer: GLUT_NORMAL];
	}
}

	/* Sets the layer to use if the receiver will be made current. */
- (void)setUsesLayer: (GLenum)layer
{
	_flags.drawToOverlay = (layer == GLUT_OVERLAY) ? YES : NO;
	[self makeCurrent];
}


	/* ** window update system ** */


- (void)setNeedsStateUpdate: (BOOL)yesno
{
	if(yesno == YES)
	{
		NSEvent *	myEvent = [NSEvent	otherEventWithType: NSApplicationDefined
						location: NSMakePoint(0.0, 0.0)
						modifierFlags: 0
						timestamp: 0.0
						windowNumber: [[self window] windowNumber]
						context: [NSDPSContext currentContext]
						subtype: 0
						data1: 0
						data2: 0];
		
		[NSApp postEvent: myEvent atStart: NO];

		if(_flags.needsUpdate == NO)
		{
			_flags.needsUpdate = YES;
			if(_flags.isSubWindow == YES)
				[NSApp markWindowAsNeedingUpdate: self];
			else
				[NSApp markWindowAsNeedingUpdate: (id<GLUTWindows>) [self window]]; 
		}
	}
	else
	{
		_flags.needsUpdate = NO;
	}
}

- (BOOL)needsStateUpdate
{
	return _flags.needsUpdate;
}


	/* ** defered operations ** */


	/* Marks the current window as needing redisplay. */
- (void)postRedisplay
{
	_flags.pendingRedisplay = YES;
		
		// keep event processsing alive, in the case that glutPostRedisplay() is called inside
		// the display callback.
	{
		NSEvent *	myEvent = [NSEvent	otherEventWithType: NSApplicationDefined
						location: NSMakePoint(0.0, 0.0)
						modifierFlags: 0
						timestamp: 0.0
						windowNumber: [[self window] windowNumber]
						context: [NSDPSContext currentContext]
						subtype: 0
						data1: 0
						data2: 0];
		
		[NSApp postEvent: myEvent atStart: NO];
	}
	[self setNeedsStateUpdate: YES];
	[self setNeedsDisplay: YES];
}

	/* The following methods make the view visible or unvisible by blocking/unblocking the drawing code. */
- (void)show
{
	_flags.pendingShowHide = YES;
	_flags.doShowOp = YES;
	[self setNeedsStateUpdate: YES];
}

- (void)hide
{
	_flags.pendingShowHide = YES;
	_flags.doShowOp = NO;
	[self setNeedsStateUpdate: YES];
}

	/* Sets the position of the receiver. */
- (void)setPosition: (NSPoint)origin
{
	_flags.pendingMove = YES;
	_pos = origin;
	[self setNeedsStateUpdate: YES];
}

	/* Sets the receivers size */
- (void)setSize: (NSSize)size
{
	_flags.pendingReshape = YES;
	_size = size;
	[self setNeedsStateUpdate: YES];
}

	/* Moves the receiver to the top of all it's siblings. */
- (void)push
{
	_flags.pendingPushPop = YES;
	_flags.doPushOp = YES;
	[self setNeedsStateUpdate: YES];
}

	/* Moves the receiver to the bottom of all it's siblings. */
- (void)pop
{
	_flags.pendingPushPop = YES;
	_flags.doPushOp = NO;
	[self setNeedsStateUpdate: YES];
}

	/* Housekeeping routine. All glut operations which should be defered until the end of the current
		event are executed here. */
- (void)updateWindowState
{
	NSView *	highestViewNeedingDisplay = self;
	
	if(_flags.isSubWindow == YES)
		[self setNeedsStateUpdate: NO];
	
		/* ** redisplay handling ** */
	if(_flags.pendingRedisplay)
		[self setNeedsDisplay: YES];
	
		/* ** move handling ** */
	if(_flags.pendingMove)
	{
		[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: NO];
		[[self superview] setNeedsDisplayInRect: [self frame]];
		highestViewNeedingDisplay = [self superview];
		[self setFrameOrigin: _pos];
		[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: NO];
		[self setNeedsDisplay: YES];
//		[self display];
		_flags.pendingMove = NO;
	}
	
		/* ** reshape handling ** */
	if(_flags.pendingReshape)
	{
		[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: NO];
		[[self superview] setNeedsDisplayInRect: [self frame]];
		highestViewNeedingDisplay = [self superview];
		[self setFrameSize: _size];
		[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: NO];
		[self setNeedsDisplay: YES];
//		[self display];
		_flags.pendingReshape = NO;
	}
		/* ** push and pop handling ** */
	if(_flags.pendingPushPop == YES)
	{
		if(_flags.doPushOp == YES)
		{
			GLUTView *	superview = (GLUTView *) [self superview];
			
			[self removeFromSuperview];
			[superview addSubview: self positioned: NSWindowAbove relativeTo: nil];
			[self setNeedsDisplay: YES];
		}
		else
		{
			GLUTView *	superview = (GLUTView *) [self superview];
			
			[self removeFromSuperview];
			[superview addSubview: self positioned: NSWindowBelow relativeTo: nil];
			[[self superview] setNeedsDisplay: YES];
			highestViewNeedingDisplay = [self superview];
		}
		[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: NO];
		_flags.pendingPushPop = NO;
	}
		/* ** show and hide handling ** */
	if(_flags.pendingShowHide == YES)
	{
		if(_flags.doShowOp == YES)
		{
				/* show */
			[self _recursivelyMarkAsVisibilityUnknown];
			[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: NO];
			[self setNeedsDisplay: YES];
//			[self display];
		}
		else
		{
				/* hide */
			[self _recursivelyMarkAsHidden];
			[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: NO];
			[[self superview] setNeedsDisplay: YES];
			highestViewNeedingDisplay = [self superview];
	//		[[[self window] contentView] display];
		}
		_flags.pendingShowHide = NO;
	}
	
		/* draw ourselves */
	[highestViewNeedingDisplay displayIfNeeded];
	
//	if(_flags.pendingRedisplay == YES)
//		[self display];
	
		/* draw overlay */
	if(_overlay)
	{
		[self lockFocus];
			[_overlay displayInRect: [self visibleRect]];
		[self unlockFocus];
	}
}

	/* Determines and returns the window status of the receiver. */
- (int)determineWindowStatusIgnoringSiblings: (BOOL)ignoreSiblings
{
	NSRect				myFrame = [self convertRect: [self bounds] toView: nil];
	NSArray *			siblings = nil, *childs = [self subviews];
	register unsigned	i, count;
	
	if(_windowStatus == GLUT_UNKNOWN_VISIBILITY && _flags.pendingShowHide == YES)
	{
		if(_flags.doShowOp == NO)
			_windowStatus = GLUT_HIDDEN;
	}
	
	if(_windowStatus == GLUT_HIDDEN)
		return GLUT_HIDDEN;
	
		// are we occluded by siblings ?
	if(ignoreSiblings == NO && self != [[self window] contentView])
	{
		siblings	= [[self superview] subviews];
		count		= [siblings count];
		if(count > 1)		// if we are the only child of our parent views, there can't hardly be any sibling
		{
				// In order to support comparisons between contentViews, which represent our top-level windows,
				// we need to transform all coords in the screen coord-system.
			myFrame.origin = [[self window] convertBaseToScreen: myFrame.origin];
			
				// consider views which are on top of us, only !
			for(i = [siblings indexOfObjectIdenticalTo: self]; i < count; i++)
			{
				GLUTView *	aSibling = [siblings objectAtIndex: i];
				
				if(aSibling != self)
				{
					NSRect	hisFrame = [aSibling convertRect: [aSibling bounds] toView: nil];
					
					hisFrame.origin = [[aSibling window] convertBaseToScreen: hisFrame.origin];
					
#if defined(VERBOSE)
					NSLog(@"myViewFrame: %@\n", NSStringFromRect([self frame]));
					NSLog(@"myFrame: %@\n", NSStringFromRect(myFrame));
					NSLog(@"hisViewFrame: %@\n", NSStringFromRect([aSibling frame]));
					NSLog(@"hisFrame: %@\n", NSStringFromRect(hisFrame));
#endif

					if([aSibling windowStatus] == GLUT_HIDDEN)
						continue;
					if(NSContainsRect(hisFrame, myFrame) == YES)
						return GLUT_FULLY_COVERED;
					else if(NSIntersectsRect(hisFrame, myFrame) == YES)
						return GLUT_PARTIALLY_RETAINED;
				}
			}
		}
	}
	
		// are we occluded by childs ?
	if(childs && [childs count] > 0)
	{
		count = [childs count];
		for(i = 0; i < count; i++)
		{
			GLUTView *	aChild = [childs objectAtIndex: i];
			NSRect		hisFrame = [aChild convertRect: [aChild bounds] toView: nil];
			
			if([aChild windowStatus] == GLUT_HIDDEN)
				continue;
			if(NSContainsRect(hisFrame, myFrame) == YES)
				return GLUT_FULLY_COVERED;
			else if(NSIntersectsRect(hisFrame, myFrame) == YES)
				return GLUT_PARTIALLY_RETAINED;
		}
	}
	
	return GLUT_FULLY_RETAINED;
}

- (void)updateWindowStatus: (int)state
{
	if(_windowStatus == state)
		return;
		
	_windowStatus = state;
	
	if(_windowStatusCallback || _visibilityCallback)
	{
		[self makeCurrent];
		
		if(_visibilityCallback)
			(*_visibilityCallback)((_windowStatus == GLUT_HIDDEN || _windowStatus == GLUT_FULLY_COVERED) ? GLUT_NOT_VISIBLE : GLUT_VISIBLE);
		if(_windowStatusCallback)
			(*_windowStatusCallback)(_windowStatus);
				
		if(__glutDebug)
			glutReportErrors();
	}
}

- (int)windowStatus
{
	return _windowStatus;
}

#if defined(GFXLIB_MESA26)
- (void)flushGraphics
{
	[_visual swapBuffers];
}
#endif

@end
