
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */


#import <Foundation/Foundation.h>



/* *** constants *** */

/* Frame buffer capability macros and types. */
#define DS_RGBA                    0
#define DS_BUFFER_SIZE             1
#define DS_DOUBLEBUFFER            2
#define DS_STEREO                  3
#define DS_AUX_BUFFERS             4
#define DS_RED_SIZE                5  /* Used as mask bit for
               	                       "color selected". */
#define DS_GREEN_SIZE              6
#define DS_BLUE_SIZE               7
#define DS_ALPHA_SIZE              8
#define DS_DEPTH_SIZE              9
#define DS_STENCIL_SIZE            10
#define DS_ACCUM_RED_SIZE          11  /* Used as mask bit for
               	                        "acc selected". */
#define DS_ACCUM_GREEN_SIZE        12
#define DS_ACCUM_BLUE_SIZE         13
#define DS_ACCUM_ALPHA_SIZE        14
#define DS_LEVEL                   15

#define DS_NUM_GLXCAPS             (DS_LEVEL + 1)

#define DS_XVISUAL                 (DS_NUM_GLXCAPS + 0)
#define DS_TRANSPARENT             (DS_NUM_GLXCAPS + 1)
#define DS_SAMPLES                 (DS_NUM_GLXCAPS + 2)
#define DS_XSTATICGRAY             (DS_NUM_GLXCAPS + 3)  /* Used as
              	     		                                   mask bit
              	   	                                     for "any
              		                                        visual type 
                        		                              selected". */
#define DS_XGRAYSCALE              (DS_NUM_GLXCAPS + 4)
#define DS_XSTATICCOLOR            (DS_NUM_GLXCAPS + 5)
#define DS_XPSEUDOCOLOR            (DS_NUM_GLXCAPS + 6)
#define DS_XTRUECOLOR              (DS_NUM_GLXCAPS + 7)
#define DS_XDIRECTCOLOR            (DS_NUM_GLXCAPS + 8)
#define DS_SLOW                    (DS_NUM_GLXCAPS + 9)
#define DS_CONFORMANT              (DS_NUM_GLXCAPS + 10)

#define DS_NUM_CAPS                (DS_NUM_GLXCAPS + 11)

/* Frame buffer capablities that don't have a corresponding
   FrameBufferMode entry.  These get used as mask bits. */
#define DS_NUM								(DS_NUM_CAPS + 0)
#define DS_RGBA_MODE						(DS_NUM_CAPS + 1)
#define DS_CI_MODE						(DS_NUM_CAPS + 2)
#define DS_LUMINANCE_MODE				(DS_NUM_CAPS + 3)

#define DS_NONE		0
#define DS_EQ			1
#define DS_NEQ			2
#define DS_LTE			3
#define DS_GTE			4
#define DS_GT			5
#define DS_LT			6
#define DS_MIN			7


/* *** structures *** */


typedef struct GLUTCriterion
{
	int	capability;
	int	comparison;
	int	value;
} GLUTCriterion;


typedef struct GLUTVisualInfo
{
	int				valid;
	int				cap[DS_NUM_CAPS];
} GLUTVisualInfo;

/* DisplayMode capability macros for game mode. */
#define DM_WIDTH        0  /* "width" */
#define DM_HEIGHT       1  /* "height" */
#define DM_PIXEL_DEPTH  2  /* "bpp" (bits per pixel) */
#define DM_HERTZ        3  /* "hertz" */
#define DM_NUM          4  /* "num" */

#define NUM_DM_CAPS     (DM_NUM+1)

typedef struct GLUTDisplayMode
{
	int	valid;
	int	cap[NUM_DM_CAPS];
} GLUTDisplayMode;


/* *** visual class *** */


@interface GLUTVisual : NSObject
{
	const GLUTVisualInfo *			_visualInfo;
	int									_width;
	int									_height;
}

+ (BOOL)canCreateInstanceWithString: (const char *)dstring;
+ (BOOL)canCreateInstanceWithString: (const char *)dstring requiredCriteria: (const GLUTCriterion *)requiredCriteria count: (int)nRequired requiredCriteriaMask: (int)requiredMask;

		/* visual info */
+ (const GLUTVisualInfo *)visualInfoFromString: (const char *)string treatAsSingle: (BOOL *)yesno requiredCriteria: (const GLUTCriterion *)requiredCriteria count: (int)nRequired requiredCriteriaMask: (int)requiredMask;
+ (const GLUTVisualInfo *)makeVisualInfos: (int *)numModes;

		/* visual creation */
+ (id)visualWithString: (const char *)displayString pixelsWide: (int)width pixelsHigh: (int)height requiredCriteria: (const GLUTCriterion *)crits count: (unsigned int)critscount requiredCriteriaMask: (int)mask;


- (id)initWithString: (const char *)displayString pixelsWide: (int)width pixelsHigh: (int)height requiredCriteria: (const GLUTCriterion *)crits count: (unsigned int)critscount requiredCriteriaMask: (int)mask;
		
		/* attributes */
- (const GLUTVisualInfo *)visualInfo;
- (void)setVisualInfo: (const GLUTVisualInfo *)info;
- (int)visualInfoID;
- (NSSize)size;
- (void)setSize: (NSSize)newSize;
- (int)pixelsWide;
- (int)pixelsHigh;
- (BOOL)isDoubleBuffered;
- (BOOL)treatAsSingle;

		/* operations */
- (void)makeCurrent;
- (void)makeNotCurrent;
- (void)swapBuffers;
		
@end
