
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */


#import <AppKit/AppKit.h>
#import "macxglut_private.h"






/* *** GLUT window class *** */

@class GLUTView;
@class GLUTVisual;
@class GLUTOverlay;


@interface GLUTWindow : NSWindow <GLUTWindows>
{
@private
		
	GLUTView *				_view;							/* weak ref */
	NSString *				_imagePath;						/* last path used to save the window contents */
	struct __gwFlags {
		unsigned int			pendingShowHide	: 1;
		unsigned int			doShowOp				: 1;
		unsigned int			pendingPushPop		: 1;
		unsigned int			doPushOp				: 1;
		unsigned int			pendingMove			: 1;
		unsigned int			pendingReshape		: 1;
		unsigned int			pendingFullScreen	: 1;
		unsigned int			pendingIconify		: 1;
		unsigned int			reserved0			: 8;
	}						_flags;
	int					_windowKey;
	NSPoint				_positionInXWindowsCoords;
	NSPoint				_pos;
	NSSize				_size;
}

- (id)initWithTitle: (NSString *)title displayString: (const char *)dstring gameMode: (BOOL)isGameMode;
- (void)dealloc;

		/* accessors */
- (GLUTVisual *)visual;
- (GLUTOverlay *)overlay;
- (NSPoint)windowPositionRelativeToParent: (BOOL)yesno;
- (NSSize)windowSize;
- (BOOL)isSubWindow;
- (BOOL)isDamaged;
- (id <GLUTWindows>)parentWindow;
- (int)numberOfSubWindows;
- (NSWindow *)nativeWindow;
- (int)modifierFlags;
- (BOOL)ignoreKeyRepeats;
- (void)setIgnoreKeyRepeats: (BOOL)yesno;
- (NSTimeInterval)joystickPollInterval;
- (void)setWindowKey: (int)key;

	/* child management */
- (void)addSubWindow: (id <GLUTWindows>)subwindow;

		/* cursor */
- (int)cursor;
- (void)setCursor: (int)num;

		/* make this window the current one */
- (void)makeCurrent;
- (void)makeNotCurrent;
- (void)swapBuffers;

	/* callbacks */
- (void)setKeyboardCallback: (GLUTKeyboardCallback)func isKeyDown: (BOOL)yesno;
- (void)setMouseCallback: (GLUTMouseCallback)func;
- (void)setMotionCallback: (GLUTMotionCallback)func;
- (void)setPassiveMotionCallback: (GLUTMotionCallback)func;
- (void)setEntryCallback: (GLUTEntryCallback)func;
- (void)setSpecialCallback: (GLUTSpecialCallback)func isKeyDown: (BOOL)yesno;
- (void)setDisplayCallback: (GLUTDisplayCallback)func;
- (void)setReshapeCallback: (GLUTReshapeCallback)func;
- (void)setWindowStatusCallback: (GLUTWindowStatusCallback)func;
- (void)setVisibilityCallback: (GLUTVisibilityCallback)func;
- (void)setSpaceballMotionCallback: (GLUTSpaceballMotionCallback)func;
- (void)setSpaceballRotateCallback: (GLUTSpaceballRotateCallback)func;
- (void)setSpaceballButtonCallback: (GLUTSpaceballButtonCallback)func;
- (void)setButtonBoxCallback: (GLUTButtonBoxCallback)func;
- (void)setDialCallback: (GLUTDialCallback)func;
- (void)setTabletMotionCallback: (GLUTTabletMotionCallback)func;
- (void)setTabletButtonCallback: (GLUTTabletButtonCallback)func;
- (void)setJoystickCallback: (GLUTJoystickCallback)func pollInterval: (NSTimeInterval)delay;

		/* overlay management */
- (void)establishOverlay;
- (void)removeOverlay;
- (void)setUsesLayer: (GLenum)layer;
		
		/* root window specific attributes */
- (void)setIconTitle: (NSString *)title;

		/* window update state */
- (void)setNeedsStateUpdate: (BOOL)yesno;
- (BOOL)needsStateUpdate;

		/* defered operations */
- (void)postRedisplay;
- (void)setPosition: (NSPoint)position;
- (void)setSize: (NSSize)size;
- (void)setToFullScreen;
- (void)push;
- (void)pop;
- (void)show;
- (void)hide;
- (void)iconify;
- (void)updateWindowState;

- (void)updateWindowStatus: (int)status;
- (int)determineWindowStatusIgnoringSiblings: (BOOL)ignoreSiblings;
- (int)windowStatus;

		/* reading window contents */
- (NSData *)contentsAsDataOfType: (NSString *)pboardType;

@end
