
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTWindow.h"
#import "GLUTWindow_Private.h"
#import "GLUTView.h"
#import "GLUTView_Private.h"
#import "GLUTApplication.h"










/* ***************** GLUTWindow(GLUTPrivate) category implementation ******************** */


@implementation GLUTWindow(GLUTPrivate)


NSPoint		__glutLastTopLeftPoint;
BOOL			__glutIsLastTopLeftPointSet = NO;



+ (void)initialize
{
	static BOOL initialized = NO;
	NSArray *	sendTypes;
	
		/* Make sure code only gets executed once. */
	if(initialized == NO)
	{
		initialized = YES;
		
		sendTypes = [NSArray arrayWithObjects: NSTIFFPboardType, NSPostScriptPboardType, NSRTFDPboardType, nil];
		[NSApp registerServicesMenuSendTypes: sendTypes returnTypes: nil];
	}
}


	/* ** menu support ** */


- (BOOL)validateMenuItem: (id<NSMenuItem>)menuItem
{
	if([menuItem action] == @selector(save:) || [menuItem action] == @selector(saveAs:))
		return [self isDocumentEdited];
	
	if([menuItem action] == @selector(copy:))
		return YES;
	
	return [super validateMenuItem: menuItem];
}

- (IBAction)save: (id)sender
{
	if(_imagePath != nil)
	{
		[self _writeToFile: _imagePath];
		[self setDocumentEdited: NO];
	}
	else
		[self saveAs: sender];
}

	/* Present a NSSavePanel to the user and write the receiving's window contents to the path the user selected. */
- (IBAction)saveAs: (id)sender
{
	NSSavePanel *	savePanel = [NSSavePanel savePanel];
	NSString *		imageDirectory, *imageName;
	
	if(_imagePath == nil)
	{
		_imagePath = [[[NSFileManager defaultManager] currentDirectoryPath] copy];
		imageDirectory = _imagePath;
		imageName = @"";
	}
	else
	{
		imageDirectory = _imagePath;
		imageName = [[_imagePath lastPathComponent] stringByDeletingPathExtension];
	}
	
	if([savePanel runModalForDirectory: imageDirectory file: imageName] == NSOKButton)
	{
		[_imagePath release];
		_imagePath = [[savePanel filename] retain];
		[self _writeToFile: _imagePath];
		[self setDocumentEdited: NO];
	}
}

	/* Put the current contents of the receiving window onto the general pasteboard. */
- (IBAction)copy: (id)sender
{
	NSString *	type = NSTIFFPboardType;
	NSData *		imageData = [self contentsAsDataOfType: type];
	
	if(imageData)
	{
		NSPasteboard *	generalPboard = [NSPasteboard generalPasteboard];
		
		[generalPboard declareTypes: [NSArray arrayWithObjects: type, nil] owner: nil];
		[generalPboard setData: imageData forType: type];
	}
}

	/* Services support */
- (id)validRequestorForSendType:(NSString *)sendType returnType:(NSString *)returnType
{
	if(sendType)
	{
		if([sendType isEqualToString: NSTIFFPboardType] == YES ||
			[sendType isEqualToString: NSPostScriptPboardType] == YES ||
			[sendType isEqualToString: NSRTFDPboardType] == YES)
				return self;
	}
	
	return [super validRequestorForSendType: sendType returnType: returnType];
}

- (BOOL)writeSelectionToPasteboard:(NSPasteboard *)pboard types:(NSArray *)types
{
	register unsigned	i, count = [types count];
	
	for(i = 0; i < count; i++)
	{
		NSString *	pboardType = [types objectAtIndex: i];
		NSData *		imageData = [self contentsAsDataOfType: pboardType];
		
		if(imageData)
		{
			[pboard declareTypes: [NSArray arrayWithObject: pboardType] owner: nil];
			[pboard setData: imageData forType: pboardType];
			return YES;
		}
	}
	
	return NO;
}

- (NSRect)_frameRectForProposedRect: (NSRect)rect
{
	NSRect	frameRect;
	
	frameRect.origin = NSMakePoint(0.0, 0.0);
	
		/* determine window size */
	if((rect.size.width + frameRect.origin.x) >= (float) __glutScreenWidth)
		frameRect.size.width = (float) __glutScreenWidth - 5.0;
	else
		frameRect.size.width = rect.size.width;
	
	if((rect.size.height - frameRect.origin.y) >= (float) __glutScreenWidth)
		frameRect.size.height = (float) __glutScreenHeight - 5.0;
	else
		frameRect.size.height = rect.size.height;
		
		/* set window size & position */
	frameRect.size = [NSWindow	frameRectForContentRect: frameRect styleMask: [self styleMask]].size;

		/* determine window position */
	if(rect.origin.x < 0 && rect.origin.y < 0) 
	{
		if(__glutIsLastTopLeftPointSet == NO)
		{
			__glutLastTopLeftPoint = NSMakePoint(5.0, 0.0);
			__glutIsLastTopLeftPointSet = YES;
		}
		else
		{
			__glutLastTopLeftPoint = [self cascadeTopLeftFromPoint: __glutLastTopLeftPoint];
		}
		
		frameRect.origin = __glutLastTopLeftPoint;
		_positionInXWindowsCoords = frameRect.origin;
		frameRect.origin.y = (float) __glutScreenHeight - (frameRect.size.height + 5.0);
	}
	else
	{
			/* correct for screen origin difference in our and GLUT's model */
		frameRect.origin = rect.origin;
		_positionInXWindowsCoords = rect.origin;
		frameRect.origin.y = (float) __glutScreenHeight - frameRect.origin.y;
		frameRect.origin.y -= frameRect.size.height;
	}
	
	return frameRect;
}

- (void)_writeToFile: (NSString *)path
{
	NSData *	imageData = [self contentsAsDataOfType: NSTIFFPboardType];
	
	if(imageData == nil || [imageData writeToFile: [path stringByAppendingPathExtension: @"tiff"] atomically: YES] == NO)
	{
		NSRunCriticalAlertPanel(FWLocalizedString(@"Save Error"),
										FWLocalizedString(@"Unable to save current window contents."), @"OK", nil, nil);
	}
}

	/* Returns a TIFF bitmap image rep with our current graphics contents. */
- (NSBitmapImageRep *)_bitmapImageRepWithTIFFInsideContentView
{
	NSBitmapImageRep *	bitmapImageRep = nil;

	[_view lockFocus];
		bitmapImageRep = [[NSBitmapImageRep allocWithZone: [self zone]] initWithFocusedViewRect: [_view bounds]];
		if(bitmapImageRep == nil)
		{
			[_view unlockFocus];
			return nil;
		}
	[_view unlockFocus];

	return [bitmapImageRep autorelease];
}

#if defined(INTERCEPTOR_HATES_EPS)
		/* Interceptor and EPS generation does obviously not go together */
- (NSData *)_dataWithEPSInsideContentView
{
	NSImage *		myImage = nil;
	NSImageView *	myImageView = nil, *myImageViewWeakRef = nil;
	NSWindow *		myWindow = nil;
	NSData *			epsData = nil;
	
		// create a window containing an NSImageView to act as the EPS generator
	FailNil(myImageView = [[NSImageView allocWithZone: [self zone]]	initWithFrame: [_view bounds]]);
	FailNil(myWindow = [[NSWindow allocWithZone: [self zone]]	initWithContentRect: [_view bounds]
																			styleMask: NSBorderlessWindowMask
																			backing: NSBackingStoreNonretained
																			defer: NO]);
	
	[myWindow setContentView: myImageView];
	[myImageView release]; myImageViewWeakRef = myImageView; myImageView = nil;
		// create an NSImage containing the actual window contents as TIFF graphics
	FailNil(myImage = [[NSImage allocWithZone: [self zone]] init]);	
	[myImage addRepresentation: [self _bitmapImageRepWithTIFFInsideContentView]];
	[myImageViewWeakRef setImage: myImage];
	[myImage release]; myImage = nil;
	
		// generate the EPS data
	epsData = [myImageViewWeakRef dataWithEPSInsideRect: [myImageViewWeakRef bounds]];
	[myWindow release];
	return epsData;
		
_failed:
	[myWindow release];
	[myImageView release];
	[myImage release];
	
	return nil;
}
#endif

- (NSData *)_dataWithRTFDInsideContentView
{
	static int				generationCounter = 1;
	NSAttributedString *	myString = nil;
	NSFileWrapper *		myFileWrapper = nil;
	NSTextAttachment *	myTextAttachment = nil;
	NSData *					tiffData = [[self _bitmapImageRepWithTIFFInsideContentView] TIFFRepresentation];
		
		// create the file wrapper
	FailNil(myFileWrapper = [[NSFileWrapper allocWithZone: [self zone]] initRegularFileWithContents: tiffData]);
	[myFileWrapper setPreferredFilename: [NSString stringWithFormat: @"GLUT Picture No.%d.tiff", generationCounter++]];
	
		// create the text attachment
	FailNil(myTextAttachment = [[NSTextAttachment allocWithZone: [self zone]] initWithFileWrapper: myFileWrapper]);
	[myFileWrapper release]; myFileWrapper = nil;
	
		// create the attributed string
	myString = [NSAttributedString attributedStringWithAttachment: myTextAttachment];
	[myTextAttachment release]; myTextAttachment = nil;
		
		// return the flattend data
	return [myString RTFDFromRange: NSMakeRange(0, [myString length]) documentAttributes: nil];
	
_failed:
	[myTextAttachment release];
	[myFileWrapper release];
	
	return nil;
}

	/* We keep the drawRect: locked until the window is actually visible. */
- (void)makeKeyAndOrderFront: (id)sender
{
	[super makeKeyAndOrderFront: sender];
	[_view _recursivelyUnlockDrawing];
}

	/* Although we don't have a border in game mode we want to se key donw events. */
- (BOOL)canBecomeKeyWindow
{
	if(__glutGameMode == NO)
		return [super canBecomeKeyWindow];
	else
		return YES;
}

@end
