
/* Copyright (c) Mark J. Kilgard, 1994. */
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTApplication.h"
#import "GLUTMenu.h"
#import "GLUTWindow.h"
#import "GLUTView.h"


/* GLUT inter-file variables */
int							__glutArgc = 0;
char **						__glutArgv = NULL;
char *						__glutGeometry = NULL;
int							__glutScreenHeight;
int							__glutScreenWidth;
BOOL							__glutIconic = NO;
BOOL							__glutDebug = NO;
unsigned int				__glutDisplayMode = 0;
char *						__glutDisplayString = NULL;
int							__glutInitWidth = 300;
int							__glutInitHeight = 300;
int							__glutInitX = -1;
int							__glutInitY = -1;
NSMapTable *				__glutWindowList = NULL;				/* list of GLUT top-level & sub- windows */
id<GLUTWindows>			__glutCurrentWindow = nil;			/* current GLUT window */
int							__glutGameModeWindow = 0;
NSMapTable *				__glutMenuList = NULL;
GLUTMenu *					__glutCurrentMenu = nil;
GLUTMenuStatusCallback	__glutMenuStatusCallback = NULL;
GLUTIdleCallback			__glutIdleCallback = NULL;
GLUTTimerCallback			__glutTimerCallback = NULL;
int							__glutTimerValue = 0;
BOOL							__glutFinishedInitialization = NO;
NSTimeInterval				__glutPeriodicEventDelay = GLUT_PERIODIC_DELAY;
int							__glutWindowUniqueID = 0;
int							__glutMenuUniqueID = 0;
BOOL							__glutMenuMode = NO;
BOOL							__glutGameMode = NO;
NSTimer *					__glutPeriodicObject = nil;
BOOL							__glutEmulateMultiButtonMouse = NO;




static void	removeArgs(int *argcp, char **argv, int numToRemove);
static int	ReadInteger(char *string, char **NextString);
static int	XParseGeometry(char *string, int *x, int *y, unsigned int *width, unsigned int *height);


/* 
 * Bitmask returned by XParseGeometry().  Each bit tells if the corresponding
 * value (x, y, width, height) was found in the parsed string.
 */
#define NoValue		0x0000
#define XValue  		0x0001
#define YValue			0x0002
#define WidthValue  	0x0004
#define HeightValue	0x0008
#define AllValues 	0x000F
#define XNegative 	0x0010
#define YNegative 	0x0020







void APIENTRY glutInit(int *argcp, char **argv)
{
	char *			geometry = NULL;
	int				i;
	struct timeval	unused;
	
	if(NSApp != nil)
	{
		__glutWarning("glutInit being called a second time.");
		return;
	}
	
	glutInitDisplayMode(GLUT_RGB | GLUT_SINGLE | GLUT_DEPTH);
	
		/* Initialize our application instance */
	(void) [[NSAutoreleasePool alloc] init];
	NSApp = [[GLUTApplication alloc] init];
	__glutWindowList		= NSCreateMapTable(NSIntMapKeyCallBacks, NSObjectMapValueCallBacks, 4);
	__glutMenuList			= NSCreateMapTable(NSIntMapKeyCallBacks, NSObjectMapValueCallBacks, 4);
	
		/* Make private copy of command line arguments. */
	__glutArgc = *argcp;
	__glutArgv = (char **) malloc(__glutArgc * sizeof(char *));
	if(!__glutArgv)
		__glutFatalError("out of memory.");
	for(i = 0; i < __glutArgc; i++)
	{
		__glutArgv[i] = __glutStrdup(argv[i]);
		if(!__glutArgv[i])
			__glutFatalError("out of memory.");
	}
	
		/* parse arguments for standard options */
	for(i = 1; i < __glutArgc; i++)
	{
		if(!strcmp(__glutArgv[i], "-display"))
		{
			__glutWarning("-display option invalid for MacOS X glut.");
			if(__glutArgv[i + 1][0] != '-')
				i++;
			removeArgs(argcp, &argv[1], 2);
		}
		else if(!strcmp(__glutArgv[i], "-geometry"))
		{
			if(++i >= __glutArgc)
				__glutFatalError("follow -geometry option with geometry parameter.");
			geometry = __glutArgv[i];
			removeArgs(argcp, &argv[1], 2);
		}
		else if(!strcmp(__glutArgv[i], "-direct"))
		{
			__glutWarning("-direct option invalid for MacOS X glut.");
			removeArgs(argcp, &argv[1], 1);
		}
		else if(!strcmp(__glutArgv[i], "-indirect"))
		{
			__glutWarning("-indirect option invalid for MacOS X glut.");
			removeArgs(argcp, &argv[1], 1);
		}
		else if(!strcmp(__glutArgv[i], "-iconic"))
		{
			__glutWarning("-iconic option not supported in this MacOS X glut version.");
			__glutIconic = GL_TRUE;
			removeArgs(argcp, &argv[1], 1);
		}
		else if(!strcmp(__glutArgv[i], "-gldebug"))
		{
			__glutDebug = GL_TRUE;
			removeArgs(argcp, &argv[1], 1);
		}
		else if(!strcmp(__glutArgv[i], "-sync"))
		{
			__glutWarning("-sync option invalid for MacOS X glut.");
			removeArgs(argcp, &argv[1], 1);
		}
		else if(!strcmp(__glutArgv[i], "-idle"))
		{
			__glutPeriodicEventDelay = strtod(__glutArgv[++i], NULL);
			if(__glutPeriodicEventDelay == 0.0 || errno == ERANGE)
				__glutPeriodicEventDelay = GLUT_PERIODIC_DELAY;
			removeArgs(argcp, &argv[1], 2);
		}
		else if(!strcmp(__glutArgv[i], "-multimouse"))
		{
			__glutEmulateMultiButtonMouse = GL_FALSE;
			removeArgs(argcp, &argv[1], 1);
		}
		else
		{
			/* Once unknown option encountered, stop command line processing. */
			break;
		}
	}
		
		/* set default window management options */
	__glutScreenWidth		= (int) [[NSScreen mainScreen] visibleFrame].size.width;
	__glutScreenHeight	= (int) [[NSScreen mainScreen] visibleFrame].size.height;
	
	if(geometry)
	{
		int	flags, x, y, width = 0, height = 0;
		
		flags = XParseGeometry(geometry, &x, &y, (unsigned int *) &width, (unsigned int *) &height);
		
		if(WidthValue & flags)
		{
				/* Careful because X does not allow zero or negative width windows */
			if(width > 0)
				__glutInitWidth = width;
		}
		if(HeightValue & flags)
		{
				/* Careful because X does not allow zero or negative height windows */
			if(height > 0)
				__glutInitHeight = height;
		}
		glutInitWindowSize(__glutInitWidth, __glutInitHeight);
		
		if(XValue & flags)
		{
			if(XNegative & flags)
				x = __glutScreenWidth + x - __glutInitWidth;
			if(x >= 0)
				__glutInitX = x;
		}
		if(YValue & flags)
		{
			if(YNegative & flags)
				y = __glutScreenHeight + y - __glutInitHeight;
			if(y >= 0)
				__glutInitY = y;
		}
		glutInitWindowPosition(__glutInitX, __glutInitY);
	}
	
	__glutInitTime(&unused);
}

void APIENTRY glutInitWindowPosition(int x, int y)
{
	__glutInitX = x;
	__glutInitY = y;
}

void APIENTRY glutInitWindowSize(int width, int height)
{
	__glutInitWidth = width;
	__glutInitHeight = height;
	
	if(width <= 0)
		__glutInitWidth = 300;
	if(height <= 0)
		__glutInitHeight = 300;
}

void APIENTRY glutInitDisplayMode(unsigned int mask)
{
	__glutDisplayMode = mask;
	if(__glutDisplayString)
	{
		free(__glutDisplayString);
		__glutDisplayString = NULL;
	}
	
	__glutDisplayString = __glutDisplayStringFromDisplayMode(mask);
	if(!__glutDisplayString)
		__glutFatalError("out of memory.");
}

void APIENTRY glutInitDisplayString(const char *string)
{
	if(__glutDisplayString)
	{
		free(__glutDisplayString);
		__glutDisplayString = NULL;
	}
	
	if(string)
		__glutDisplayString = __glutStrdup(string);
	else
		__glutDisplayString = __glutDisplayStringFromDisplayMode(GLUT_RGB | GLUT_SINGLE | GLUT_DEPTH);
	
	if(!__glutDisplayString)
		__glutFatalError("out of memory.");
}





void __glutInitTime(struct timeval *beginning)
{
	static int		beenhere = 0;
	static struct	timeval genesis;
	
	if(!beenhere)
	{
		gettimeofday(&genesis, (struct timezone *) NULL);
		beenhere = 1;
	}
	*beginning = genesis;
}

static void removeArgs(int *argcp, char **argv, int numToRemove)
{
	int i, j;

	for(i = 0, j = numToRemove; argv[j]; i++, j++)
		argv[i] = argv[j];

	argv[i] = NULL;
	*argcp -= numToRemove;
}


/* the following function was stolen from the X sources as indicated. */

/* Copyright 	Massachusetts Institute of Technology  1985, 1986, 1987 */
/* $XConsortium: XParseGeom.c,v 11.18 91/02/21 17:23:05 rws Exp $ */

/*
Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in advertising or
publicity pertaining to distribution of the software without specific,
written prior permission.  M.I.T. makes no representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
*/

/*
 *    XParseGeometry parses strings of the form
 *   "=<width>x<height>{+-}<xoffset>{+-}<yoffset>", where
 *   width, height, xoffset, and yoffset are unsigned integers.
 *   Example:  "=80x24+300-49"
 *   The equal sign is optional.
 *   It returns a bitmask that indicates which of the four values
 *   were actually found in the string.  For each value found,
 *   the corresponding argument is updated;  for each value
 *   not found, the corresponding argument is left unchanged. 
 */

static int ReadInteger(char *string, char **NextString)
{
    register int Result = 0;
    int Sign = 1;
    
    if (*string == '+')
	string++;
    else if (*string == '-')
    {
	string++;
	Sign = -1;
    }
    for (; (*string >= '0') && (*string <= '9'); string++)
    {
	Result = (Result * 10) + (*string - '0');
    }
    *NextString = string;
    if (Sign >= 0)
	return (Result);
    else
	return (-Result);
}

static int XParseGeometry(char *string, int *x, int *y, unsigned int *width, unsigned int *height)
{
	int					mask = NoValue;
	register char *	strind;
	unsigned int		tempWidth = 0, tempHeight = 0;
	int					tempX = 0, tempY = 0;
	char *				nextCharacter;
	
	if ( (string == NULL) || (*string == '\0')) return(mask);
	if (*string == '=')
		string++;  /* ignore possible '=' at beg of geometry spec */
	
	strind = (char *)string;
	if (*strind != '+' && *strind != '-' && *strind != 'x') {
		tempWidth = ReadInteger(strind, &nextCharacter);
		if (strind == nextCharacter) 
		    return (0);
		strind = nextCharacter;
		mask |= WidthValue;
	}
	
	if (*strind == 'x' || *strind == 'X') {	
		strind++;
		tempHeight = ReadInteger(strind, &nextCharacter);
		if (strind == nextCharacter)
		    return (0);
		strind = nextCharacter;
		mask |= HeightValue;
	}
	
	if ((*strind == '+') || (*strind == '-')) {
		if (*strind == '-') {
  			strind++;
			tempX = -ReadInteger(strind, &nextCharacter);
			if (strind == nextCharacter)
			    return (0);
			strind = nextCharacter;
			mask |= XNegative;
		
		}
		else
		{	strind++;
			tempX = ReadInteger(strind, &nextCharacter);
			if (strind == nextCharacter)
			    return(0);
			strind = nextCharacter;
		}
		mask |= XValue;
		if ((*strind == '+') || (*strind == '-')) {
			if (*strind == '-') {
				strind++;
				tempY = -ReadInteger(strind, &nextCharacter);
				if (strind == nextCharacter)
			    	    return(0);
				strind = nextCharacter;
				mask |= YNegative;
			
			}
			else
			{
				strind++;
				tempY = ReadInteger(strind, &nextCharacter);
				if (strind == nextCharacter)
			    	    return(0);
				strind = nextCharacter;
			}
			mask |= YValue;
		}
	}
	
	/* If strind isn't at the end of the string the it's an invalid
		geometry specification. */

	if (*strind != '\0') return (0);

	if (mask & XValue)
	    *x = tempX;
 	if (mask & YValue)
	    *y = tempY;
	if (mask & WidthValue)
            *width = tempWidth;
	if (mask & HeightValue)
            *height = tempHeight;
	return (mask);
}
