
/* Copyright (c) Mark J. Kilgard, 1994. */
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"




static 	char					fmtresult[1024];







/* ***************** GLUT API *************** */


void APIENTRY glutReportErrors(void)
{
	GLenum	error;
	
	while((error = glGetError()) != GL_NO_ERROR)
		__glutWarning("GL error: %s", gluErrorString(error));
}





char *__glutDisplayStringFromDisplayMode(unsigned int mask)
{
	char		displayString[128];
	char *	cp = displayString;
	
		// luminance
	if(mask & GLUT_LUMINANCE)
	{
		mask |= ~GLUT_INDEX;
		strcpy(cp, "luminance");
		cp += 9;
		*cp++ = ' ';
	}
	
		// index, rgba, rgb		
	if(mask & GLUT_INDEX)
	{
		strcpy(cp, "index");
		cp += 5;
		*cp++ = ' ';
	}
	else
	{
		if(mask & GLUT_ALPHA)
		{
			strcpy(cp, "rgba");
			cp += 4;
		}
		else
		{
			strcpy(cp, "rgb");
			cp += 3;
		}
		*cp++ = ' ';
	}
	
		// depth
	if(mask & GLUT_DEPTH)
	{
		strcpy(cp, "depth");
		cp += 5;
		*cp++ = ' ';
	}
	
		// single, double
	if(mask & GLUT_DOUBLE)
	{
		strcpy(cp, "double");
		cp += 6;
	}
	else
	{
		strcpy(cp, "single");
		cp += 6;
	}
	*cp++ = ' ';
	
		// accum
	if(mask & GLUT_ACCUM)
	{
		if(mask & GLUT_ALPHA)
		{
			strcpy(cp, "acca");
			cp += 4;
		}
		else
		{
			strcpy(cp, "acc");
			cp += 3;
		}
		*cp++ = ' ';
	}
	
		// stencil
	if(mask & GLUT_STENCIL)
	{
		strcpy(cp, "stencil");
		cp += 7;
		*cp++ = ' ';
	}
		
		// stereo
	if(mask & GLUT_STEREO)
	{
		strcpy(cp, "stereo");
		cp += 6;
		*cp++ = ' ';
	}
		
		// multisample
	if(mask & GLUT_MULTISAMPLE)
	{
		strcpy(cp, "samples");
		cp += 7;
		*cp++ = ' ';
	}
	*cp = 0;

#if defined(VERBOSE)
	printf("%s\n", displayString);
	fflush(stdout);
#endif
	
	return __glutStrdup(displayString);
}

/* strdup is actually not a standard ANSI C or POSIX routine
   so implement a private one for GLUT.  OpenVMS does not have a
   strdup; Linux's standard libc doesn't declare strdup by default
   (unless BSD or SVID interfaces are requested). */
char *__glutStrdup(const char *string)
{
	char *copy;
	
	copy = malloc(strlen(string) + 1);
	if(copy == NULL)
		return NULL;
	strcpy(copy, string);	
	return copy;
}

void __glutWarning(char *format,...)
{
	va_list				args;
	NSMutableString *	errstr = [NSMutableString string];
	
	va_start(args, format);
		vsprintf(fmtresult, format, args);
	va_end(args);
	
	[errstr appendFormat: @"GLUT: Warning in %@: ", [[NSProcessInfo processInfo] processName]];
	[errstr appendFormat: @"%s\n", fmtresult];
	NSLog(errstr);
}

void __glutFatalError(char *format,...)
{
	va_list				args;
	NSMutableString *	errstr = [NSMutableString string];
	
	va_start(args, format);
		vsprintf(fmtresult, format, args);
	va_end(args);
	
	[errstr appendFormat: @"GLUT: Fatal Error in %@: ", [[NSProcessInfo processInfo] processName]];
	[errstr appendFormat: @"%s\n", fmtresult];
	NSLog(errstr);
	exit(1);
}

void __glutFatalUsage(char *format,...)
{
	va_list				args;
	NSMutableString *	errstr = [NSMutableString string];
	
	va_start(args, format);
		vsprintf(fmtresult, format, args);
	va_end(args);
	
	[errstr appendFormat: @"GLUT: Fatal API Usage in %@: ", [[NSProcessInfo processInfo] processName]];
	[errstr appendFormat: @"%s\n", fmtresult];
	NSLog(errstr);
	abort();
}
