// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniNetworking/ONHost-InternalAPI.h,v 1.3 1998/12/08 04:08:37 kc Exp $

#import "ONHost.h"


@interface ONHost (InternalAPI)
+ (void)_raiseExceptionForHostErrorNumber:(int)hostErrorNumber hostname:(NSString *)hostname;
- _initWithHostname:(NSString *)aHostname;
- (void)_lookupHostInfoByPipe;
@end


// If ONHOST_USE_THREADSAFE_LOOKUPD_GETHOSTBYNAME is defined then ONHost will use a threadsafe version of gethostbyname(); otherwise it will fall back to forking off an instance of the ONGetHostByName tool. This should be defined on those architectures that actually have lookupds.
#ifdef NeXT
#define ONHOST_USE_THREADSAFE_LOOKUPD_GETHOSTBYNAME
#endif


#ifdef ONHOST_USE_THREADSAFE_LOOKUPD_GETHOSTBYNAME

@class NSRecursiveLock;

@interface ONHost (LookupdHack)
- (void)_lookupHostInfoByLookupDaemon;
@end

OmniNetworking_PRIVATE_EXTERN BOOL ONHostNameLookupDebug;
OmniNetworking_PRIVATE_EXTERN NSRecursiveLock *ONHostLookupLock;

#endif
