// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniNetworking/ONInternetSocket.h,v 1.11 1998/12/08 04:08:41 kc Exp $

#import "ONSocket.h"

@class ONHost;
@class ONHostAddress;
@class ONServiceEntry;

#import <Foundation/NSDate.h> // For NSTimeInterval

@interface ONInternetSocket : ONSocket
{
    int socketFD;
    struct sockaddr_in *localAddress;
    struct sockaddr_in *remoteAddress;
    ONHost *remoteHost;
    struct {
        unsigned int listening:1;
        unsigned int connected:1;
        unsigned int userAbort:1;
    } flags;
}

+ (int)protocolFamily;
+ (int)socketType;
+ (int)protocol;

+ (ONInternetSocket *)socket;

- (void)setLocalPortNumber;
    // Sets the local port to any available local port number

- (void)setLocalPortNumber:(unsigned short int)port;
    // Sets the local port that will be used when sending and receiving messages.

- (void)setLocalPortNumber:(unsigned short int)port allowingAddressReuse:(BOOL)reuse;
    // Sets the local port that will be used when sending and receiving messages.  If reuse is true, other sockets will be allowed to use the same local port.


- (const struct sockaddr_in *)localAddress;
- (unsigned long int)localAddressHostNumber;
- (unsigned short int)localAddressPort;

- (ONHost *)remoteAddressHost;
- (const struct sockaddr_in *)remoteAddress;
- (unsigned long int)remoteAddressHostNumber;
- (unsigned short int)remoteAddressPort;

- (void)connectToHost:(ONHost *)host serviceEntry:(ONServiceEntry *)service;
    // Implemented in terms of -connectToHost:port:
- (void)connectToHost:(ONHost *)host port:(unsigned short int)port;
- (void)connectToAddress:(ONHostAddress *)hostAddress port:(unsigned short int)port;

- (BOOL)waitForInputWithTimeout:(NSTimeInterval)timeout;

- (void)setAllowsBroadcast:(BOOL)shouldAllowBroadcast;
// This really only makes sense for UDP and Multicast sockets

- (int)socketFD;

@end

#import "FrameworkDefines.h"

// Exceptions which may be raised by this class
OmniNetworking_EXTERN NSString *ONInternetSocketBindFailedExceptionName;
OmniNetworking_EXTERN NSString *ONInternetSocketReuseSelectionFailedExceptionName;
OmniNetworking_EXTERN NSString *ONInternetSocketBroadcastSelectionFailedExceptionName;
OmniNetworking_EXTERN NSString *ONInternetSocketConnectFailedExceptionName;
OmniNetworking_EXTERN NSString *ONInternetSocketConnectTemporarilyFailedExceptionName;
OmniNetworking_EXTERN NSString *ONInternetSocketGetNameFailedExceptionName;
OmniNetworking_EXTERN NSString *ONInternetSocketNotConnectedExceptionName;
OmniNetworking_EXTERN NSString *ONInternetSocketReadFailedExceptionName;
OmniNetworking_EXTERN NSString *ONInternetSocketUserAbortExceptionName;
OmniNetworking_EXTERN NSString *ONInternetSocketWriteFailedExceptionName;
OmniNetworking_EXTERN NSString *ONInternetSocketCloseFailedExceptionName;
