// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Developer/Source/CVS/OmniGroup/OmniNetworking/ONTCPSocket.h,v 1.5 1998/12/08 04:08:44 kc Exp $

#import "ONInternetSocket.h"

@interface ONTCPSocket : ONInternetSocket

+ (Class)defaultTCPSocketClass;
+ (void)setDefaultTCPSocketClass:(Class)aClass;

+ (ONTCPSocket *)tcpSocket;
    // This creates a socket of the defaultTCPSocketClass

- (void)startListeningOnAnyLocalPort;
- (void)startListeningOnLocalPort:(unsigned short int)port;
- (void)startListeningOnLocalService:(ONServiceEntry *)service;

- (void)acceptConnection;
- (ONTCPSocket *)acceptConnectionOnNewSocket;

@end

#import "FrameworkDefines.h"

// Exceptions which may be raised by this class
OmniNetworking_EXTERN NSString *ONTCPSocketListenFailedExceptionName;
OmniNetworking_EXTERN NSString *ONTCPSocketAcceptFailedExceptionName;
