
objc:teach $self {

- BOOL openWithName: {TclObj name} untitled: {BOOL untitled} {
    global NSApp window path addB sendTypesTV returnTypesTV language \
           code sendTypes returnTypes timeout hide unhide
    $window setTitleWithRepresentedFilename: [@ $name]
    set macros [lsort [objc:info macros NS*PboardType]]
    $sendTypesTV setList: $macros
    $returnTypesTV setList: $macros
    set language English
    if {$untitled} {
        $addB action: $self
    } elseif {![$self loadFromPath: [set path $name]]} {
        return [NO]
    }
    if {[set mainWindow [$NSApp mainWindow]] == "nil"} {
        $window center
    } else {
        lassign [$mainWindow frame] origin size
        lassign $origin x y
        lassign $size width height
        $window setFrameTopLeftPoint: \
            [$window cascadeTopLeftFromPoint: "$x [expr {$y + $height}]"]
    }
    $window makeKeyAndOrderFront: $self
    return [YES]
}

- TclObj name {
    global window
    * [$window representedFilename]
}

- window {
    global window
    return $window
}

- BOOL loadFromPath: {TclObj path} {
    global window initT namesTV deleteB \
           code sendTypes returnTypes timeout hide unhide menuItem keyEquiv
    catch {
        unset code sendTypes returnTypes timeout hide unhide menuItem keyEquiv
    }
    set services [NSDictionary dictionaryWithContentsOfFile: \
                    [@ [file join $path Resources Info.plist]]]
    if {[$services objectForKey: [@ JoyCode]] == "nil"} {
        NSRunAlertPanel [@ JoyServices] \
                        [@ "Not a JoyServices document: $path"] [@ Ok] nil nil
        return [NO]
    }
    $initT setString: [$services objectForKey: [@ JoyCode]]
    set names ""
    objc:foreach service [$services objectForKey: [@ NSServices]] {
        lappend names [set s [* [$service objectForKey: [@ NSUserData]]]]
        set code($s) [* [$service objectForKey: [@ JoyCode]]]
        set sendTypes($s) ""
        objc:foreach type [$service objectForKey: [@ NSSendTypes]] {
            lappend sendTypes($s) [* $type]
        }
        set returnTypes($s) ""
        objc:foreach type [$service objectForKey: [@ NSReturnTypes]] {
            lappend returnTypes($s) [* $type]
        }
        set timeout($s) [* [$service objectForKey: [@ NSTimeout]]]
        if {[set b [$service objectForKey: [@ JoyHide]]] == "nil"} {
            set hide($s) 1
        } else {
            set hide($s) [expr {[* $b] == "YES"}]
        }
        if {[set b [$service objectForKey: [@ JoyUnhide]]] == "nil"} {
            set unhide($s) 0
        } else {
            set unhide($s) [expr {[* $b] == "YES"}]
        }
        set dict [$service objectForKey: [@ NSMenuItem]]
        objc:foreach language [$dict allKeys] {
            set menuItem([list $s [* $language]]) \
                [* [$dict objectForKey: $language]]
        }
        set dict [$service objectForKey: [@ NSKeyEquivalent]]
        objc:foreach language [$dict allKeys] {
            set keyEquiv([list $s [* $language]]) \
                [* [$dict objectForKey: $language]]
        }
    }
    $namesTV setList: $names
    $self updateDisplay
    if {[llength $names] > 1} {
        $deleteB setEnabled: [YES]
    }
    $window setDocumentEdited: [NO]
    return [YES]
}

- BOOL saveToPath: {TclObj path} {
    global window initT namesTV \
           code sendTypes returnTypes timeout hide unhide menuItem keyEquiv
    $window makeFirstResponder: $window
    set services [NSMutableDictionary dictionary]
    $services setObject: [$initT string] forKey: [@ JoyCode]
    set array [NSMutableArray array]
    $services setObject: $array forKey: [@ NSServices]
    foreach s [$namesTV list] {
        set service [NSMutableDictionary dictionary]
        $array addObject: $service
        $service setObject: [@ JoyServer] forKey: [@ NSPortName]
        $service setObject: [@ joyService] forKey: [@ NSMessage]
        $service setObject: [@ $s] forKey: [@ NSUserData]
        $service setObject: [@ $code($s)] forKey: [@ JoyCode]
        if {$sendTypes($s) != ""} {
            set arr [NSMutableArray array]
            $service setObject: $arr forKey: [@ NSSendTypes]
            foreach type $sendTypes($s) {
                $arr addObject: [@ $type]
            }
        }
        if {$returnTypes($s) != ""} {
            set arr [NSMutableArray array]
            $service setObject: $arr forKey: [@ NSReturnTypes]
            foreach type $returnTypes($s) {
                $arr addObject: [@ $type]
            }
        }
        if {[[@ $timeout($s)] intValue] > 0} {
            $service setObject: [@ $timeout($s)] forKey: [@ NSTimeout]
        }
        $service setObject: [if {$hide($s)} {@ YES} {@ NO}] \
                    forKey: [@ JoyHide]
        $service setObject: [if {$unhide($s)} {@ YES} {@ NO}] \
                    forKey: [@ JoyUnhide]
        set dict [NSMutableDictionary dictionary]
        $service setObject: $dict forKey: [@ NSMenuItem]
        foreach n [array names menuItem [list $s *]] {
            if {$menuItem($n) != ""} {
                $dict setObject: [@ $menuItem($n)] forKey: [@ [lindex $n 1]]
            }
        }
        $dict setObject: [@ $s] forKey: [@ default]
        set dict [NSMutableDictionary dictionary]
        $service setObject: $dict forKey: [@ NSKeyEquivalent]
        foreach n [array names keyEquiv [list $s *]] {
            if {$keyEquiv($n) != ""} {
                $dict setObject: [@ $keyEquiv($n)] forKey: [@ [lindex $n 1]]
            }
        }
    }
    if {[catch {file mkdir [file join $path Resources]}] ||
        ![$services writeToFile: [@ [file join $path Resources Info.plist]] \
                     atomically: [YES]]} {
        NSRunAlertPanel [@ Save] \
                        [@ "Could not save document to $path"] [@ Ok] nil nil
        return [NO]
    }
    return [YES]
}

- selectSavePath {
    global window
    set savePanel [NSSavePanel savePanel]
    $savePanel setRequiredFileType: [@ service]
    set path [* [$window representedFilename]]
    if {[$savePanel runModalForDirectory: [@ [file dirname $path]] \
                                    file: [@ [file tail [$self name]]]] ==
        [NSCancelButton]} {
        return nil
    }
    return [$savePanel filename]
}

- void save: sender {
    global window path
    if {[info exists path]} {
        if {[$self saveToPath: $path]} {
            $window setDocumentEdited: [NO]
        }
    } else {
        $self saveAs: $sender
    }
}

- void saveAs: sender {
    global owner window path
    if {[set savePath [$self selectSavePath]] == "nil"} {
        return
    }
    set oldName [$self name]
    $window setTitleWithRepresentedFilename: $savePath
    $owner document: $self didChangeNameFrom: $oldName
    set path [* $savePath]
    $self save: $sender
}

- void saveTo: sender {
    if {[set savePath [$self selectSavePath]] == "nil"} {
        return
    }
    $self saveToPath: [* $savePath]
}

- void revert: sender {
    global window path 
    if {![$window isDocumentEdited] ||
        [NSRunAlertPanel [@ Revert] \
                [@ "Really revert changes to [file tail [$self name]]?"] \
                [@ Revert] [@ Cancel] nil] == [NSAlertDefaultReturn]} {
        $self loadFromPath: $path
    }
}

- BOOL validateMenuItem: item {
    global path
    if {[$item action] == "revert:" && ![info exists path]} {
        return [NO]
    }
    return [YES]
}

- BOOL windowShouldClose: note {
    global owner window
    if {[$window isDocumentEdited]} {
        switch -- [NSRunAlertPanel [@ Close] \
                        [@ "Save changes to [file tail [$self name]]?"] \
                        [@ Save] [@ {Don't Save}] [@ Cancel]] \
            [NSAlertDefaultReturn] {$self save: $self} \
            [NSAlertOtherReturn] {return [NO]}
    }
    $owner unregisterDocument: $self
    return [YES]
}

- void updateDisplay {
    global namesTV sendTypesTV returnTypesTV timeoutT defaultKeyEquivT \
           hideB unhideB menuItemF keyEquivF codeT s language \
           code sendTypes returnTypes timeout hide unhide menuItem keyEquiv
    set s [$namesTV selection]
    $codeT setString: [@ $code($s)]
    $sendTypesTV setSelection: $sendTypes($s)
    $returnTypesTV setSelection: $returnTypes($s)
    $timeoutT setStringValue: [@ $timeout($s)]
    if {[info exists keyEquiv([list $s default])]} {
        $defaultKeyEquivT setStringValue: \
                            [@ $keyEquiv([list $s default])]
    } else {
        $defaultKeyEquivT setStringValue: [@ ""]
    }
    $hideB setState: $hide($s)
    $unhideB setState: $unhide($s)
    if {[info exists menuItem([list $s $language])]} {
        $menuItemF setStringValue: [@ $menuItem([list $s $language])]
    } else {
        $menuItemF setStringValue: [@ ""]
    }
    if {[info exists keyEquiv([list $s $language])]} {
        $keyEquivF setStringValue: [@ $keyEquiv([list $s $language])]
    } else {
        $keyEquivF setStringValue: [@ ""]
    }
}

- void tableViewSelectionDidChange: note {
    global window namesTV sendTypesTV returnTypesTV s sendTypes returnTypes
    switch [set sender [$note object]] \
        $namesTV {
            set flag [$window isDocumentEdited]
            $self updateDisplay
            $window setDocumentEdited: $flag
            return
        } \
        $sendTypesTV {set sendTypes($s) [$sender selection]} \
        $returnTypesTV {set returnTypes($s) [$sender selection]}
    $window setDocumentEdited: [YES]
}

- void tableViewListDidChange: note {
    global window namesTV s \
           code sendTypes returnTypes timeout hide unhide menuItem keyEquiv
    set new [$namesTV selection]
    foreach var {code sendTypes returnTypes timeout hide unhide} {
        set ${var}($new) [set ${var}($s)]
        unset ${var}($s)
    }
    foreach var {menuItem keyEquiv} {
        foreach n [array names $var [list $s *]] {
            lassign $n _ language
            set ${var}([list $new $language]) [set ${var}($n)]
            unset ${var}($n)
        }
    }
    set s $new
    $window setDocumentEdited: [YES]
}

- void controlTextDidEndEditing: note {
    global window timeoutT defaultKeyEquivT menuItemF keyEquivF s language \
           timeout keyEquiv menuItem
    switch [set sender [[$note object] selectedCell]] \
        $timeoutT {set timeout($s) [* [$sender stringValue]]} \
        $defaultKeyEquivT {
            set keyEquiv([list $s default]) [* [$sender stringValue]]
        } \
        $menuItemF {
            set menuItem([list $s $language]) [* [$sender stringValue]]
        } \
        $keyEquivF {
            set keyEquiv([list $s $language]) [* [$sender stringValue]]
        }
}

- void controlTextDidChange: note {
    global window
    $window setDocumentEdited: [YES]
}

- void textDidChange: note {
    global window
    $window setDocumentEdited: [YES]
}

- void editDocument: sender {
    global window hideB unhideB languagesP menuItemF keyEquivF s language \
           hide unhide menuItem keyEquiv
   if {$sender == $languagesP} {
        set language [* [[$sender selectedItem] title]]
        if {[info exists menuItem([list $s $language])]} {
            $menuItemF setStringValue: [@ $menuItem([list $s $language])]
        } else {
            $menuItemF setStringValue: [@ ""]
        }
        if {[info exists keyEquiv([list $s $language])]} {
            $keyEquivF setStringValue: [@ $keyEquiv([list $s $language])]
        } else {
            $keyEquivF setStringValue: [@ ""]
        }
        return
    }
    switch [$sender selectedCell] \
        $hideB {set hide($s) [$hideB state]} \
        $unhideB {set unhide($s) [$unhideB state]}
    $window setDocumentEdited: [YES]
}

}

objc:teach $addB {

- void action: sender {
    global owner window namesTV deleteB s \
           code sendTypes returnTypes timeout hide unhide
    set list [$namesTV list]
    set s [$owner nextUntitled: [lmatch $list UNTITLED*]]
    set code($s) ""
    set sendTypes($s) ""
    set returnTypes($s) ""
    set timeout($s) ""
    set hide($s) 1
    set unhide($s) 0
    lappend list $s
    $namesTV setList: $list
    $namesTV setSelection: $s
    if {[llength $list] > 1} {
        $deleteB setEnabled: [YES]
        $window setDocumentEdited: [YES]
    }
}

}

objc:teach $deleteB {

- void action: sender {
    global window namesTV s code sendTypes returnTypes timeout hide unhide
    set list [$namesTV list]
    foreach var {code sendTypes returnTypes timeout hide unhide} {
        unset ${var}($s)
    }
    foreach var {menuItem keyEquiv} {
        foreach n [array names $var [list $s *]] {
            unset ${var}($n)
        }
    }
    set row [$namesTV selectedRow]
    set list [lreplace $list $row $row]
    $namesTV setList: $list
    $::self updateDisplay
    if {[llength $list] == 1} {
        $self setEnabled: [NO]
    }
    $window setDocumentEdited: [YES]
}

}

objc:teach $codeT {

- BOOL resignFirstResponder {
    global window s code
    if {[set result [former resignFirstResponder]]} {
        set code($s) [* [$self string]]
    }
    return $result
}

}

foreach tv "$namesTV $sendTypesTV $returnTypesTV" {
    $defaultCenter addObserver: $self \
                      selector: tableViewSelectionDidChange: \
                          name: [NSTableViewSelectionDidChangeNotification] \
                        object: $tv
}
$defaultCenter addObserver: $self \
                  selector: tableViewListDidChange: \
                      name: [@ NSTableViewListDidChangeNotification] \
                    object: $namesTV
foreach txt "$defaultKeyEquivT $timeoutT $form2 $initT $codeT" {
    $txt setDelegate: $self
}

$owner registerDocument: $self

