/*
    File:       GaugeView.h

    Contains:   Header file for the GaugeView class.

    Written By:	Bruce Blumberg

    Created:    June 19, 1997

    Copyright:  (c) 1997 by Apple Computer, Inc., all rights reserved.

    Change History: Originally written for 0.6 mid 1988 by Bruce Blumberg.
                     Modified for 1.0 by Ali Ozer.
                     Redesigned for 2.0 by Julie Zelenski.
                     Redesigned for Rhapsody by Stephen Chick.

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

//  Class interface.

@interface GaugeView : NSView
{
	BOOL needRedraw; 	//  Flag to indicate if a redraw is needed.

	float value;		//  Current gauge value.
	float min;		//  Minimum gauge value.	
	float max;		//  Maximum gauge value.
	
	float startAngle;	//  Angle of minimum gauge value.
	float angleRange;	//  Range in degrees which gauge spans.
	float degreesPerUnit;	//  Ratio of degrees to value units. 

	int tickInterval;	//  Interval of tick marks.

	NSFont *font;		//  Font used to draw labels.

	float radius;		//  Radius of gauge face.
	NSPoint center;		//  Center coordinate of gauge face.
	NSImage *face;		//  Offscreen image for gauge face.

	NSString *title;	//  Gauge title string.

	id valueSlider;		//  Slider control (connected in IB).
	id valueFormCell;	//  Form cell control (connected in IB).
}

//  Initialization and deallocation methods.

- (id) initWithFrame:(NSRect) frameRect;
- (id) initWithFrame:(NSRect) frameRect min:(float) initMin max:(float) initMax
	startAngle:(float) initStartAngle angleRange:(float) initAngleRange
	tickInterval:(int) initTickInterval;
- (void) dealloc;

//  Parameter get/set methods.

- (void) setTitle:(NSString *) newTitle;
- (void) setFont:(NSFont *) newFont;
- (void) setMin:(float) newMin;
- (void) setMax:(float) newMax;
- (void) setStartAngle:(float) newStartAngle;
- (void) setAngleRange:(float) newAngleRange;
- (void) setTickInterval:(int) newTickInterval;

//  Target action methods.

- (void) changeValue:(id) sender;

//  Private methods.

- (void) drawHand;
- (void) drawFace;
- (void) drawRect:(NSRect) rect; 

@end
