//************************************************************************
//
//	CTXHandler.m
//
//	by Juergen Moellenhoff <jm@oic.de>		
//
//
//	This code is supplied "as is" the author makes no warranty as to its 
//	suitability for any purpose.  This code is free and may be distributed 
//	in accordance with the terms of the:
//		
//			GNU GENERAL PUBLIC LICENSE
//			Version 2, June 1991
//			copyright (C) 1989, 1991 Free Software Foundation, Inc.
// 			675 Mass Ave, Cambridge, MA 02139, USA
//
//************************************************************************

#import "CTXHandler.h"

#import "HTTPSPreferences.h"
#import "HTTPSFunctions.h"

#import	<OmniFoundation/OFUserDefaults.h>
#import	<OmniBase/rcsid.h>

#import	<Foundation/NSLock.h>

RCS_ID("$Header: /LocalDeveloper/CVS/HTTPS/CTXHandler.m,v 1.11 1999/06/22 15:34:48 jurgen Exp $")

@implementation CTXHandler

static	CTXHandler	*sharedCTXHandler = nil;
static	NSLock		*ctxHandlerLock = nil;

+ (void)initialize 
{
	static BOOL fInitialized = NO;

	[super initialize];
	if (fInitialized)
		return;
    fInitialized = YES;

	ctxHandlerLock = [[NSLock alloc] init];
}

+ (BOOL)isSharedCTXHandler
{
	return (sharedCTXHandler != nil);
}

+ (CTXHandler *)sharedCTXHandler
{
	static BOOL	fInit = NO;
	
	if (sharedCTXHandler != nil)
		return sharedCTXHandler;

	[ctxHandlerLock lock];

	if (!fInit)
	{
		SSL_load_error_strings();
		SSL_library_init();
		fInit = YES;
	}

	if (sharedCTXHandler == nil)
		sharedCTXHandler = [[CTXHandler alloc] init];

	[ctxHandlerLock unlock];

	return sharedCTXHandler;
}

+ (NSString *)_cipherList
{
	if ([[OFUserDefaults sharedUserDefaults] boolForKey:HTTPSUseDefaultCipherList])
		return nil;

	return [[OFUserDefaults sharedUserDefaults] stringForKey:HTTPSCipherList];
}

- init
{
	NSString	*cipherList;

	self = [super init];

	_ctx = SSL_CTX_new(SSLv23_client_method());
	if (_ctx == NULL)
	{
		[self release];
		return nil;
	}

	[self setUserDefaults];

	if ((cipherList = [[self class] _cipherList]) != nil)
	{
		if (!SSL_CTX_set_cipher_list(_ctx, (char *)[cipherList cString]))
		{
			[self release];
			return nil;
		}
	}

	if (!SSL_CTX_set_default_verify_paths(_ctx))
	{
		[self release];
		return nil;
	}

	SSL_CTX_set_verify(_ctx, SSL_VERIFY_NONE, NULL);

	SSL_CTX_set_session_cache_mode(_ctx, SSL_SESS_CACHE_CLIENT);

	return self;
}

- (void)setUserDefaults
{
	if (_ctx == NULL)
		return;
		
	if ([[OFUserDefaults sharedUserDefaults] boolForKey:HTTPSUseBugfixes])
		SSL_CTX_set_options(_ctx, SSL_OP_ALL);
	else
		_ctx->options = (_ctx->options & ~SSL_OP_ALL);

	if (![[OFUserDefaults sharedUserDefaults] boolForKey:HTTPSTLSv1Enabled])
		SSL_CTX_set_options(_ctx, SSL_OP_NO_TLSv1);
	else
		_ctx->options = (_ctx->options & ~SSL_OP_NO_TLSv1);

	if (![[OFUserDefaults sharedUserDefaults] boolForKey:HTTPSSSLv2Enabled])
		SSL_CTX_set_options(_ctx, SSL_OP_NO_SSLv2);
	else
		_ctx->options = (_ctx->options & ~SSL_OP_NO_SSLv2);

	if (![[OFUserDefaults sharedUserDefaults] boolForKey:HTTPSSSLv3Enabled])
		SSL_CTX_set_options(_ctx, SSL_OP_NO_SSLv3);
	else
		_ctx->options = (_ctx->options & ~SSL_OP_NO_SSLv3);
}

- (void)dealloc
{
	if (sharedCTXHandler == self)
		sharedCTXHandler = nil;

	if (_ctx != NULL)
	{
		SSL_CTX_free(_ctx);
		_ctx = NULL;
	}
	
	[super dealloc];
}

- (SSL_CTX *)ctx
{
	return _ctx;
}

@end
