//************************************************************************
//
//	HTTPSInformation.m
//
//	by Juergen Moellenhoff <jm@oic.de>		
//
//
//	This code is supplied "as is" the author makes no warranty as to its 
//	suitability for any purpose.  This code is free and may be distributed 
//	in accordance with the terms of the:
//		
//			GNU GENERAL PUBLIC LICENSE
//			Version 2, June 1991
//			copyright (C) 1989, 1991 Free Software Foundation, Inc.
// 			675 Mass Ave, Cambridge, MA 02139, USA
//
//************************************************************************

#import "HTTPSInformation.h"

#import "SSLSocket.h"
#import "HTTPSSession.h"
#import "HTTPSPreferences.h"
#import "HTTPSFunctions.h"
#import "HTTPSUtilities.h"
#import "HTTPSProcessor.h"

#import <OpenSSL/pem.h>

#import	<OmniBase/rcsid.h>

#import	<OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

#import <OmniNetworking/ONHost.h>
#import <OmniNetworking/ONSocketStream.h>

#import	<AppKit/AppKit.h>


RCS_ID("$Header: /LocalDeveloper/CVS/HTTPS/HTTPSInformation.m,v 1.10 1999/06/22 15:14:05 jurgen Exp $")

@implementation HTTPSInformation

static	HTTPSInformation	*sharedHTTPSInformation = nil;

+ (HTTPSInformation *)sharedHTTPSInformation
{
	if (sharedHTTPSInformation == nil)
		sharedHTTPSInformation = [[HTTPSInformation alloc] init];
	
	return sharedHTTPSInformation;
}

- (IBAction)ok:sender
{
	[NSApp stopModalWithCode:NSOKButton];
}

- (IBAction)cancel:sender
{
	[NSApp stopModalWithCode:NSCancelButton];
}

- (IBAction)disablePanel:sender
{
	_disablePanel = ([(NSButton *)sender state] != 0);
}

- (NSString *)_getCertificate:(HTTPSSession *)session
{
	BIO 		*memBio;
	SSL			*sslHandle;
	X509		*cert;
	char		*buffer;
	long		length;
	NSString	*tempString;

	memBio = BIO_new(BIO_s_mem());
	sslHandle  = [(SSLSocket *)[[session socketStream] socket] sslHandle];

	if ((cert = SSL_get_peer_certificate(sslHandle)) != NULL)
	{
		BIO_printf(memBio, "---\n");
		SSL_SESSION_print(memBio, SSL_get_session(sslHandle));
		BIO_printf(memBio, "---\n");
		X509_print(memBio, cert);

		X509_free(cert);
	}

	if ((length = BIO_ctrl(memBio, BIO_CTRL_INFO, 0, (char *)&buffer)) > 0)
		tempString = [NSString stringWithCString:buffer length:length];
	else
		tempString = [NSString string];
	BIO_free(memBio);

	return tempString;
}

- (NSString *)_infoString:(HTTPSSession *)session processor:(HTTPSProcessor *)aProcessor
{
	SSLSocket	*sslSocket = (SSLSocket *)[[session socketStream] socket];
	NSString	*tempString;

	tempString = [NSString stringWithFormat:_infoFormatString, 
				[(OWAddress *)[[aProcessor pipeline] lastAddress] bestKnownTitle], [sslSocket bits], [self _getCertificate:session]];

	return tempString;
}

- (BOOL)runModalWithSession:(HTTPSSession *)session andProcessor:(HTTPSProcessor *)aProcessor
{
    [[scrollView documentView] setString:[self _infoString:session processor:aProcessor]];
    [[scrollView documentView] scrollRangeToVisible:NSMakeRange(0, 0)];

    [panel makeKeyAndOrderFront:self];

    _canceled = ([NSApp runModalForWindow:panel] == NSCancelButton);

    [panel orderOut:self];

    return _canceled;
}

- (BOOL)canceled
{
	return _canceled;
}

- (BOOL)disablePanel
{
	return _disablePanel;
}

- init
{
	[super init];

	if (![NSBundle loadNibNamed:@"HTTPSInformation" owner:self])
	{
		NSRunAlertPanel(nil, NSLocalizedStringFromTableInBundle(@"HTTPSNibFileLoadError", nil, CLASS_BUNDLE, nil), 
			NSLocalizedStringFromTableInBundle(@"OKButton", nil, CLASS_BUNDLE, nil), nil, nil, @"HTTPSInformation.nib");
		[self release];
		return nil;
	}

	_disablePanel = _canceled = NO;
    [panel setFrameAutosaveName:[[self class] description]];

	_infoFormatString = [[[scrollView documentView] string] copy];
	[[scrollView documentView] setString:@""];

	return self;
}

- (void)dealloc
{
	if (sharedHTTPSInformation == self)
		sharedHTTPSInformation = nil;

	[_infoFormatString release];
	
	[super dealloc];
}

@end
