//************************************************************************
//
//	HTTPSPreferences.h
//
//	by Juergen Moellenhoff <jm@oic.de>		
//
//
//	This code is supplied "as is" the author makes no warranty as to its 
//	suitability for any purpose.  This code is free and may be distributed 
//	in accordance with the terms of the:
//		
//			GNU GENERAL PUBLIC LICENSE
//			Version 2, June 1991
//			copyright (C) 1989, 1991 Free Software Foundation, Inc.
// 			675 Mass Ave, Cambridge, MA 02139, USA
//
//************************************************************************

#import <OmniAppKit/OAPreferenceClient.h>

#import <AppKit/NSNibDeclarations.h>
#import <AppKit/NSTextField.h>

@class	NSMatrix;
@class	NSButton;
@class	NSForm;

@interface HTTPSPreferences : OAPreferenceClient
{
@public
	IBOutlet	NSTextField	*versionTextField;

	IBOutlet	NSMatrix	*optionsMatrix;

	IBOutlet	NSButton	*cipherSwitch;
	IBOutlet	NSForm		*cipherFormMatrix;

	IBOutlet	NSMatrix	*securityMatrix1;
	IBOutlet	NSMatrix	*securityMatrix2;
}

+ (NSString *)httpsOFSoftwareVersion;

- (IBAction)openOICInfo:sender;
- (IBAction)openReadme:sender;
- (IBAction)openSSLInfo:sender;

@end

extern NSString	*HTTPSUseBugfixes;

extern NSString	*HTTPSDebugLog;

extern NSString	*HTTPSUseDefaultCipherList;
extern NSString	*HTTPSCipherList;

extern NSString	*HTTPSTLSv1Enabled;
extern NSString	*HTTPSSSLv2Enabled;
extern NSString	*HTTPSSSLv3Enabled;

extern NSString	*HTTPSCacheEnabled;
extern NSString	*HTTPSWarningPanelEnabled;
