//************************************************************************
//
//	HTTPSPreferences.m
//
//	by Juergen Moellenhoff <jm@oic.de>		
//
//
//	This code is supplied "as is" the author makes no warranty as to its 
//	suitability for any purpose.  This code is free and may be distributed 
//	in accordance with the terms of the:
//		
//			GNU GENERAL PUBLIC LICENSE
//			Version 2, June 1991
//			copyright (C) 1989, 1991 Free Software Foundation, Inc.
// 			675 Mass Ave, Cambridge, MA 02139, USA
//
//************************************************************************

#import "HTTPSPreferences.h"

#import "HTTPSFunctions.h"
#import "CTXHandler.h"
#import "HTTPSUtilities.h"

#import	<OmniFoundation/OFUserDefaults.h>
#import	<OmniBase/rcsid.h>
#import	<OmniBase/OBUtilities.h>

#import	<OWF/OWAddress.h>
#import	<OWF/OWURL.h>

#import	<AppKit/AppKit.h>
#import	<Foundation/Foundation.h>

RCS_ID("$Header: /LocalDeveloper/CVS/HTTPS/HTTPSPreferences.m,v 1.21 1999/06/22 15:34:49 jurgen Exp $")

@interface OFObject(HTTPSOmniWebPrivate)
+ sharedController;
- (void)openAddress:(OWAddress *)anAddress;
@end

@implementation HTTPSPreferences

+ (NSString *)httpsOFSoftwareVersion
{
	static NSString	*bundleVersion = nil;

	if (bundleVersion == nil)
	{
		bundleVersion = [[CLASS_BUNDLE infoDictionary] objectForKey:@"OFSoftwareVersion"];
		if (bundleVersion == nil || [bundleVersion isEqualToString:@""])	
			bundleVersion = @"Unknown";
		else
			[bundleVersion retain];
	}

	return bundleVersion;
}

+ (void)initialize 
{
	static BOOL fInitialized = NO;

	[super initialize];
	if (fInitialized)
		return;
    fInitialized = YES;

	[OWURL registerSecureScheme:@"https"];

	NSLog(NSLocalizedStringFromTableInBundle(@"LogHTTPSVersion", nil, CLASS_BUNDLE, @"The HTTPS Version."), [[self class] httpsOFSoftwareVersion], __DATE__);

	NSLog(NSLocalizedStringFromTableInBundle(@"LogOpenSSLVersion", nil, CLASS_BUNDLE, @"The OpenSSL Version."), 
		SSLeay_version(SSLEAY_VERSION), SSLeay_version(SSLEAY_BUILT_ON), SSLeay_version(SSLEAY_CFLAGS));
	NSLog(NSLocalizedStringFromTableInBundle(@"LogOpenSSLOptions", nil, CLASS_BUNDLE, @"The OpenSSL Options."), 
		BN_options(), MD2_options(), RC4_options(), des_options(), idea_options(), BF_options());
}

- (void)awakeFromNib
{
	if ([[self superclass] instancesRespondToSelector:@selector(awakeFromNib)])
		[super awakeFromNib];

	[versionTextField setStringValue:[NSString stringWithFormat:
		NSLocalizedStringFromTableInBundle(@"HTTPSVersion", nil, CLASS_BUNDLE, @"HTTPS Version in Preferences Panel."), 
		[[self class] httpsOFSoftwareVersion], __DATE__]];
}

- (void)_updateSharedCTXHandler
{
	if ([CTXHandler isSharedCTXHandler])
		[[CTXHandler sharedCTXHandler] setUserDefaults];
}

- (void)_updateCipherList
{
	if ([defaults boolForKey:HTTPSUseDefaultCipherList])
		[[cipherFormMatrix cellWithTag:0] setStringValue:[NSString stringWithCString:SSL_DEFAULT_CIPHER_LIST]];
	else
		[[cipherFormMatrix cellWithTag:0] setStringValue:[defaults stringForKey:HTTPSCipherList]];
	[[cipherFormMatrix cellWithTag:0] setEnabled:![defaults boolForKey:HTTPSUseDefaultCipherList]];
}

- (void)updateUI
{
	[super updateUI];

	[[optionsMatrix cellWithTag:0] setState:[defaults boolForKey:HTTPSUseBugfixes]];
	[[optionsMatrix cellWithTag:1] setState:[defaults boolForKey:HTTPSDebugLog]];
	[optionsMatrix setNeedsDisplay:YES];

	[[securityMatrix1 cellWithTag:0] setState:[defaults boolForKey:HTTPSTLSv1Enabled]];
	[[securityMatrix1 cellWithTag:1] setState:[defaults boolForKey:HTTPSSSLv2Enabled]];
	[[securityMatrix1 cellWithTag:2] setState:[defaults boolForKey:HTTPSSSLv3Enabled]];
	[securityMatrix1 setNeedsDisplay:YES];

	[[securityMatrix2 cellWithTag:0] setState:[defaults boolForKey:HTTPSWarningPanelEnabled]];
	[[securityMatrix2 cellWithTag:1] setState:[defaults boolForKey:HTTPSCacheEnabled]];
	[securityMatrix2 setNeedsDisplay:YES];

	[cipherSwitch setState:[defaults boolForKey:HTTPSUseDefaultCipherList]];
	[self _updateCipherList];
}

- (void)valuesHaveChanged
{
	[super valuesHaveChanged];

	[self _updateSharedCTXHandler];
}

- (void)setValueForSender:sender
{
	NSButtonCell	*theButtonCell;
	NSString		*key = nil;

	[super setValueForSender:sender];

	if (sender == securityMatrix1)
	{
		theButtonCell = [sender selectedCell];

		switch ([theButtonCell tag])
		{
		case 0:
			key = HTTPSTLSv1Enabled;
			break;
		case 1:
			key = HTTPSSSLv2Enabled;
			break;
		case 2:
			key = HTTPSSSLv3Enabled;
			break;

		default:
			key = nil;
			break;
		}

		if (key != nil)
		{
			[defaults setBool:([theButtonCell state] != 0) forKey:key];
			[self _updateSharedCTXHandler];
		}
		return;
	}

	if (sender == securityMatrix2)
	{
		theButtonCell = [sender selectedCell];

		switch ([theButtonCell tag])
		{
		case 0:
			key = HTTPSWarningPanelEnabled;
			break;
		case 1:
			key = HTTPSCacheEnabled;
			break;

		default:
			key = nil;
			break;
		}

		if (key != nil)
			[defaults setBool:([theButtonCell state] != 0) forKey:key];

		return;
	}

	if (sender == optionsMatrix)
	{
		theButtonCell = [sender selectedCell];

		switch ([theButtonCell tag])
		{
		case 0:
			[defaults setBool:([theButtonCell state] != 0) forKey:HTTPSUseBugfixes];
			[self _updateSharedCTXHandler];
			break;
		case 1:
			[defaults setBool:([theButtonCell state] != 0) forKey:HTTPSDebugLog];
			break;
		}

		return;
	}

	if (sender == cipherSwitch)
	{
		[defaults setBool:([cipherSwitch state] != 0) forKey:HTTPSUseDefaultCipherList];
		[self _updateCipherList];
		if ([cipherSwitch state] == 0)
			[cipherFormMatrix selectTextAtIndex:0];
		return;
	}
	
	if (sender == cipherFormMatrix)
	{
		[defaults setObject:[[cipherFormMatrix cellWithTag:0] stringValue] forKey:HTTPSCipherList];
		return;
	}
}

- (IBAction)openOICInfo:sender
{
	Class	owControllerClass;

	if (((owControllerClass = NSClassFromString(@"OWController")) != nil) &&
		[owControllerClass respondsToSelector:@selector(sharedController)] &&
		[owControllerClass instancesRespondToSelector:@selector(openAddress:)])
	{
		[[owControllerClass sharedController] openAddress:[OWAddress addressForDirtyString:@"http://www.oic.de/"]]; 
	}
}

- (IBAction)openSSLInfo:sender
{
	Class	owControllerClass;

	if (((owControllerClass = NSClassFromString(@"OWController")) != nil) &&
		[owControllerClass respondsToSelector:@selector(sharedController)] &&
		[owControllerClass instancesRespondToSelector:@selector(openAddress:)])
	{
		[[owControllerClass sharedController] openAddress:[OWAddress addressForDirtyString:@"http://www.openssl.org/"]]; 
	}
}

- (IBAction)openReadme:sender
{
	NSArray		*resourceArray;
	NSBundle	*thisBundle;
	int			i, iCount;
	
	thisBundle = [NSBundle bundleForClass:[self class]];
	resourceArray = [thisBundle pathsForResourcesOfType:
			NSLocalizedStringFromTableInBundle(@"HTTPSReadmeExtension", nil, CLASS_BUNDLE, @"Extension of the README file") inDirectory:nil];

	for (i = 0, iCount = [resourceArray count]; i < iCount; i++)
	{
		[[NSWorkspace sharedWorkspace] openFile:[resourceArray objectAtIndex:i]];
	}
}

@end

DEFINE_NSSTRING(HTTPSUseBugfixes);

DEFINE_NSSTRING(HTTPSDebugLog);

DEFINE_NSSTRING(HTTPSUseDefaultCipherList);
DEFINE_NSSTRING(HTTPSCipherList);

DEFINE_NSSTRING(HTTPSTLSv1Enabled);
DEFINE_NSSTRING(HTTPSSSLv2Enabled);
DEFINE_NSSTRING(HTTPSSSLv3Enabled);

DEFINE_NSSTRING(HTTPSCacheEnabled);
DEFINE_NSSTRING(HTTPSWarningPanelEnabled);
