#import "MenuClock.h"

#import <AppKit/psopsNeXT.h>

#define	TimeFormat		@"TimeFormat"
#define	defaultTimeFormat	@"%I:%M:%S %p %m/%d/%y"

static	int	activeCount	= 0;

@interface MCWindow:NSWindow
- (void)setAvoidsActivation:(BOOL)value;
- (void)mouseDown:(NSEvent *)theEvent;
@end

@implementation MCWindow
- (void)setAvoidsActivation:(BOOL)value
{
    _wFlags.avoidsActivation = value;
}
- (void)mouseDown:(NSEvent *)theEvent
{
    [[[NSApplication sharedApplication] delegate] setClockMouseDown];
    [super mouseDown:theEvent];
}
@end

@implementation MenuClock

+ (void)initialize{

    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    NSDictionary *appDefaults = [NSDictionary dictionaryWithObject:defaultTimeFormat forKey:TimeFormat];

    [defaults registerDefaults:appDefaults];
}

- init
{
    NSRect		screenRect, windowRect;
    NSFont		*font;
    float		f = 14;

    screenRect = [[NSScreen mainScreen] frame];

    windowRect.origin.x = screenRect.size.width - 250;
    windowRect.origin.y = screenRect.size.height - f;
    windowRect.size.width = 250;
    windowRect.size.height = (f ? f : 14);

    window = [[[MCWindow alloc] initWithContentRect:windowRect styleMask:NSBorderlessWindowMask backing:NSBackingStoreBuffered defer:NO] retain];

    // stolen from MagnifyingGlass example
    // we don't want the window to be filled so it stays transparent
    PSsetautofill(NO, [window windowNumber]);

    [window setLevel:NSModalPanelWindowLevel];
    [window orderWindow:NSWindowAbove relativeTo:0];
    [window orderFrontRegardless];
    //[window setAvoidsActivation:YES];

    font = [NSFont menuFontOfSize:12];

    textField = [[NSTextField alloc] initWithFrame:[window frame]];
    [textField setFont:font];
    [textField setBordered:NO];
    [textField setDrawsBackground:NO];
    [textField setEditable:NO];
    [[textField cell] setAlignment:NSRightTextAlignment];

    //[textField setStringValue:[[NSCalendarDate calendarDate] descriptionWithCalendarFormat:[[NSUserDefaults standardUserDefaults] stringForKey:TimeFormat]]];

    [window setContentView:textField];
    [window display];
    
    timer = [[NSTimer scheduledTimerWithTimeInterval:1.0 target:self selector:@selector(updateTimer:) userInfo:nil repeats:YES] retain];

    makeKey=0;
    
    return self;
}

- (void)updateTimer:(id)sender
{
    [textField setStringValue:[[NSCalendarDate calendarDate] descriptionWithCalendarFormat:[[NSUserDefaults standardUserDefaults] stringForKey:TimeFormat]]];
    if (([aboutWindow isVisible] == NO) && (makeKey > 0))
    {
        makeKey --;
        if ( makeKey == 0 )
            [[NSApplication sharedApplication] hide:self];
    }
}

- (void)dealloc
{
    [timer invalidate];
    [timer release];
    [textField release];
    [window release];
    return;
}

- (void)about:(id)sender
{
    [aboutWindow center];
    [menuFormat setStringValue:[[NSUserDefaults standardUserDefaults] stringForKey:TimeFormat]];
    [menuSample setStringValue:[[NSCalendarDate calendarDate] descriptionWithCalendarFormat:[[NSUserDefaults standardUserDefaults] stringForKey:TimeFormat]]];
    [aboutWindow makeKeyAndOrderFront:self];
}

- (void)setClockMouseDown
{
    makeKey = 5;
}

- (void)restoreDefault:(id)sender
{
    [[NSUserDefaults standardUserDefaults] setObject:defaultTimeFormat forKey:TimeFormat];
    [menuFormat setStringValue:defaultTimeFormat];
    [menuSample setStringValue:[[NSCalendarDate calendarDate] descriptionWithCalendarFormat:defaultTimeFormat]];
}
- (void)changeFormat:(id)sender
{
    NS_DURING
        [menuSample setStringValue:[[NSCalendarDate calendarDate] descriptionWithCalendarFormat:[menuFormat stringValue]]];
        [[NSUserDefaults standardUserDefaults] setObject:[menuFormat stringValue] forKey:TimeFormat];
    NS_HANDLER
        [menuSample setStringValue:@"invalid date format"];
    NS_ENDHANDLER
}

- (void)applicationDidHide:(NSNotification *)aNotification
{
    [window orderFront:self];
}
- (void)applicationWillBecomeActive:(NSNotification *)notification;
{
    if ( makeKey <= 0 )
        [[notification object] hide:self];
}
@end


@implementation ClockApp

- (void)finishLaunching
{
	NSPoint aPt = {-10000,-10000};

	[super finishLaunching]; 
	[_appIcon setFrameOrigin:aPt];
        return;
}

@end