/**
 * Foundation and AppKit extensions
 **
 * Wilfredo Sanchez | wsanchez@apple.com
 * Copyright 1998 Apple Computer, Inc.
 * All rights reserved.
 **/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#import "Extensions.h"

/************
 * NSString *
 ************/

@implementation NSMutableString (Substitution)

- (void) replaceSubstring: (NSString*   ) aSubstring
               withString: (NSString*   ) aString
                 globally: (BOOL        ) aGlobally
{
    [self replaceSubstring: aSubstring
                withString: aString
                  globally: aGlobally
                   options: (unsigned int)0];
}
- (void) replaceSubstring: (NSString*   ) aSubstring
               withString: (NSString*   ) aString
                 globally: (BOOL        ) aGlobally
                  options: (unsigned int) anOptions
{
    NSRange aRange = [self rangeOfString:aSubstring options:anOptions];

    if (aGlobally)
      {
        NSRange aSearchRange;

        if (anOptions & NSBackwardsSearch)
          {
            aSearchRange.location = 0;

            while (aRange.length)
              {
                [self replaceCharactersInRange:aRange withString:aString];

                aSearchRange.length = aRange.location;

                aRange = [self rangeOfString:aSubstring options:anOptions range:aSearchRange];
              }
          }
        else
          {
            while (aRange.length)
              {
                [self replaceCharactersInRange:aRange withString:aString];

                aSearchRange.location = aRange.location+1;
                aSearchRange.length   = [self length] - (aRange.location+1);

                aRange = [self rangeOfString:aSubstring options:anOptions range:aSearchRange];
              }
          }
      }
    else
      {
        if (aRange.length) [self replaceCharactersInRange:aRange withString:aString];
      }
}

- (void) deleteSubstring: (NSString*   ) aSubstring
                globally: (BOOL        ) aGlobally
{
    [self deleteSubstring: aSubstring
                 globally: aGlobally
                  options: (unsigned int)0];
}
- (void) deleteSubstring: (NSString*   ) aSubstring
                globally: (BOOL        ) aGlobally
                 options: (unsigned int) anOptions
{
    NSRange aRange = [self rangeOfString:aSubstring options:anOptions];

    if (aGlobally)
      {
        while (aRange.length)
          {
            [self deleteCharactersInRange: aRange];

            aRange = [self rangeOfString:aSubstring options:anOptions];
          }
      }
    else
      {
        if (aRange.length) [self deleteCharactersInRange: aRange];
      }
}

@end

/***********
 * NSArray *
 ***********/

@implementation NSArray (Filter)

- (NSArray*) subarrayUsingSelector: (SEL) aFilter
{
    NSMutableArray* anArray      = [NSMutableArray array];
    NSEnumerator*   anEnumerator = [self objectEnumerator];
    NSObject*       anObject;

    while ((anObject = [anEnumerator nextObject]))
        if ([anObject performSelector:aFilter])
            [anArray addObject: anObject];

    return anArray;
}

@end

/***********
 * NSPanel *
 ***********/

@implementation NSPanel (Alert)

+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage
{
    [self runAlertPanelWithName: aName
                        message: aMessage
            defaultButtonString: nil
          alternateButtonString: nil
              otherButtonString: nil];
}
+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage
           defaultButtonString: (NSString*) aDefaultButtonString
{
    [self runAlertPanelWithName: aName
                        message: aMessage
            defaultButtonString: aDefaultButtonString
          alternateButtonString: nil
              otherButtonString: nil];
}
+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage
           defaultButtonString: (NSString*) aDefaultButtonString
         alternateButtonString: (NSString*) anAlternateButtonString
{
    [self runAlertPanelWithName: aName
                        message: aMessage
            defaultButtonString: aDefaultButtonString
          alternateButtonString: anAlternateButtonString
              otherButtonString: nil];
}
+ (void) runAlertPanelWithName: (NSString*) aName
                       message: (NSString*) aMessage
           defaultButtonString: (NSString*) aDefaultButtonString
         alternateButtonString: (NSString*) anAlternateButtonString
             otherButtonString: (NSString*) anOtherButtonString
{
    NSRunAlertPanel(aName,
                    aMessage,
                    aDefaultButtonString,
                    anAlternateButtonString,
                    anOtherButtonString,
                    nil);
}

@end
