/**
 * NSZephyr
 **
 * Wilfredo Sanchez | wsanchez@apple.com, tritan@mit.edu
 *
 * Copyright 1998 Apple Computer, Inc.
 *
 * Copyright (c) 1989 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file
 * "mit-copyright.h".
 **/

#ifndef __NS_ZEPHYR_H__
#define __NS_ZEPHYR_H__

#include <zephyr/zephyr.h>

#define NS_USER_CLASS               @"Message"
#define NS_USER_INSTANCE            @"Personal"

#define NS_GROUP_RECIPIENT          @"*"

#define NS_URGENT_CLASS             NS_USER_CLASS
#define NS_URGENT_INSTANCE          @"Urgent"

#define NS_CLIENT_CONTROL_CLASS     @"WG_CTL_CLASS"       /* Why the hell doesn't zwgc's main.c use WG_CTL_CLASS */
#define NS_CLIENT_CONTROL_INSTANCE  @"WG_CTL_USER<<<>>>"  /* and WG_CTL_USER in zephyr.h? notice.c does...       */

#define NS_PING_OPCODE              @SERVER_PING

#define NS_LOGIN_CLASS              @LOGIN_CLASS

#define NS_DEFAULT_CLASS            NS_USER_CLASS
#define NS_DEFAULT_INSTANCE         NS_USER_INSTANCE
#define NS_DEFAULT_RECIPIENT        @""
#define NS_DEFAULT_OPCODE           @""
#define NS_DEFAULT_SIGNATURE        nil

#endif /* __NS_ZEPHYR_H__ */
