/**
 * Application
 **
 * Wilfredo Sanchez | wsanchez@apple.com, tritan@mit.edu
 *
 * Copyright 1998 Apple Computer, Inc.
 *
 * Copyright (c) 1989 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file
 * "mit-copyright.h".
 *
 * All rights reserved.
 **/

#include <zephyr/mit-copyright.h>

#include "NSZephyr.h"

#include <parser.h>
#include <mux.h>
#include <port.h>
#include <variables.h>
#include <com_err.h>

#import <Foundation/Foundation.h>

#import "ZephyrMessage.h"
#import "ZephyrClient.h"

/**
 * Pull in main.c from ../zwgc.
 * This basically runs the same stuff zwgc's main does, except that this class implements
 * a method which is detached as a thread by the parent application in place of main.
 **/
#include "../zwgc/main.c"

// Shut up warning about unused functions from main.c
void dummy() { detach(); }

@implementation ZephyrClient

/*******************
 * Class Variables *
 *******************/

static id theDelegate;

/*****************
 * Class Methods *
 *****************/

////
// Accessors
////

+ (id <ZephyrViewer>) delegate { return theDelegate; }

#define getDefault(aVariable,aDefault)					\
    char* aString = ZGetVariable(aVariable);				\
    return aString ? [NSString stringWithCString: aString] : aDefault

+ (NSString*) defaultZephyrClass    { getDefault( "zwrite-class"     , NS_DEFAULT_CLASS     ); }
+ (NSString*) defaultZephyrInstance { getDefault( "zwrite-inst"      , NS_DEFAULT_INSTANCE  ); }
+ (NSString*) defaultOpcode         { getDefault( "zwrite-opcode"    , NS_DEFAULT_OPCODE    ); }
+ (NSString*) defaultSignature      { getDefault( "zwrite-signature" , NS_DEFAULT_SIGNATURE ); }

+ (NSString*) errorMessageForCode: (int) anErrorCode
{
    const char* anErrorString = error_message(anErrorCode);

    if (anErrorString)
        return [NSString stringWithCString: anErrorString];
    else
        return @"Unknown error";

#if 0
    switch (anErrorCode)
      {
        case ZERR_PKTLEN:
            return @"Packet too long or buffer too small";
        case ZERR_HEADERLEN:
            return @"Notice header too large";
        case ZERR_ILLVAL:
            return @"Illegal value in notice";
        case ZERR_HMPORT:
            return @"Can't get host manager port";
        case ZERR_PORTINUSE:
            return @"Can't assign port";
        case ZERR_BADPKT:
            return @"Bad packet format";
        case ZERR_VERS:
            return @"Incompatible version numbers";
        case ZERR_NOPORT:
            return @"No port opened";
        case ZERR_NONOTICE:
            return @"No notices match criteria";
        case ZERR_QLEN:
            return @"Input queue too long";
        case ZERR_HMDEAD:
            return @"Hostmanager not responding";
        case ZERR_INTERNAL:
            return @"Internal error";
        case ZERR_NOLOCATIONS:
            return @"No previous call to ZLocateUser";
        case ZERR_NOMORELOCS:
            return @"No more locations available";
        case ZERR_FIELDLEN:
            return @"Field too long for buffer";
        case ZERR_BADFIELD:
            return @"Improperly formatted field";
        case ZERR_SERVNAK:
            return @"Authorization failure";
        case ZERR_AUTHFAIL:
            return @"Server could not verify authentication";
        case ZERR_LOGINFAIL:
            return @"Not logged in";
        case ZERR_NOSUBSCRIPTIONS:
            return @"No previous call to ZRetrieveSubscriptions";
        case ZERR_NOMORESUBSCRIPTIONS:
            return @"No more subscriptions available";
        case ZERR_TOOMANYSUBS:
            return @"Too many subscriptions to transmit";
        case ZERR_EOF:
            return @"End of file detected during read";
        default:
            return @"Unkown error";
      }
#endif
}

////
// Actions
////

+ (void) runMessageLoop: (id <ZephyrViewer>) aDelegate
{
    int  anArgc    = 2;
    char *anArgv[] = {"zwgc", "-ns"};

    extern void notice_handler();

    NSAutoreleasePool* aPool;

    aPool = [[NSAutoreleasePool alloc] init];

    theDelegate = aDelegate;

    NSLog(@"Starting message thread.");

    // Initialize subsystems
    //NSLog(@"Initializing subsystems");
    mux_init();
    var_clear_all_variables();
    init_ports();

    // Initialize standard ports
    //NSLog(@"Initializing standard ports");
    init_standard_ports(&anArgc, anArgv);

    // Initialize zephyr
    //NSLog(@"Initializing zephyr");
    setup_signals(0);
    zephyr_init(notice_handler);

    // Run initprogs program
    //NSLog(@"Running initprogs program");
    run_initprogs();

    // Test Zwgc parser
    //NSLog(@"Testing Zwgc parser");
    read_in_description_file();

    // Enter message loop
    NSLog(@"Entering message loop.");
    mux_loop();

    // Return from main loop
    //NSLog(@"Returning from main loop");
    finalize_zephyr();

    NSLog(@"Message thread finished.");

    [aPool release];
}

+ (void) dispatchMessage: (ZephyrMessage*) aMessage
{
    [theDelegate dispatchMessage: aMessage];
}

@end
