
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTView.h"
#import "GLUTView_Private.h"
#import "GLUTWindow.h"
#import "GLUTOverlay.h"
#import "GLUTVisual.h"
#import "GLUTApplication.h"











/* *** GLUTView(GLUTPrivate) class implementation *** */

@implementation GLUTView(GLUTPrivate)


static NSCursor *			__glutUnvisibleCursor = nil;



- (BOOL)isFlipped
{
	return YES;
}

- (BOOL)isOpaque
{
	return YES;
}

		/* *** drawing *** */


- (void)drawRect:(NSRect)aRect
{
	if(_flags.isDrawingLocked == YES)
		return;
	
	_flags.pendingRedisplay = NO;
	[[self window] setDocumentEdited: YES];
	
		// we have to call the reshape callback before we call the display callback the first time
	if(_flags.forceReshapeCall == YES)
	{
		_flags.forceReshapeCall = NO;
		[self reshapeWithNewSize: [self bounds].size];
	}
	
	if(_windowStatus == GLUT_FULLY_RETAINED || _windowStatus == GLUT_PARTIALLY_RETAINED)
	{
			// call display callback of normal layer
		if(_flags.drawToOverlay == NO && _displayCallback)
		{
			[self makeCurrent];			
			(*_displayCallback)();
			glFlush();			// make sure changes will be visible, some glut progs don't do flush in there draw callback !
			
#if defined(GFXLIB_MESA26)
			[_visual swapBuffers];
#endif
		
			if(__glutDebug)
				glutReportErrors();
			_flags.isDamaged = NO;
		}
		
		if(_overlay)
			[_overlay displayInRect: aRect];
	}
}

	/* Unlocks the receiver's and it's child views drawing code. */
- (void)_recursivelyUnlockDrawing
{
	_flags.isDrawingLocked = NO;
	
		// tell our childs what's going on
	{
		register NSArray *	subviews = [self subviews];
		register unsigned		i, count = [subviews count];
		
		for(i = 0; i < count; i++)
			[[subviews objectAtIndex: i] _recursivelyUnlockDrawing];
	}
}

- (void)resizeWithOldSuperviewSize:(NSSize)oldFrameSize
{
	[super resizeWithOldSuperviewSize: oldFrameSize];
	[self reshapeWithNewSize: [self bounds].size];
}

- (void)reshapeWithNewSize: (NSSize)newFrameSize
{	
	[_visual setSize: newFrameSize];
	if(_overlay)
		[_overlay setSize: newFrameSize];

	[self makeCurrent];
	
	if(_reshapeCallback)
	{
		(*_reshapeCallback)((int) newFrameSize.width, (int) newFrameSize.height);
		
		if(__glutDebug)
			glutReportErrors();
	}
	else
		glViewport(0, 0, (GLsizei) newFrameSize.width, (GLsizei) newFrameSize.height);
	
	_flags.isDamaged = YES;
}


		/* *** event handling *** */


- (void)keyDown: (NSEvent *)theEvent
{
	unichar		unicodeKey;
	int			asciiKey = 0;
	BOOL			callKeyCallback = NO;
	
	if((_flags.ignoreKeyRepeats == YES) && ([theEvent isARepeat] == YES))
		return;

		/* determine true key value and responsible callback */
	if([theEvent modifierFlags] & NSAlternateKeyMask)
		unicodeKey = [[theEvent charactersIgnoringModifiers] characterAtIndex:0];
	else
		unicodeKey = [[theEvent characters] characterAtIndex: 0];
	
	asciiKey = [self _mapNativeKeyCodeToGLUTCode: unicodeKey isAscii: &callKeyCallback];
	[self _updateModifierFlags: theEvent];
		/* read the current mouse location */
	_keyDownMouseLocation = [self convertPoint: [[self window] mouseLocationOutsideOfEventStream] fromView: nil];
	
	if(__glutGameMode == YES)
	{
		if(asciiKey == 27 || ((asciiKey == 'c' || asciiKey == 'C') && (_modifierFlags & GLUT_ACTIVE_CTRL)))
		{
			[NSApp terminate: nil];
			return;
		}
	}
		/* call appropriate keyboard callback */
	[self lockFocus];
	[self makeCurrent];
	_flags.modifierFlagsValid = YES;
	if(callKeyCallback == YES)
	{
		if(_keyboardCallback)
			(*_keyboardCallback)((unsigned char) asciiKey, (int) _keyDownMouseLocation.x, (int) _keyDownMouseLocation.y);
	}
	else
	{
		if(_specialCallback)
			(*_specialCallback)(asciiKey, (int) _keyDownMouseLocation.x, (int) _keyDownMouseLocation.y);
	}
	_flags.modifierFlagsValid = NO;
	[self unlockFocus];
	
	if(__glutDebug)
		glutReportErrors();
}

- (void)keyUp: (NSEvent *)theEvent
{
	unichar		unicodeKey;
	int			asciiKey = 0;
	BOOL			callKeyCallback = NO;
	
	if((_flags.ignoreKeyRepeats == YES) && ([theEvent isARepeat] == YES))
		return;
	
		/* determine true key value and responsible callback */
	if([theEvent modifierFlags] & NSAlternateKeyMask)
		unicodeKey = [[theEvent charactersIgnoringModifiers] characterAtIndex:0];
	else
		unicodeKey = [[theEvent characters] characterAtIndex: 0];
	
	asciiKey = [self _mapNativeKeyCodeToGLUTCode: unicodeKey isAscii: &callKeyCallback];	
	[self _updateModifierFlags: theEvent];
		
	[self lockFocus];
	[self makeCurrent];
	_flags.modifierFlagsValid = YES;
	if(callKeyCallback == YES)
	{
		if(_keyUpCallback)
			(*_keyUpCallback)((unsigned char) asciiKey, (int) _keyDownMouseLocation.x, (int) _keyDownMouseLocation.y);
	}
	else
	{
		if(_specialUpCallback)
			(*_specialUpCallback)(asciiKey, (int) _keyDownMouseLocation.x, (int) _keyDownMouseLocation.y);
	}
	_flags.modifierFlagsValid = NO;
	[self unlockFocus];
	
	if(__glutDebug)
		glutReportErrors();
}

	/* intercept mouse down */
- (void)mouseDown: (NSEvent *)theEvent
{
	[self _updateModifierFlags: theEvent];
	
	if(__glutEmulateMultiButtonMouse == YES)
	{
		if(_modifierFlags & GLUT_ACTIVE_CTRL)
			{ _modifierFlags &= ~GLUT_ACTIVE_CTRL;	[self _mouseDown: theEvent mouseButton: GLUT_RIGHT_BUTTON]; }
		else if(_modifierFlags & GLUT_ACTIVE_ALT)
			{ _modifierFlags &= ~GLUT_ACTIVE_ALT;	[self _mouseDown: theEvent mouseButton: GLUT_MIDDLE_BUTTON]; }
		else
			[self _mouseDown: theEvent mouseButton: GLUT_LEFT_BUTTON];
	}
	else
		[self _mouseDown: theEvent mouseButton: GLUT_LEFT_BUTTON];
}

- (void)mouseUp: (NSEvent *)theEvent
{
	[self _updateModifierFlags: theEvent];
	
	if(__glutEmulateMultiButtonMouse == YES)
	{
		if(_modifierFlags & GLUT_ACTIVE_CTRL)
			{ _modifierFlags &= ~GLUT_ACTIVE_CTRL;	[self _mouseUp: theEvent mouseButton: GLUT_RIGHT_BUTTON]; }
		else if(_modifierFlags & GLUT_ACTIVE_ALT)
			{ _modifierFlags &= ~GLUT_ACTIVE_ALT;	[self _mouseUp: theEvent mouseButton: GLUT_MIDDLE_BUTTON]; }
		else
			[self _mouseUp: theEvent mouseButton: GLUT_LEFT_BUTTON];
	}
	else
		[self _mouseUp: theEvent mouseButton: GLUT_LEFT_BUTTON];
}

- (void)mouseDragged: (NSEvent *)theEvent
{
	[self _updateModifierFlags: theEvent];
	
	if(__glutEmulateMultiButtonMouse == YES)
	{
		if(_modifierFlags & GLUT_ACTIVE_CTRL)
			{ _modifierFlags &= ~GLUT_ACTIVE_CTRL;	[self _mouseDragged: theEvent mouseButton: GLUT_RIGHT_BUTTON]; }
		else if(_modifierFlags & GLUT_ACTIVE_ALT)
			{ _modifierFlags &= ~GLUT_ACTIVE_ALT;	[self _mouseDragged: theEvent mouseButton: GLUT_MIDDLE_BUTTON]; }
		else
			[self _mouseDragged: theEvent mouseButton: GLUT_LEFT_BUTTON];
	}
	else
		[self _mouseDragged: theEvent mouseButton: GLUT_LEFT_BUTTON];
}

- (void)mouseMoved: (NSEvent *)theEvent
{
	NSPoint	location = [self convertPoint: [theEvent locationInWindow] fromView: nil];
		
	[self lockFocus];
	[self makeCurrent];
	_flags.modifierFlagsValid = YES;
	if(_passiveMotionCallback)
	{
		if(_passiveMotionCallback)
			(*_passiveMotionCallback)((int) location.x, (int) location.y);
	}
	_flags.modifierFlagsValid = NO;
	[self unlockFocus];
	
	if(__glutDebug)
		glutReportErrors();
}

- (void)rightMouseDown: (NSEvent *)theEvent
{
	[self _mouseDown: theEvent mouseButton: GLUT_RIGHT_BUTTON];
}

- (void)rightMouseUp: (NSEvent *)theEvent
{
	[self _mouseUp: theEvent mouseButton: GLUT_RIGHT_BUTTON];
}

- (void)rightMouseDragged: (NSEvent *)theEvent
{
	[self _mouseDragged: theEvent mouseButton: GLUT_RIGHT_BUTTON];
}

- (void)mouseEntered: (NSEvent *)theEvent
{
	[self lockFocus];
	[self makeCurrent];
	_flags.modifierFlagsValid = YES;
	if(_entryCallback)
	{
		if(_entryCallback)
			(*_entryCallback)(GLUT_ENTERED);
	}
	_flags.modifierFlagsValid = NO;
	[self unlockFocus];
	
	if(__glutDebug)
		glutReportErrors();
}

- (void)mouseExited: (NSEvent *)theEvent
{
	[self lockFocus];
	[self makeCurrent];
	_flags.modifierFlagsValid = YES;
	if(_entryCallback)
	{
		if(_entryCallback)
			(*_entryCallback)(GLUT_LEFT);
	}
	_flags.modifierFlagsValid = NO;
	[self unlockFocus];
	
	if(__glutDebug)
		glutReportErrors();
}

- (void)_mouseDown: (NSEvent *)theEvent mouseButton: (int)button
{
	NSPoint	location = [self convertPoint: [theEvent locationInWindow] fromView: nil];
	
	[self _updateModifierFlags: theEvent];
	
	[self lockFocus];	
	[self makeCurrent];
	_flags.modifierFlagsValid = YES;
	if(_mouseCallback)
	{
		if(_mouseCallback)
			(*_mouseCallback)(button, GLUT_DOWN, (int) location.x, (int) location.y);
	}
	_flags.modifierFlagsValid = NO;
	[self unlockFocus];
	
	if(__glutDebug)
		glutReportErrors();
}

- (void)_mouseUp: (NSEvent *)theEvent mouseButton: (int)button
{
	NSPoint	location = [self convertPoint: [theEvent locationInWindow] fromView: nil];
	
	[self _updateModifierFlags: theEvent];
	
	[self lockFocus];	
	[self makeCurrent];
	_flags.modifierFlagsValid = YES;
	if(_mouseCallback)
	{
		if(_mouseCallback)
			(*_mouseCallback)(button, GLUT_UP, (int) location.x, (int) location.y);
	}
	_flags.modifierFlagsValid = NO;
	[self unlockFocus];
	
	if(__glutDebug)
		glutReportErrors();
}

- (void)_mouseDragged: (NSEvent *)theEvent mouseButton: (int)button
{
	NSPoint	location  = [self convertPoint: [theEvent locationInWindow] fromView: nil];
	
	[self lockFocus];	
	[self makeCurrent];
	_flags.modifierFlagsValid = YES;
	if(_motionCallback)
	{
		if(_motionCallback)
			(*_motionCallback)((int) location.x, (int) location.y);
	}
	_flags.modifierFlagsValid = NO;
	[self unlockFocus];
	
	if(__glutDebug)
		glutReportErrors();
}

- (void)_updateModifierFlags: (NSEvent *)theEvent
{
	register unsigned int	eventFlags = [theEvent modifierFlags];
	
	_modifierFlags = 0;
	
		/* update our modifier flags */
	if(eventFlags & NSControlKeyMask)
		_modifierFlags |= GLUT_ACTIVE_CTRL;
	
	if(eventFlags & NSShiftKeyMask)
		_modifierFlags |= GLUT_ACTIVE_SHIFT;
	
	if(eventFlags & NSAlternateKeyMask)
		_modifierFlags |= GLUT_ACTIVE_ALT;
}

- (int)_mapNativeKeyCodeToGLUTCode: (unichar)unicodeKey isAscii: (BOOL *)isascii
{
	int	asciiKey = 'A';
	
	*isascii = NO;
	switch(unicodeKey)
	{
		case NSF1FunctionKey:
										asciiKey = GLUT_KEY_F1;
										break;
		case NSF2FunctionKey:
										asciiKey = GLUT_KEY_F2;
										break;
		case NSF3FunctionKey:
										asciiKey = GLUT_KEY_F3;
										break;
		case NSF4FunctionKey:
										asciiKey = GLUT_KEY_F4;
										break;
		case NSF5FunctionKey:
										asciiKey = GLUT_KEY_F5;
										break;
		case NSF6FunctionKey:
										asciiKey = GLUT_KEY_F6;
										break;
		case NSF7FunctionKey:
										asciiKey = GLUT_KEY_F7;
										break;
		case NSF8FunctionKey:
										asciiKey = GLUT_KEY_F8;
										break;
		case NSF9FunctionKey:
										asciiKey = GLUT_KEY_F9;
										break;
		case NSF10FunctionKey:
										asciiKey = GLUT_KEY_F10;
										break;
		case NSF11FunctionKey:
										asciiKey = GLUT_KEY_F11;
										break;
		case NSF12FunctionKey:
										asciiKey = GLUT_KEY_F12;
										break;
		case NSUpArrowFunctionKey:
										asciiKey = GLUT_KEY_UP;
										break;
		case NSDownArrowFunctionKey:
										asciiKey = GLUT_KEY_DOWN;
										break;
		case NSLeftArrowFunctionKey:
										asciiKey = GLUT_KEY_LEFT;
										break;
		case NSRightArrowFunctionKey:
										asciiKey = GLUT_KEY_RIGHT;
										break;
		case NSPageUpFunctionKey:
										asciiKey = GLUT_KEY_PAGE_UP;
										break;
		case NSPageDownFunctionKey:
										asciiKey = GLUT_KEY_PAGE_DOWN;
										break;
		case NSHomeFunctionKey:
										asciiKey = GLUT_KEY_HOME;
										break;
		case NSEndFunctionKey:
										asciiKey = GLUT_KEY_END;
										break;
		case NSInsertFunctionKey:
										asciiKey = GLUT_KEY_INSERT;
										break;
		default:
					if(unicodeKey < 128)
					{
						*isascii = YES;
						asciiKey = (int) (unicodeKey & 0x00FF);
					}
					break;
	}
	
	return asciiKey;
}

- (void)_updateTrackingRects: (NSNotification *)notification
{
	BOOL		isInside = NO;
	NSPoint	mouseLoc = [[self window] mouseLocationOutsideOfEventStream];
		
	[self removeTrackingRect: _trackingRectTag];
		
	mouseLoc = [self convertPoint: mouseLoc fromView: nil];
	isInside = NSMouseInRect(mouseLoc, [self bounds], YES);
	_trackingRectTag = [self addTrackingRect: [self bounds] owner: self userData: nil assumeInside: isInside];
}

- (void)resetCursorRects
{
	if(_cursorObj != nil)
		[self addCursorRect: [self visibleRect] cursor: _cursorObj];
}

- (NSCursor *)_unvisibleCursor
{	
	if(__glutUnvisibleCursor == nil)
	{
		NSImage *				cursorImage = [[NSImage alloc] initWithSize: NSMakeSize(16.0, 16.0)];
		NSBitmapImageRep *	cursorBitMap = nil;
		
		cursorBitMap = [[NSBitmapImageRep alloc]	initWithBitmapDataPlanes: NULL
																pixelsWide: 16
																pixelsHigh: 16
																bitsPerSample: 8
																samplesPerPixel: 4
																hasAlpha: YES
																isPlanar: NO
																colorSpaceName: NSDeviceRGBColorSpace
																bytesPerRow: 64
																bitsPerPixel: 0]; 
		[cursorImage addRepresentation: cursorBitMap];
		[cursorBitMap release];
		
		memset([cursorBitMap bitmapData], 0, 64 * 16);
		__glutUnvisibleCursor = [[[NSCursor alloc] initWithImage: cursorImage hotSpot: NSMakePoint(0.0, 0.0)] retain];
		[__glutUnvisibleCursor setOnMouseEntered: YES];
	}
	return __glutUnvisibleCursor;
}

	/* Make sure that the new subview will be able to draw. */
- (void)didAddSubview:(NSView *)subview
{
	if(_flags.isDrawingLocked == NO)
		[((GLUTView *) subview) _recursivelyUnlockDrawing];
}

- (void)willRemoveSubview:(NSView *)subview
{
	[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: YES];
}


		/* *** Window status machinery *** */


	/* Returns an array of views and windows which are either contained or intersected by the given rect. "screenRect" must
      be expressed in screen coordinates. */
+ (NSArray *)arrayWithWindowsContainedOrIntersectedByRect: (NSRect)screenRect
{
	NSMapEnumerator	enumerator = NSEnumerateMapTable(__glutWindowList);
	int					key = 0;
	id<GLUTWindows>	window = nil;
	NSMutableArray *	windowArray = [NSMutableArray arrayWithCapacity: 4];
	
	while(NSNextMapEnumeratorPair(&enumerator, (void *) &key, (void *) &window) == YES)
	{
		NSRect	screenWindowFrame;
		
			/* XXX is this really possible ? */
		if([window windowStatus] == GLUT_HIDDEN)
			continue;		// ignore hidden windows
		
			// convert the frame of our candidate window to the screen coord system
		if([window isMemberOfClass: [GLUTWindow class]] == YES)
			window = [((NSWindow *) window) contentView];
		
		screenWindowFrame = [((NSView *) window) convertRect: [((NSView *) window) bounds] toView: nil];
		screenWindowFrame.origin = [[((NSView *) window) window] convertBaseToScreen: screenWindowFrame.origin];
		
			// see whether the frame rect of our candidate is completly inside the given rect or if it
			// simply intersects it
		if(NSContainsRect(screenRect, screenWindowFrame) == YES)
			[windowArray addObject: window];
		else if(NSIntersectsRect(screenRect, screenWindowFrame) == YES)
			[windowArray addObject: window];
	}
	
	return windowArray;
}

+ (void)walkWindowStackStartingWithView: (GLUTView *)refView ignoreSiblings: (BOOL)ignoreSiblings
{
	NSRect					myRect = [refView convertRect: [refView bounds] toView: nil];
	NSArray *				affectedWindows;
	register unsigned		i;
	
		// get a list of all affected windows
	myRect.origin = [[refView window] convertBaseToScreen: myRect.origin];
	affectedWindows = [GLUTView arrayWithWindowsContainedOrIntersectedByRect: myRect];
	
		// tell these windows to test and set there window status
	for(i = 0; i < [affectedWindows count]; i++)
	{
		id<GLUTWindows>	actWindow = [affectedWindows objectAtIndex: i];
		
		[actWindow updateWindowStatus: [actWindow determineWindowStatusIgnoringSiblings: ignoreSiblings]];
	}
}

	/* Marks the receiver and it's descendants as views with unknown visibility. */
- (void)_recursivelyMarkAsVisibilityUnknown
{
	if(_windowStatus == GLUT_HIDDEN)
	{
		_windowStatus = GLUT_UNKNOWN_VISIBILITY;
		
			// tell our childs what's going on
		{
			register NSArray *	subviews = [self subviews];
			register unsigned		i, count = [subviews count];
			
			for(i = 0; i < count; i++)
				[[subviews objectAtIndex: i] _recursivelyMarkAsVisibilityUnknown];
		}
	}
}

	/* Marks the receiver and it's descendants as being hidden. */
- (void)_recursivelyMarkAsHidden
{
	if(_windowStatus != GLUT_HIDDEN)
	{
		_windowStatus = GLUT_HIDDEN;
		if(_windowStatusCallback || _visibilityCallback)
		{
			[self makeCurrent];
			
			if(_visibilityCallback)
				(*_visibilityCallback)(GLUT_NOT_VISIBLE);
			if(_windowStatusCallback)
				(*_windowStatusCallback)(GLUT_HIDDEN);
					
			if(__glutDebug)
				glutReportErrors();
		}
		
			// tell our childs what's going on
		{
			register NSArray *	subviews = [self subviews];
			register unsigned		i, count = [subviews count];
			
			for(i = 0; i < count; i++)
				[[subviews objectAtIndex: i] _recursivelyMarkAsHidden];
		}
	}
}


		/* *** GLUTWindow delegate methods *** */


	/* Update the window status of the receiver and all of it's sub windows. */
- (void)windowWillMiniaturize:(NSNotification *)notification
{
	[self _recursivelyMarkAsHidden];
	[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: NO];
}

	/* Update the window status of the receiver and all of it's sub windows. */
- (void)windowDidDeminiaturize:(NSNotification *)notification
{
	[self _recursivelyMarkAsVisibilityUnknown];
	[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: NO];
	_flags.isDamaged = YES;
}

	/* Update the window status of all windows which could have been exposed our (partially) hidden by the move. */
- (void)windowWillMove:(NSNotification *)notification
{
	[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: NO];
}

	/* Update the window status of all windows which could have been exposed our (partially) hidden by the move. */
- (void)windowDidMove:(NSNotification *)notification
{
	[GLUTView walkWindowStackStartingWithView: self ignoreSiblings: NO];
}

	/* XXX doesn't look like we get every called - on the other side we are a buffered window,
		so expose events shouldn't ever appear after all. */
- (void)windowDidExpose:(NSNotification *)notification
{
	_flags.isDamaged = YES;
}

#if defined(INTERCEPTOR_HATES_EPS)

- (NSWindow *)_windowWithTIFFInsideRect: (NSRect)rect
{
	NSBitmapImageRep *	bitmapImageRep = nil;
	NSImage *				myImage = nil;
	NSImageView *			myImageView = nil, *myImageViewWeakRef = nil;
	NSWindow *				myWindow = nil;
	
		// create a window containing an NSImageView to act as the EPS generator
	myImageView = [[NSImageView allocWithZone: [self zone]]	initWithFrame: rect];
	if(myImageView == nil)
		return nil;
	
	FailNil(myWindow = [[NSWindow allocWithZone: [self zone]]	initWithContentRect: rect
																					styleMask: NSBorderlessWindowMask
																					backing: NSBackingStoreNonretained
																					defer: NO]);	
	[myWindow setContentView: myImageView];
	[myImageView release]; myImageViewWeakRef = myImageView; myImageView = nil;
		// create an NSImage containing the actual window contents as TIFF graphics
	FailNil(myImage = [[NSImage allocWithZone: [self zone]] init]);
	
	[self lockFocus];
		bitmapImageRep = [[NSBitmapImageRep allocWithZone: [self zone]] initWithFocusedViewRect: rect];
		if(bitmapImageRep == nil)
		{
			[self unlockFocus];
			goto _failed;
		}
	[self unlockFocus];
	
	[myImage addRepresentation: bitmapImageRep];
	[bitmapImageRep release]; bitmapImageRep = nil;
	[myImageViewWeakRef setImage: myImage];
	[myImage release]; myImage = nil;
	
	return myWindow;
	
_failed:
	
	[myWindow release];
	[myImageView release];
	[myImage release];
	[bitmapImageRep release];
	return nil;
}

- (void)print:(id)sender
{
	NSWindow *		myWindow = [self _windowWithTIFFInsideRect: [self bounds]];
	
	if(myWindow)
	{
			// display print panel
		[[NSPrintOperation printOperationWithView: [myWindow contentView]] runOperation];
		[myWindow release];
	}
	else
	{
		NSRunCriticalAlertPanel(FWLocalizedString(@"Print Error"),
										FWLocalizedString(@"Could not generate EPS data for printing."), @"OK", nil, nil);
	}
}

# ifndef WIN32
- (void)fax:(id)sender
{
	NS_DURING
	{
		NSWindow *		myWindow = [self _windowWithTIFFInsideRect: [self bounds]];
		
		if(myWindow != nil)
		{
			NSPrintInfo *	myPrintInfo = [NSPrintInfo sharedPrintInfo];
			NSString *		savedJobDisposition = [myPrintInfo jobDisposition];
			
				// setup print info for faxing
			[myPrintInfo setJobDisposition: NSPrintFaxJob];
				// display fax panel (supplied view is not retained)
			[[NSPrintOperation printOperationWithView: [myWindow contentView] printInfo: myPrintInfo] runOperation];
			[myPrintInfo setJobDisposition: savedJobDisposition];
			[myWindow release];
		}
		else
		{
			NSRunCriticalAlertPanel(FWLocalizedString(@"Fax Error"),
											FWLocalizedString(@"Could not generate EPS data for faxing."), @"OK", nil, nil);
		}
	
		NS_VOIDRETURN;
	}
	
	NS_HANDLER
	{
		NSRunInformationalAlertPanel(FWLocalizedString(@"Fax Error"),
												FWLocalizedString(@"Faxing is not possible in this release of Rhapsody."), @"OK", nil, nil);
	}
	NS_ENDHANDLER
}
# endif

#endif

@end
