
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTWindow.h"







/* **** GLUT API ***** */


void glutGameModeString(const char *string)
{
	/* unimplemented */
}

int glutEnterGameMode(void)
{
	if(__glutMenuMode == YES)
		return 0;
	else
	{
		GLUTWindow *	win = nil;
		
		win = [[GLUTWindow alloc] initWithTitle: @"" displayString: __glutDisplayString gameMode: YES];
		if(win == nil)
			__glutFatalError("out of memory.");
		
		NSMapInsertKnownAbsent(__glutWindowList, (void *) ++__glutWindowUniqueID, win);
		[win setWindowKey: __glutWindowUniqueID];
		[win release];
		
		[win makeCurrent];
		__glutGameModeWindow = __glutWindowUniqueID;
		__glutGameMode = YES;
	}
	return 1;
}

void glutLeaveGameMode(void)
{
	if(__glutGameMode == YES)
	{
			/* recursively destroys all childrens and unbinds GL */
		NSMapRemove(__glutWindowList, (void *) __glutGameModeWindow);
		__glutGameModeWindow = 0;
		__glutGameMode = NO;
	}
}

int glutGameModeGet(GLenum mode)
{
	switch(mode)
	{
		case GLUT_GAME_MODE_ACTIVE:
					return (int) __glutGameMode;
		case GLUT_GAME_MODE_POSSIBLE:
					return 0;
		case GLUT_GAME_MODE_WIDTH:
					return (int) [[NSScreen mainScreen] frame].size.width;
		case GLUT_GAME_MODE_HEIGHT:
					return (int) [[NSScreen mainScreen] frame].size.height;
		case GLUT_GAME_MODE_DISPLAY_CHANGED:
					return 0;
		default:
			__glutWarning("invalid glutGameModeGet parameter: %d", mode);
			return -1;	
	}
}
