.\"
.\" Copyright (c) Mark J. Kilgard, 1996, 1998.
.\"
.TH glutDeviceGet 3GLUT "3.7" "GLUT" "GLUT"
.SH NAME
glutDeviceGet - retrieves GLUT device information represented by integers. 
.SH SYNTAX
.nf
.LP
int glutDeviceGet(GLenum info);
.fi
.SH ARGUMENTS
.IP \fIinfo\fP 1i
Name of device information to retrieve.
.TP 8
.B GLUT_HAS_KEYBOARD 
Non-zero if a keyboard is available; zero if not available. For most
GLUT implementations, a keyboard can be assumed.
.TP 8
.B GLUT_HAS_MOUSE
Non-zero if a mouse is available; zero if not available. For most GLUT
implementations, a keyboard can be assumed. 
.TP 8
.B GLUT_HAS_SPACEBALL
Non-zero if a Spaceball is available; zero if not available. 
.TP 8
.B GLUT_HAS_DIAL_AND_BUTTON_BOX 
Non-zero if a dial & button box is available; zero if not available. 
.TP 8
.B GLUT_HAS_TABLET 
Non-zero if a tablet is available; zero if not available. 
.TP 8
.B GLUT_NUM_MOUSE_BUTTONS 
Number of buttons supported by the mouse. If no mouse is supported, zero is
returned. 
.TP 8
.B GLUT_NUM_SPACEBALL_BUTTONS 
Number of buttons supported by the Spaceball. If no Spaceball is supported, zero is
returned. 
.TP 8
.B GLUT_NUM_BUTTON_BOX_BUTTONS 
Number of buttons supported by the dial & button box device. If no dials & button
box device is supported, zero is returned. 
.TP 8
.B GLUT_NUM_DIALS 
Number of dials supported by the dial & button box device. If no dials & button
box device is supported, zero is returned. 
.TP 8
.B GLUT_NUM_TABLET_BUTTONS 
Number of buttons supported by the tablet. If no tablet is supported, zero is
returned. 
.TP 8
.B GLUT_DEVICE_IGNORE_KEY_REPEAT
Returns true if the current window's auto repeated keys are ignored.
This state is controlled by glutIgnoreKeyRepeat.
.TP 8
.B GLUT_DEVICE_KEY_REPEAT
The window system's global key repeat state.  Returns either GLUT_KEY_REPEAT_OFF, GLUT_KEY_REPEAT_ON, or GLUT_KEY_REPEAT_DEFAULT.  This will not necessarily return the value last passed to glutSetKeyRepeat.
.TP 8
.B GLUT_JOYSTICK_POLL_RATE
Returns the current window's joystick poll rate as set by glutJoystickFunc.  If no joystick is supported, the poll rate will always be zero.  The joystick poll
rate also returns zero if the poll rate last specified to glutJoystickFunc is negative or a NULL callback was registered.
.TP 8
.B GLUT_HAS_JOYSTICK
Non-zero if a joystick is available; zero if not available.
.TP 8
.B GLUT_JOYSTICK_BUTTONS
Number of buttons supported by the joystick.  If no joystick is supported, zero is returned.
.TP 8
.B GLUT_JOYSTICK_AXES
Number of axes supported by the joystick.  If no joystick is supposrted, zero is returned.
.SH DESCRIPTION
glutDeviceGet retrieves GLUT device information represented by integers. The info
parameter determines what type of device information to return. Requesting device
information for an invalid GLUT device information name returns negative one.
.SH X IMPLEMENTATION NOTES
The current implementation uses to X Input extension to regonize SGI's Spaceball,
tablet, and dial and button box devices.
.SH WIN32 IMPLEMENTATION NOTES
The GLUT_DEVICE_KEY_REPEAT alwasy returns GLUT_KEY_REPEAT_ON.
.SH SEE ALSO
glutGet, glutKeyboardFunc, glutMouseFunc, glutSpaceballMotion, glutTabletMotionFunc, glutTabletButtonFunc,
glutDialsFunc, glutButtonBoxFunc, glutIgnoreKeyRepeat, glutSetKeyRepeat, glutJoystickFunc
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
