/*
 * SYSTEM 16 ARCADE EMULATOR SOURCE CODE
 * 
 * Copyright 1996/97 Thierry Lescot
 */

.file "asm.s"

.set ASM_MEM, OK
.set TEXT_WITHBANK, OK

.data
.align 4
SPR_BASE:       .long 0
SCR_BASE:       .long 0
SPR_HEIGHT:     .byte 0
SPR_WIDTH:      .byte 0
SPR_WIDTHD:     .byte 0
SPR_COLOR:      .long 0
SPR_MODE:       .byte 0

SPR_REVERSE_FLAG:       .byte 0
SPR_FLIP_FLAG:          .byte 0
CPT_LINE:               .byte 0
CPT_COLUMN:             .byte 0
VIDEO_BASE_SAVE:        .long 0
DISPLAY_BASE_SAVE:      .long 0
CPT_BRIQUE:             .byte 0
START_EDX:              .long 0
BASE_COULEUR_BRIQUE:    .long 0
FORCE_SPRITE:           .byte 0
FORCE_FOND:             .byte 0

LAST_BANK:      .long 0
TILE_BANK:      .long 0
PAGE_1:         .long 0
PAGE_2:         .long 0
PAGE_S:         .long 0
PAGE_1L:        .long 0
PAGE_2L:        .long 0
PAGE_SELECT:    .long 0
PAGE_LIMIT:     .word 0

SPR_ACTIVE:     .byte 1

.text
.ifdef ASM_MEM
.globl _get_byteA
_get_byteA:
	pushl %esi
	pushl %ebx
	movb 14(%esp),%bl
	movw 12(%esp),%si
        cmpb %bl,_ctr_bank
        jne J1B
	movzwl %si,%eax
	pushl %eax
	call _CheckInput
	addl $4,%esp
J1B:
	movzbl %bl,%eax
	movzwl %si,%edx
	movl _RAM(,%eax,4),%eax
	movzbl (%edx,%eax),%eax
	popl %ebx
	popl %esi
	ret

.globl  _put_byteA
_put_byteA:
        pushl   %ebp
        movl    %esp,%ebp
        movzwl  8(%ebp),%ecx
        movzbl  10(%ebp),%eax
        cmpb    $0xFE,%al
        je      _sound_request
        movl    _RAM(,%eax,4),%edx
        movb    12(%ebp),%al
        movb    %al,(%edx, %ecx)
        popl    %ebp
        ret
_sound_request:
        cmpw    $0x0007,%ecx
        jne     _nomore_sound
        movb    12(%ebp),%al
        cmpb    $0xA0,%al
        jl      _bgm_select
_sfx_select:
        cmpb    $0x90,%al
        jl      _voice_select
        cmpb    $1,_sfx_enabled
        je      _request_sound
_bgm_select:
        movb    %al,_last_bgm
        cmpb    $1,_bgm_enabled
        je      _request_sound
_voice_select:
        cmpb    $1,_voice_enabled
        jne     _nomore_sound
_request_sound:
//        movl    _sound_buffer,%edx
        movl    _sbuf_ptr,%edx
        xorl    %ecx,%ecx
        movb    _sbuf_write,%cl
        movb    %al,(%edx,%ecx)
        addb    $1,%cl
        cmpb    $20,%cl
        jl      _not_buffer_end
        xorb    %cl,%cl
_not_buffer_end:
        movb    %cl,_sbuf_write
_nomore_sound:
        popl    %ebp
        ret
        .align 4

.globl _get_wordA
_get_wordA:
	pushl %esi
	pushl %ebx
	movb 14(%esp),%bl
	movw 12(%esp),%si
        cmpb %bl,_ctr_bank
        jne J1W
	movzwl %si,%eax
	pushl %eax
	call _CheckInput
	addl $4,%esp
J1W:
	movzbl %bl,%eax
	movzwl %si,%ecx
	movl _RAM(,%eax,4),%edx
        movb (%ecx,%edx),%ah
        movb 1(%ecx,%edx),%al
	popl %ebx
	popl %esi
	ret

.globl  _put_wordA
_put_wordA:
        pushl   %ebp
        movl    %esp,%ebp
        movzwl  8(%ebp),%ecx
        movzbl  10(%ebp),%eax
        movl    _RAM(,%eax,4),%edx
        movzwl  12(%ebp),%eax
        bswapl  %eax
        sarl    $16,%eax
        movw    %eax,(%edx, %ecx)
        popl    %ebp
        ret
        .align 4

.globl _get_longA
_get_longA:
        pushl   %esi
        pushl   %ebx
        movb    14(%esp),%bl
        movw    12(%esp),%si
        cmpb    %bl,_ctr_bank
        jne     J1L
        movzwl  %si,%eax
        pushl   %eax
        call    _CheckInput
        addl    $4,%esp
J1L:
        movzbl  %bl,%eax
        movzwl  %si,%ecx
        movl    _RAM(,%eax,4),%edx
        movl    (%ecx,%edx),%eax
        bswapl  %eax
        popl    %ebx
        popl    %esi
	ret

.globl  _put_longA
_put_longA:
        pushl   %ebp
        movl    %esp,%ebp
        movzwl  8(%ebp),%ecx
        movzbl  10(%ebp),%eax
        movl    _RAM(,%eax,4),%edx
        movl    12(%ebp),%eax
        bswapl  %eax
        movl    %eax,(%edx, %ecx)
        popl    %ebp
        ret
        .align 4
.endif

.globl  _asm_SwapWord
_asm_SwapWord:
        push    %ebp
        movl    %esp,%ebp
        movw    8(%esp),%eax
        bswapl  %eax
        shrl    $16,%eax
        popl    %ebp
        ret

.globl  _asm_render_screen
_asm_render_screen:
        pushal
        pushw   %es

        cmpb    $6,_game
        je      _render_screen_system18

        movl    _bank_ff_base,%edi
        movl    $0x0000F01E,%edx
        movb    (%edi,%edx),%eax
        movb    %eax,SPR_ACTIVE

        movb    $0,_number_of_new_colors

_render_text_screen:
        call    _asm_render_text
        call    _asm_render_foreground_priority
        cmpb    $0xFF,SPR_ACTIVE
        je      _render_foreground
        movb    $0x80,SPR_MODE
        call    _asm_render_sprites
_render_foreground:
        call    _asm_render_foreground_nopriority
        cmpb    $0xFF,SPR_ACTIVE
        je      _render_background
        movb    $0x00,SPR_MODE
        call    _asm_render_sprites 
_render_background:
        testb    $1,_background_active
        jz      _fin_render
        call    _asm_render_background

        jmp     _fin_render

_render_screen_system18:
        movb    $0,_number_of_new_colors
_render_text_screen18:
        call    _asm_render_text
        movb    $0x80,SPR_MODE
        call    _asm_render_sprites
        xorl    %edx,%edx
        call    _asm_render_playfield
        movb    $0x00,SPR_MODE
        call    _asm_render_sprites 
        movl    $2,%edx
        call    _asm_render_playfield

_fin_render:
        popw    %es
        popal
        ret


_asm_render_playfield:
        xorl    %ebx,%ebx
        movb    %dl,FORCE_FOND
        movl    _ptr_text_video,%esi
        testb   %dl,%dl
        jz      _use_regE80
        addl    %edx,%esi
        cmpb    $0x80,0xE98(%esi)
        jne     _use_regE80
        addl    $0x4,%esi
_use_regE80:
        movb    0xE91(%esi),%al
        movb    %al,%cl
        andl    $0x7,%ecx
        shlw    $9,%ecx
        andl    $0xF8,%eax
        shlw    $4,%ax
        movw    %ax,PAGE_LIMIT
        addl    _foreground_base,%eax
        movl    %eax,PAGE_1
        movl    %eax,PAGE_2

        movb    0xE81(%esi),%ah
        movb    %ah,%dh
        andl    $0xF000,%eax
        addl    %eax,PAGE_1
        shlb    $4,%dh
        andl    $0xF000,%edx
        addl    %edx,PAGE_2

        movl    _foreground_base,%eax
        movl    %eax,PAGE_1L
        movl    %eax,PAGE_2L
        movb    0xE80(%esi),%ah
        movb    %ah,%dh
        andl    $0xF000,%eax
        addl    %eax,PAGE_1L
        shlb    $4,%dh
        andl    $0xF000,%edx
        addl    %edx,PAGE_2L

        movb    0xE98(%esi),%ah
        movb    0xE99(%esi),%al
        cmpw    $0x0200,%ax
        jl      _s18_special
        movl    PAGE_1L,%ebx
        movl    PAGE_2L,%edx
        movl    %edx,PAGE_1L
        movl    %ebx,PAGE_2L
        movl    PAGE_1,%ebx
        movl    PAGE_2,%edx
        movl    %edx,PAGE_1
        movl    %ebx,PAGE_2
_s18_special:
        andw    $0x01FF,%ax
        movw    %eax,%edx
        andw    $0x0007,%eax

        movl    _display_base,%ebx
        subl    %ecx,%ebx
        addl    %eax,%ebx
        addl    $8,%ebx
        movl    %ebx,DISPLAY_BASE_SAVE

        andl    $0xFFF8,%edx
        shrw    $2,%edx
        cmpb    $0x30,%dl
        jg      _saut1_s18
        movl    PAGE_2,%eax
        movl    %eax,PAGE_S
        movl    $0x30,START_EDX
        movb    $2,PAGE_SELECT
        jmp     _saut2_s18
_saut1_s18:
        movl    PAGE_1,%eax
        movl    %eax,PAGE_S
        movl    $0xB0,START_EDX
        movb    $1,PAGE_SELECT
_saut2_s18:
        subl    %edx,START_EDX
        movl    $0,LAST_BANK
        movb    $29,CPT_LINE

_render_s18_line:
        movb    $42,CPT_COLUMN
        movl    PAGE_S,%esi
        movl    DISPLAY_BASE_SAVE,%edi
        movl    START_EDX,%edx

_render_s18_column:
        movl    $0,%ebx
        movl    $0,%eax

        movb    (%esi,%edx),%al
        andb    $0x0F,%al
        shll    $14,%eax

        movb    1(%esi,%edx),%ebx
        shlw    $6,%ebx
        addl    %eax,%ebx
        addl    _tiles_base,%ebx
        testb   $0x10,(%esi, %edx)
        jz      _s18_saut5
        movl    _base_brq_page,%ecx
        movzbl  (%ecx),%eax
        cmpb    $0x10,%al
        jl      _s18_sd_special
        shrb    $4,%al
        jmp     _s18_sd_special2
_s18_sd_special:
        andb    $0x0F,%al
_s18_sd_special2:
        shll    $18,%eax
        addl    %eax,%ebx
_s18_saut5:
        movb    (%esi,%edx),%ah
        movb    1(%esi,%edx),%al
        andl    $0x00001FC0,%eax
        shrl    $2,%eax
        addl    _base_palette_shinobi,%eax
        movl    %eax,BASE_COULEUR_BRIQUE
        movl    %eax,TILE_BANK

        pushl   %edx
        pushl   %edi

        movl    TILE_BANK,%eax
        cmpl    %eax,LAST_BANK
        je      _no_color_init_s18

        movl    %eax,LAST_BANK
        movl    $16,%eax
_init_color_s18:
        subl    $2,%eax
        addl    BASE_COULEUR_BRIQUE,%eax
        movw    (%eax),%ecx
        subl    BASE_COULEUR_BRIQUE,%eax
        andl    $0xFF0F,%ecx
        movb    _Palette256(%ecx),%dl
        testb    %dl,%dl
        jne     _init_color_ok_s18
        incb    _pal_counter
        jnz     _init_color_rech_s18
        movb    $1,_pal_counter
        movb    $1,_reset_palette
_init_color_rech_s18:
        movb    _pal_counter,%dl
        movb    %dl,_Palette256(%ecx)
        pushl   %ebx
        movzbl  _number_of_new_colors,%ebx
        incb    _number_of_new_colors
        shlw    $2,%ebx
        addl    _base_new_colors_tab,%ebx
        movb    %dl,(%ebx)
        movb    %ch,1(%ebx)
        movb    %cl,2(%ebx)
        popl    %ebx

_init_color_ok_s18:
        movb    %dl,_FastPalette(%eax)
        cmpl    $0,%eax
        jne     _init_color_s18

_no_color_init_s18:
        movb    $8,%al
        movb    FORCE_FOND,%cl
_s18_brique_line:
        movb    $8,%ah
_s18_brique_column:
        cmpb    $0,(%edi)
        jne     _s18_transparence2
        movl    $0,%edx
        movb    (%ebx),%edx
        testb   %cl,%cl
        jnz     _force_fond
        testb   %dl,%dl
        jz      _s18_transparence2
_force_fond:
        movb    _FastPalette(%edx),%dl        
        movb    %dl,(%edi)
_s18_transparence2:
        incl    %ebx
        incl    %edi
        decb    %ah
        jnz     _s18_brique_column
        addl    $504,%edi
        decb    %al
        jnz     _s18_brique_line

        popl    %edi
        popl    %edx
_s18_fin_brique:
        addb    $2,%dl
        testb   $128,%dl
        jz      _pas_changement_page_s18
        xorb    %dl,%dl
        movl    PAGE_2,%esi
_pas_changement_page_s18:
        addl    $8,%edi
        decb    CPT_COLUMN
        jnz     _render_s18_column
        addl    $0x80,PAGE_S
        addl    $0x80,PAGE_1
        addl    $0x80,PAGE_2
        addl    $0x1000,DISPLAY_BASE_SAVE
        addw    $0x80,PAGE_LIMIT
        movw    PAGE_LIMIT,%dx
        andw    $0xFFF,%dx
        jnz     _ok18
        movl    PAGE_1L,%eax
        movl    %eax,PAGE_1
        movl    PAGE_2L,%eax
        movl    %eax,PAGE_2
        movl    $0,PAGE_LIMIT
        cmpb    $1,PAGE_SELECT
        je      _s18_switch1
        movl    %eax,PAGE_S
        jmp     _ok18
_s18_switch1:
        movl    PAGE_1L,%eax
        movl    %eax,PAGE_1
_ok18:
        decb    CPT_LINE
        jnz     _render_s18_line
        ret

/* GENERATION DE L'ECRAN TEXTE */

.globl _asm_render_text
_asm_render_text:
        movl    _display_base,%ebx
        movl    %ebx,DISPLAY_BASE_SAVE
        movl    _text_base,%ebx
        movl    %ebx,VIDEO_BASE_SAVE
        movl    $0,LAST_BANK
        movb    $29,CPT_LINE

_render_text_line:
        movb    $42,CPT_COLUMN
        movl    VIDEO_BASE_SAVE,%esi
        movl    DISPLAY_BASE_SAVE,%edi
        movl    $0,%edx

_render_text_column:
        movl    $0,%ebx

        movb    1(%esi,%edx),%ebx
        shlw    $6,%ebx
        addl    _tiles_base,%ebx

        movl    $0,%eax
        movb    (%esi,%edx),%eax
        andb    $0x1F,%eax  
.ifdef TEXT_WITHBANK
        movb    %eax,%ecx
        andl    $0x01,%ecx
        shll    $14,%ecx
        addl    %ecx,%ebx
.endif        
        shlb    $3,%eax

_text_fin_couleur:
        addl    _base_palette_shinobi,%eax
        movl    %eax,BASE_COULEUR_BRIQUE
        movl    %eax,TILE_BANK

        pushl   %edx
        pushl   %edi

        movl    TILE_BANK,%eax
        cmpl    %eax,LAST_BANK
        je      _no_color_init_text

        movl    %eax,LAST_BANK
        movl    $14,%eax
_init_color_text:
        addl    BASE_COULEUR_BRIQUE,%eax
        movw    (%eax),%ecx
        subl    BASE_COULEUR_BRIQUE,%eax
        andl    $0xFF0F,%ecx
        movb    _Palette256(%ecx),%dl
        testb    %dl,%dl
        jne     _init_color_ok_text
        incb    _pal_counter
        jnz     _init_color_rech_text
        movb    $1,_pal_counter
        movb    $1,_reset_palette
_init_color_rech_text:

        movb    _pal_counter,%dl
        movb    %dl,_Palette256(%ecx)
        pushl   %ebx
        movzbl  _number_of_new_colors,%ebx
        incb    _number_of_new_colors
        shlw    $2,%ebx
        addl    _base_new_colors_tab,%ebx
        movb    %dl,(%ebx)
        movb    %ch,1(%ebx)
        movb    %cl,2(%ebx)
        popl    %ebx

_init_color_ok_text:
        movb    %dl,_FastPalette(%eax)
        decb    %eax
        decb    %eax
        jnz     _init_color_text

_no_color_init_text:
        movb    $8,%al
_text_brique_line:
        movb    $8,%ah
_text_brique_column:
        movl    $0,%edx
        movb    (%ebx),%edx
        testb   %edx,%edx
        je      _text_transparence
        movb    _FastPalette(%edx),%dl
_text_transparence:
        movb    %dl,(%edi)
        incl    %ebx
        incl    %edi
        decb    %ah
        jnz     _text_brique_column
        addl    $504,%edi
        decb    %al
        jnz     _text_brique_line

        popl    %edi
        popl    %edx
        addl    $2,%edx
        addl    $8,%edi
        decb    CPT_COLUMN
        jnz     _render_text_column

        addl    $0x80,VIDEO_BASE_SAVE
        addl    $0x1000,DISPLAY_BASE_SAVE
        decb    CPT_LINE
        jnz     _render_text_line

        ret

_asm_render_foreground_priority:
        movl    $0,%ebx
        movl    _base_scr_ver_fg,%esi
        movb    (%esi),%al
        movb    %al,%cl
        andl    $0x7,%ecx
        shlw    $9,%ecx
        andl    $0xF8,%eax
        shlw    $4,%ax
        movw    %ax,PAGE_LIMIT
        addl    _foreground_base,%eax
        movl    %eax,PAGE_1
        movl    %eax,PAGE_2

        movl    _base_scr_pag_fg,%esi
        movb    (%esi),%ah
        movb    %ah,%dh
        andl    $0xF000,%eax
        addl    %eax,PAGE_1
        shlb    $4,%dh
        andl    $0xF000,%edx
        addl    %edx,PAGE_2

        movl    _foreground_base,%eax
        movl    %eax,PAGE_1L
        movl    %eax,PAGE_2L
        movb    -1(%esi),%ah
        movb    %ah,%dh
        andl    $0xF000,%eax
        addl    %eax,PAGE_1L
        shlb    $4,%dh
        andl    $0xF000,%edx
        addl    %edx,PAGE_2L

        movl    _base_scr_hor_fg,%esi
        movb    (%esi),%ah
        movb    1(%esi),%al
        andw    $0x01FF,%ax
        movw    %eax,%edx
        andw    $0x0007,%eax

        movl    _display_base,%ebx
        subl    %ecx,%ebx
        addl    %eax,%ebx
        addl    $8,%ebx
        movl    %ebx,DISPLAY_BASE_SAVE

        andl    $0xFFF8,%edx
        shrw    $2,%edx
        cmpb    $0x30,%dl
        jg      _saut1_fgp
        movl    PAGE_2,%eax
        movl    %eax,PAGE_S
        movl    $0x30,START_EDX
        jmp     _saut2_fgp
_saut1_fgp:
        movl    PAGE_1,%eax
        movl    %eax,PAGE_S
        movl    $0xB0,START_EDX
_saut2_fgp:
        subl    %edx,START_EDX

        movl    $0,LAST_BANK

        movb    $29,CPT_LINE

_render_fgp_line:
        movb    $42,CPT_COLUMN
        movl    PAGE_S,%esi
        movl    DISPLAY_BASE_SAVE,%edi
        movl    START_EDX,%edx

_render_fgp_column:
        movl    $0,%ebx
        movl    $0,%eax

        movb    (%esi,%edx),%eax
        andb    $0x0F,%eax
        shll    $14,%eax

        movb    1(%esi,%edx),%ebx
        shlw    $6,%ebx
        addl    %eax,%ebx
        addl    _tiles_base,%ebx
        testb   $0x10,(%esi, %edx)
        jz      _fgp_saut5
        movl    _base_brq_page,%ecx
        movzbl  (%ecx),%eax
        cmpb    $0x10,%al
        jl      _fgp_sd_special
        shrb    $4,%al
        jmp     _fgp_sd_special2
_fgp_sd_special:
        andb    $0x0F,%al
_fgp_sd_special2:
        shll    $18,%eax
        addl    %eax,%ebx
_fgp_saut5:

        movb    (%esi,%edx),%ah
        testb   $32,%ah
        jz      _fgp_fin_brique
        movb    1(%esi,%edx),%al
        cmpb    $4,_game
        je      _fgp_mode_couleur2
        andl    $0x00001FC0,%eax
        shrl    $2,%eax
        jmp     _fgp_saut6
_fgp_mode_couleur2:        
        andl    $0x00001F00,%eax
        shrl    $1,%eax
_fgp_saut6:
        addl    _base_palette_shinobi,%eax
        movl    %eax,BASE_COULEUR_BRIQUE
        movl    %eax,TILE_BANK

        pushl   %edx
        pushl   %edi

        movl    TILE_BANK,%eax
        cmpl    %eax,LAST_BANK
        je      _no_color_init_fgp

        movl    %eax,LAST_BANK
        movl    $14,%eax
_init_color_fgp:
        addl    BASE_COULEUR_BRIQUE,%eax
        movw    (%eax),%ecx
        subl    BASE_COULEUR_BRIQUE,%eax
        andl    $0xFF0F,%ecx
        movb    _Palette256(%ecx),%dl
        testb    %dl,%dl
        jne     _init_color_ok_fgp
        incb    _pal_counter
        jnz     _init_color_rech_fgp
        movb    $1,_pal_counter
        movb    $1,_reset_palette
_init_color_rech_fgp:
        movb    _pal_counter,%dl
        movb    %dl,_Palette256(%ecx)
        pushl   %ebx
        movzbl  _number_of_new_colors,%ebx
        incb    _number_of_new_colors
        shlw    $2,%ebx
        addl    _base_new_colors_tab,%ebx
        movb    %dl,(%ebx)
        movb    %ch,1(%ebx)
        movb    %cl,2(%ebx)
        popl    %ebx

_init_color_ok_fgp:
        movb    %dl,_FastPalette(%eax)
        decb    %eax
        decb    %eax
        jnz     _init_color_fgp

_no_color_init_fgp:
        movb    $8,%al
_fgp_brique_line:
        movb    $8,%ah
_fgp_brique_column:
        cmpb    $0,(%edi)
        jne     _fgp_transparence2
        movl    $0,%edx
        movb    (%ebx),%edx
        testb   %edx,%edx
        je      _fgp_transparence2
        movb    _FastPalette(%edx),%dl        
        movb    %dl,(%edi)
_fgp_transparence2:
        incl    %ebx
        incl    %edi
        decb    %ah
        jnz     _fgp_brique_column
        addl    $504,%edi
        decb    %al
        jnz     _fgp_brique_line

        popl    %edi
        popl    %edx
_fgp_fin_brique:
        addb    $2,%dl
        testb   $128,%dl
        jz      _pas_changement_page_p
        xorb    %dl,%dl
        movl    PAGE_2,%esi
_pas_changement_page_p:
        addl    $8,%edi
        decb    CPT_COLUMN
        jnz     _render_fgp_column
        addl    $0x80,PAGE_S
        addl    $0x80,PAGE_1
        addl    $0x80,PAGE_2
        addl    $0x1000,DISPLAY_BASE_SAVE
        addw    $0x80,PAGE_LIMIT
        movw    PAGE_LIMIT,%dx
        andw    $0xFFF,%dx
        jnz     _ok_fgp
        movl    PAGE_1L,%eax
        movl    %eax,PAGE_1
        movl    PAGE_2L,%eax
        movl    %eax,PAGE_2
        movl    $0,PAGE_LIMIT
        cmpb    $1,PAGE_SELECT
        je      _fgp_switch1
        movl    %eax,PAGE_S
        jmp     _ok_fgp
_fgp_switch1:
        movl    PAGE_1L,%eax
        movl    %eax,PAGE_1
_ok_fgp:
        decb    CPT_LINE
        jnz     _render_fgp_line
        ret

_asm_render_foreground_nopriority:
        movl    $0,%ebx
        movl    _base_scr_ver_fg,%esi
        movb    (%esi),%al
        movb    %al,%cl
        andl    $0x7,%ecx
        shlw    $9,%ecx
        andl    $0xF8,%eax
        shlw    $4,%ax
        movw    %ax,PAGE_LIMIT
        addl    _foreground_base,%eax
        movl    %eax,PAGE_1
        movl    %eax,PAGE_2

        movl    _base_scr_pag_fg,%esi
        movb    (%esi),%ah
        movb    %ah,%dh
        andl    $0xF000,%eax
        addl    %eax,PAGE_1
        shlb    $4,%dh
        andl    $0xF000,%edx
        addl    %edx,PAGE_2

        movl    _foreground_base,%eax
        movl    %eax,PAGE_1L
        movl    %eax,PAGE_2L
        movb    -1(%esi),%ah
        movb    %ah,%dh
        andl    $0xF000,%eax
        addl    %eax,PAGE_1L
        shlb    $4,%dh
        andl    $0xF000,%edx
        addl    %edx,PAGE_2L

        movl    _base_scr_hor_fg,%esi
        movb    (%esi),%ah
        movb    1(%esi),%al
        andw    $0x01FF,%ax
        movw    %eax,%edx
        andw    $0x0007,%eax

        movl    _display_base,%ebx
        subl    %ecx,%ebx
        addl    %eax,%ebx
        addl    $8,%ebx
        movl    %ebx,DISPLAY_BASE_SAVE

        andl    $0xFFF8,%edx
        shrw    $2,%edx
        cmpb    $0x30,%dl
        jg      _saut1_fg
        movl    PAGE_2,%eax
        movl    %eax,PAGE_S
        movl    $0x30,START_EDX
        jmp     _saut2_fg
_saut1_fg:
        movl    PAGE_1,%eax
        movl    %eax,PAGE_S
        movl    $0xB0,START_EDX
_saut2_fg:
        subl    %edx,START_EDX

        movl    $0,LAST_BANK

        movb    $29,CPT_LINE

_render_fg_line:
        movb    $42,CPT_COLUMN
        movl    PAGE_S,%esi
        movl    DISPLAY_BASE_SAVE,%edi
        movl    START_EDX,%edx

_render_fg_column:
        movl    $0,%ebx
        movl    $0,%eax

        movb    (%esi,%edx),%eax
        andb    $0x0F,%eax
        shll    $14,%eax

        movb    1(%esi,%edx),%ebx
        shlw    $6,%ebx
        addl    %eax,%ebx
        addl    _tiles_base,%ebx
        testb   $0x10,(%esi, %edx)
        jz      _fg_saut5
        movl    _base_brq_page,%ecx
        movzbl  (%ecx),%eax
        cmpb    $0x10,%al
        jl      _fg_sd_special
        shrb    $4,%al
        jmp     _fg_sd_special2
_fg_sd_special:
        andb    $0x0F,%al
_fg_sd_special2:
        shll    $18,%eax
        addl    %eax,%ebx
_fg_saut5:
/* ici */
        movb    (%esi,%edx),%ah
        testb   $32,%ah
        jnz     _fg_fin_brique
        movb    1(%esi,%edx),%al
        cmpb    $4,_game
        je      _fg_mode_couleur2
        andl    $0x00001FC0,%eax
        shrl    $2,%eax
        jmp     _fg_saut6
_fg_mode_couleur2:        
        andl    $0x00003F00,%eax
        shrl    $1,%eax
_fg_saut6:
        addl    _base_palette_shinobi,%eax
        movl    %eax,BASE_COULEUR_BRIQUE
        movl    %eax,TILE_BANK

        pushl   %edx
        pushl   %edi

        movl    TILE_BANK,%eax
        cmpl    %eax,LAST_BANK
        je      _no_color_init_fg

        movl    %eax,LAST_BANK
        movl    $14,%eax
_init_color_fg:
        addl    BASE_COULEUR_BRIQUE,%eax
        movw    (%eax),%ecx
        subl    BASE_COULEUR_BRIQUE,%eax
        andl    $0xFF0F,%ecx
        movb    _Palette256(%ecx),%dl
        testb    %dl,%dl
        jne     _init_color_ok_fg
        incb    _pal_counter
        jnz     _init_color_rech_fg
        movb    $1,_pal_counter
        movb    $1,_reset_palette
_init_color_rech_fg:
        movb    _pal_counter,%dl
        movb    %dl,_Palette256(%ecx)
        pushl   %ebx
        movzbl  _number_of_new_colors,%ebx
        incb    _number_of_new_colors
        shlw    $2,%ebx
        addl    _base_new_colors_tab,%ebx
        movb    %dl,(%ebx)
        movb    %ch,1(%ebx)
        movb    %cl,2(%ebx)
        popl    %ebx

_init_color_ok_fg:
        movb    %dl,_FastPalette(%eax)
        decb    %eax
        decb    %eax
        jnz     _init_color_fg

_no_color_init_fg:
        movb    $8,%al
_fg_brique_line:
        movb    $8,%ah
_fg_brique_column:
        cmpb    $0,(%edi)
        jne     _fg_transparence2
        movl    $0,%edx
        movb    (%ebx),%edx
        testb   %edx,%edx
        je      _fg_transparence2
        movb    _FastPalette(%edx),%dl        
        movb    %dl,(%edi)
_fg_transparence2:
        incl    %ebx
        incl    %edi
        decb    %ah
        jnz     _fg_brique_column
        addl    $504,%edi
        decb    %al
        jnz     _fg_brique_line

        popl    %edi
        popl    %edx
_fg_fin_brique:
        addb    $2,%dl
        testb   $128,%dl
        jz      _pas_changement_page
        xorb    %dl,%dl
        movl    PAGE_2,%esi
_pas_changement_page:
        addl    $8,%edi
        decb    CPT_COLUMN
        jnz     _render_fg_column
        addl    $0x80,PAGE_S
        addl    $0x80,PAGE_1
        addl    $0x80,PAGE_2
        addl    $0x1000,DISPLAY_BASE_SAVE
        addw    $0x80,PAGE_LIMIT
        movw    PAGE_LIMIT,%dx
        andw    $0xFFF,%dx
        jnz     _ok_fg
        movl    PAGE_1L,%eax
        movl    %eax,PAGE_1
        movl    PAGE_2L,%eax
        movl    %eax,PAGE_2
        movl    $0,PAGE_LIMIT
        cmpb    $1,PAGE_SELECT
        je      _fg_switch1
        movl    %eax,PAGE_S
        jmp     _ok_fg
_fg_switch1:
        movl    PAGE_1L,%eax
        movl    %eax,PAGE_1
_ok_fg:
        decb    CPT_LINE
        jnz     _render_fg_line
        ret

_asm_render_background:
        movl    $0,%ebx
        movl    _base_scr_ver_bg,%esi
        movb    (%esi),%al
        movb    %al,%cl
        andl    $0x7,%ecx
        shlw    $9,%ecx
        andl    $0xF8,%eax
        shlw    $4,%ax
        movw    %ax,PAGE_LIMIT
        addl    _foreground_base,%eax
        movl    %eax,PAGE_1
        movl    %eax,PAGE_2

        movl    _base_scr_pag_bg,%esi
        movb    (%esi),%ah
        movb    %ah,%dh
        andl    $0xF000,%eax
        addl    %eax,PAGE_1
        shlb    $4,%dh
        andl    $0xF000,%edx
        addl    %edx,PAGE_2

        movl    _foreground_base,%eax
        movl    %eax,PAGE_1L
        movl    %eax,PAGE_2L
        movb    -1(%esi),%ah
        movb    %ah,%dh
        andl    $0xF000,%eax
        addl    %eax,PAGE_1L
        shlb    $4,%dh
        andl    $0xF000,%edx
        addl    %edx,PAGE_2L

        movl    _base_scr_hor_bg,%esi
        movb    (%esi),%ah
        movb    1(%esi),%al
        andw    $0x0FFF,%ax
        movw    %eax,%edx
        andw    $0x0007,%eax

        movl    _display_base,%ebx
        subl    %ecx,%ebx
        addl    %eax,%ebx
        addl    $8,%ebx
        movl    %ebx,DISPLAY_BASE_SAVE

        andl    $0xFFF8,%edx
        shrw    $2,%edx
        cmpb    $0x30,%dl
        jg      _saut1_bg
        movl    PAGE_2,%eax
        movl    %eax,PAGE_S
        movl    $0x30,START_EDX
        movb    $2,PAGE_SELECT
        jmp     _saut2_bg
_saut1_bg:
        movl    PAGE_1,%eax
        movl    %eax,PAGE_S
        movl    $0xB0,START_EDX
        movb    $1,PAGE_SELECT
_saut2_bg:
        subl    %edx,START_EDX

        movl    $0,LAST_BANK

        movb    $29,CPT_LINE

_render_bg_line:
        movb    $42,CPT_COLUMN
        movl    PAGE_S,%esi
        movl    DISPLAY_BASE_SAVE,%edi
        movl    START_EDX,%edx

_render_bg_column:
        movl    $0,%ebx
        movl    $0,%eax

        movb    (%esi,%edx),%al
        andb    $0x0F,%al
        shll    $14,%eax

        movb    1(%esi,%edx),%ebx
        shlw    $6,%ebx
        addl    %eax,%ebx
        addl    _tiles_base,%ebx
        testb   $0x10,(%esi, %edx)
        jz      _bg_saut5
        movl    _base_brq_page,%ecx
        movzbl  (%ecx),%eax
        cmpb    $0x10,%al
        jl      _bg_sd_special
        shrb    $4,%al
        jmp     _bg_sd_special2
_bg_sd_special:
        andb    $0x0F,%al
_bg_sd_special2:
        shll    $18,%eax
        addl    %eax,%ebx
_bg_saut5:
        movb    (%esi,%edx),%ah
        movb    1(%esi,%edx),%al
        cmpb    $4,_game
        je      _bg_mode_couleur2
        andl    $0x00001FC0,%eax
        shrl    $2,%eax
        jmp     _bg_saut6
_bg_mode_couleur2:        
        andl    $0x00001F00,%eax
        shrl    $1,%eax
_bg_saut6:
        addl    _base_palette_shinobi,%eax
        movl    %eax,BASE_COULEUR_BRIQUE
        movl    %eax,TILE_BANK

        pushl   %edx
        pushl   %edi

        movl    TILE_BANK,%eax
        cmpl    %eax,LAST_BANK
        je      _no_color_init_bg

        movl    %eax,LAST_BANK
        movl    $16,%eax
_init_color_bg:
        subl    $2,%eax
        addl    BASE_COULEUR_BRIQUE,%eax
        movw    (%eax),%ecx
        subl    BASE_COULEUR_BRIQUE,%eax
        andl    $0xFF0F,%ecx
        movb    _Palette256(%ecx),%dl
        testb    %dl,%dl
        jne     _init_color_ok_bg
        incb    _pal_counter
        jnz     _init_color_rech_bg
        movb    $1,_pal_counter
        movb    $1,_reset_palette
_init_color_rech_bg:
        movb    _pal_counter,%dl
        movb    %dl,_Palette256(%ecx)
        pushl   %ebx
        movzbl  _number_of_new_colors,%ebx
        incb    _number_of_new_colors
        shlw    $2,%ebx
        addl    _base_new_colors_tab,%ebx
        movb    %dl,(%ebx)
        movb    %ch,1(%ebx)
        movb    %cl,2(%ebx)
        popl    %ebx

_init_color_ok_bg:
        movb    %dl,_FastPalette(%eax)
        cmpl    $0,%eax
        jne     _init_color_bg

_no_color_init_bg:
        movb    $8,%al
_bg_brique_line:
        movb    $8,%ah
_bg_brique_column:
        cmpb    $0,(%edi)
        jne     _bg_transparence2
        movl    $0,%edx
        movb    (%ebx),%edx
        movb    _FastPalette(%edx),%dl        
        movb    %dl,(%edi)
_bg_transparence2:
        incl    %ebx
        incl    %edi
        decb    %ah
        jnz     _bg_brique_column
        addl    $504,%edi
        decb    %al
        jnz     _bg_brique_line

        popl    %edi
        popl    %edx
_bg_fin_brique:
        addb    $2,%dl
        testb   $128,%dl
        jz      _pas_changement_page_bg
        xorb    %dl,%dl
        movl    PAGE_2,%esi
_pas_changement_page_bg:
        addl    $8,%edi
        decb    CPT_COLUMN
        jnz     _render_bg_column
        addl    $0x80,PAGE_S
        addl    $0x80,PAGE_1
        addl    $0x80,PAGE_2
        addl    $0x1000,DISPLAY_BASE_SAVE
        addw    $0x80,PAGE_LIMIT
        movw    PAGE_LIMIT,%dx
        andw    $0xFFF,%dx
        jnz     _ok
        movl    PAGE_1L,%eax
        movl    %eax,PAGE_1
        movl    PAGE_2L,%eax
        movl    %eax,PAGE_2
        movl    $0,PAGE_LIMIT
        cmpb    $1,PAGE_SELECT
        je      _bg_switch1
        movl    %eax,PAGE_S
        jmp     _ok
_bg_switch1:
        movl    PAGE_1L,%eax
        movl    %eax,PAGE_1
_ok:
        decb    CPT_LINE
        jnz     _render_bg_line
        ret

/* gestion des sprites */

.globl _asm_render_sprites
_asm_render_sprites:
        movl    _vscreen_base,%ebx
        movl    _base_spr_regist,%esi
//        movl    _bank_44_base,%esi
        movl    $0,LAST_BANK
        movl    $0,%edx

        cmpb    $0x06,_game
        je      _sprites_shadow_dancer
        cmpw    $0xFFFF,(%esi)
        je      _fin_des_sprites
        cmpw    $0xFFFF,4(%esi)
        je      _fin_des_sprites        
_recherche_debut:
        cmpw    $0xFFFF,16(%esi,%edx)
        je      _sprite_loop
        cmpw    $0xFFFF,20(%esi,%edx)
        je      _sprite_loop
        addw    $0x10,%edx
        cmpw    $0x400,%edx
        jl      _recherche_debut
        jmp     _sprite_loop

_sprites_shadow_dancer:
        testb   $0x80,4(%esi)
        jnz     _fin_des_sprites
_recherche_debut2:
        testb   $0x80,4(%esi,%edx)
        jnz     _sprite_loop
        addw    $0x10,%edx
        cmpw    $0x400,%edx
        jl      _recherche_debut2

_sprite_loop:
        movl    _vscreen_base,%ebx
        cmpb    $0x00,(%esi,%edx)
        je      _sprite_non_actif
        cmpb    $0x00,5(%esi,%edx)
        je      _sprite_non_actif
/* controle bits de priorit */
        movb    9(%esi,%edx),%cl
        andb    $0xC0,%cl
        movb    %cl,FORCE_SPRITE
        andb    $0x80,%cl
        cmpb    %cl,SPR_MODE
        jne     _sprite_non_actif

        movl    $0,%ecx
        movb    1(%esi,%edx),%ecx
        addl    $88,%ecx
        shll    $9,%ecx
        addl    %ecx,%ebx

        movl    $0,%ecx
        movb    2(%esi,%edx), %ecx
        shlw    $8,%ecx
        movb    3(%esi,%edx), %ecx
        cmpl    $520,%ecx
        jg      _sprite_non_actif
        subl    $88,%ecx
        addl    %ecx,%ebx
        movl    %ebx,SCR_BASE

        movl    $0,%ebx
        movl    $0,%ecx
        movb    5(%esi,%edx),%ebx
        testb   $128,%ebx
        jz      _pas_flip_vertical
        subb    %ebx,%ecx
        addw    %ecx,%ecx
        movw    %ecx,SPR_WIDTH
        movl    $0xFFFFFF00,%ecx
        movb    5(%esi,%edx),%ecx
        movb    $1,SPR_FLIP_FLAG
        jmp     _fin_flip
_pas_flip_vertical:
        movb    %ebx,%ecx
        addw    %ebx,%ebx
        movw    %ebx,SPR_WIDTH
        movb    $0,SPR_FLIP_FLAG
_fin_flip:
        movl    $0,%ebx
        movb    6(%esi,%edx),%bh
        movb    7(%esi,%edx),%bl
        addw    %ecx,%ebx
        addl    %ebx,%ebx

        movb    8(%esi,%edx),%ecx
        andl    $0xF,%ecx
        movzbl  _spr_tab(%ecx),%eax
        shll    $16,%eax
        addl    %eax,%ebx
        
_spr_adrs_ok:
        movl    _sprites_base_data,%ecx
        addl    %ebx,%ecx
        movl    %ecx,SPR_BASE

        movb    0(%esi,%edx),%ebx
        subb    1(%esi,%edx),%ebx
        movb    %ebx,SPR_HEIGHT
        movb    4(%esi,%edx),%bl
        movb    %bl,SPR_REVERSE_FLAG
/* calcul base palette du sprite */
        movl    $0,%ebx

        movb    9(%esi,%edx),%ebx
        andb    $0x3F,%ebx
        shlw    $5,%ebx
        addl    $0x800,%ebx
        addl    _base_palette_shinobi,%ebx
        movl    %ebx,SPR_COLOR
        pushl   %edx
        movl    SPR_COLOR,%eax
        cmpl    %eax,LAST_BANK
        je      _no_color_init_spr

        movl    %eax,LAST_BANK
        movl    $15,%eax
_init_color_spr:
        movl    %eax,%ebx
        addl    %ebx,%ebx
        addl    SPR_COLOR,%ebx
        movw    (%ebx),%ecx
        andl    $0xFF0F,%ecx
        movb    _Palette256(%ecx),%dl
        testb    %dl,%dl
        jne     _init_color_ok_spr
        incb    _pal_counter
        jnz     _init_color_rech_spr
        movb    $1,_pal_counter
        movb    $1,_reset_palette
_init_color_rech_spr:
        movb    _pal_counter,%dl
        movb    %dl,_Palette256(%ecx)
        movzbl  _number_of_new_colors,%ebx
        incb    _number_of_new_colors
        shlw    $2,%ebx
        addl    _base_new_colors_tab,%ebx
        movb    %dl,(%ebx)
        movb    %ch,1(%ebx)
        movb    %cl,2(%ebx)

_init_color_ok_spr:
        movb    %dl,_FastPalette(%eax)
        decb    %eax
        jnz     _init_color_spr

_no_color_init_spr:
        movl    SPR_BASE,%eax
        testb   $1,SPR_FLIP_FLAG
        jnz     _sprite_flip_selection
        testb   $1,SPR_REVERSE_FLAG
        jnz     _sprite_renverse
        jmp     _sprite_normal
_sprite_flip_selection:
        testb   $1,SPR_REVERSE_FLAG
        jz      _sprite_flip_renverse
        jmp     _sprite_flip_normal

_sprite_normal:
        movb    SPR_WIDTH,%edx
        movb    %edx,SPR_WIDTHD
        movl    SCR_BASE,%edx
        cmpl    %edx,_display_bottom
        jl      _fin_du_sprite
_loop_column_spr:

        cmpb    $0xC0,FORCE_SPRITE
        je      _spr_force1     
        cmpb    $0,(%edx)
        jne     _spr_trans1
_spr_force1:
        movb    (%eax),%ecx
        andl    $0xF0,%ecx
        jz      _spr_trans1
        shrb    $4,%ecx
        cmpb    $0xF,%ecx
        je      _spr_trans1
        movb    _FastPalette(%ecx),%cl
        movb    %cl,(%edx)
_spr_trans1:
        incl    %edx
        cmpb    $0xC0,FORCE_SPRITE
        je      _spr_force2
        cmpb    $0,(%edx)
        jne     _spr_trans2
_spr_force2:
        movb    (%eax),%ecx
        andl    $0xF,%ecx
        jz      _spr_trans2
        cmpb    $0xF,%ecx
        je      _spr_trans2
        movb    _FastPalette(%ecx),%cl
        movb    %cl,(%edx)

_spr_trans2:
        incl    %eax
        incl    %edx

        decb    SPR_WIDTHD
        jnz     _loop_column_spr

        addl    $512,SCR_BASE
        decb    SPR_HEIGHT
        jnz     _sprite_normal
        jmp     _fin_du_sprite

_sprite_renverse:
        movl    $0,%edx
        movb    SPR_WIDTH,%edx
        subl    %edx,%eax
        addl    $2,%eax
        addw    %edx,%edx
        addl    %edx,SCR_BASE
_sprite_renverse_loop:
        movb    SPR_WIDTH,%edx
        movb    %edx,SPR_WIDTHD
        movl    SCR_BASE,%edx
        cmpl    %edx,_display_bottom
        jl      _fin_du_sprite
_loop_column_spr_r:

        cmpb    $0xC0,FORCE_SPRITE
        je      _spr_force1_r
        cmpb    $0,(%edx)
        jne     _spr_trans1_r
_spr_force1_r:
        movb    (%eax),%ecx
        andl    $0xF0,%ecx
        jz      _spr_trans1_r
        shrb    $4,%ecx
        cmpb    $0xF,%ecx
        je      _spr_trans1_r
        movb    _FastPalette(%ecx),%cl
        movb    %cl,(%edx)

_spr_trans1_r:
        decl    %edx
        cmpb    $0xC0,FORCE_SPRITE
        je      _spr_force2_r
        cmpb    $0,(%edx)
        jne     _spr_trans2_r
_spr_force2_r:
        movb    (%eax),%ecx
        andl    $0xF,%ecx
        jz      _spr_trans2_r
        cmpb    $0xF,%ecx
        je      _spr_trans2_r
        movb    _FastPalette(%ecx),%cl
        movb    %cl,(%edx)

_spr_trans2_r:
        incl    %eax
        decl    %edx

        decb    SPR_WIDTHD
        jnz     _loop_column_spr_r

        addl    $512,SCR_BASE
        decb    SPR_HEIGHT
        jnz     _sprite_renverse_loop
        jmp     _fin_du_sprite

_sprite_flip_normal:
        incl    %eax
        incl    SCR_BASE
_sprite_flip_normal_loop:
        movb    SPR_WIDTH,%edx
        movb    %edx,SPR_WIDTHD
        movl    SCR_BASE,%edx
        cmpl    %edx,_display_bottom
        jl      _fin_du_sprite
_loop_column_spr_flip:

        cmpb    $0xC0,FORCE_SPRITE
        je      _spr_force1_flip
        cmpb    $0,(%edx)
        jne     _spr_trans1_flip
_spr_force1_flip:
        movb    (%eax),%ecx
        andl    $0xF,%ecx
        jz      _spr_trans1_flip
        cmpb    $0xF,%ecx
        je      _spr_trans1_flip
        movb    _FastPalette(%ecx),%cl
        movb    %cl,(%edx)
_spr_trans1_flip:
        incl    %edx
        cmpb    $0xC0,FORCE_SPRITE
        je      _spr_force2_flip
        cmpb    $0,(%edx)
        jne     _spr_trans2_flip
_spr_force2_flip:
        movb    (%eax),%ecx
        andl    $0xF0,%ecx
        jz      _spr_trans2_flip
        shrb    $4,%ecx
        cmpb    $0xF,%ecx
        je      _spr_trans2_flip
        movb    _FastPalette(%ecx),%cl
        movb    %cl,(%edx)

_spr_trans2_flip:
        decl    %eax
        incl    %edx

        decb    SPR_WIDTHD
        jnz     _loop_column_spr_flip

        addl    $512,SCR_BASE
        decb    SPR_HEIGHT
        jnz     _sprite_flip_normal_loop
        jmp     _fin_du_sprite

_sprite_flip_renverse:
        movl    $0,%edx
        movb    SPR_WIDTH,%edx
        addl    %edx,%eax
        decl    %eax
        decl    SCR_BASE
        addw    %edx,%edx
        addl    %edx,SCR_BASE
_sprite_renverse_loop_flip:
        movb    SPR_WIDTH,%edx
        movb    %edx,SPR_WIDTHD
        movl    SCR_BASE,%edx
        cmpl    %edx,_display_bottom
        jl      _fin_du_sprite
_loop_column_spr_r_flip:

        cmpb    $0xC0,FORCE_SPRITE
        je      _spr_force1_r_flip
        cmpb    $0,(%edx)
        jne     _spr_trans1_r_flip
_spr_force1_r_flip:
        movb    (%eax),%ecx
        andl    $0xF,%ecx
        jz      _spr_trans1_r_flip
        cmpb    $0xF,%ecx
        je      _spr_trans1_r_flip
        movb    _FastPalette(%ecx),%cl
        movb    %cl,(%edx)

_spr_trans1_r_flip:
        decl    %edx
        cmpb    $0xC0,FORCE_SPRITE
        je      _spr_force2_r_flip
        cmpb    $0,(%edx)
        jne     _spr_trans2_r_flip
_spr_force2_r_flip:
        movb    (%eax),%ecx
        andl    $0xF0,%ecx
        jz      _spr_trans2_r_flip
        shrb    $4,%ecx
        cmpb    $0xF,%ecx
        je      _spr_trans2_r_flip
        movb    _FastPalette(%ecx),%cl
        movb    %cl,(%edx)

_spr_trans2_r_flip:
        decl    %eax
        decl    %edx

        decb    SPR_WIDTHD
        jnz     _loop_column_spr_r_flip

        addl    $512,SCR_BASE
        decb    SPR_HEIGHT
        jnz     _sprite_renverse_loop_flip
        jmp     _fin_du_sprite

_fin_du_sprite:
        popl    %edx

_sprite_non_actif:
        cmpl    $0x0,%edx
        je      _fin_des_sprites
        subl    $16,%edx
        jmp     _sprite_loop

_fin_des_sprites:
        ret

.end