/*
 * SYSTEM 16 ARCADE EMULATOR SOURCE CODE
 * 
 * Copyright 1996/97 Thierry Lescot
 */

#include "cpudefs.h"
#include <allegro.h>
#include "shinobi.h"

#ifdef SEARCH

extern int strace;
extern unsigned char *TilesROM1, vid_bank, txt_bank;
extern ULONG base_brq_page;
extern char ws[80];

void affiche_brique_simple(int bx, int by, int banque, int brique) {
   int x, y;
   rectfill(screen, bx, by, bx+7, by+7, brique);
}

int base_color=0;
UBYTE *brq_page;

void affiche_brique_pixels(int bx, int by, int banque, int brique, int f) {
   int x, y, p=*brq_page;
   long a=(((long)banque)*16384)+(((long)brique)*64);
//   if (f) a+=((ULONG)RAM[0xFF][0xF095])<<18;
   
   if (f) {
      if (p>15) p=(p>>4);
      a+=((ULONG)p)<<18;
   }
   for (y=0;y!=8;y++) {
      for (x=0;x!=8;x++) {
	 _putpixel(screen, bx+x, by+y, base_color+TilesROM1[a++]);
      }
   }
}

void dump_video(int p) {
   int x, y, touche, op=p;
   RGB pal;
   if (!strace) TraceOn();
   set_gfx_mode(GFX_VESA2L, 1024, 768, 0, 0);
   pal.r=pal.g=pal.b=63;
   for (x=1;x!=256;x++) set_color(x, (RGB *)&pal);
   for (x=0;x!=8;x++) {
      pal.r=pal.g=9*x; pal.b=0;
      set_color(x*2, (RGB *)&pal);
      pal.r=0;
      set_color(32+(x*2), (RGB *)&pal);
   }
   brq_page=base_brq_page;
   
   for (y=0;y!=0x20;y++) {
      for (x=0;x!=0x40;x++) {
	 base_color=((RAM[vid_bank][p]&0x20)==0x20)? 32:0;
         affiche_brique_pixels(x*8, y*8, 
			       RAM[vid_bank][p]&0xF, RAM[vid_bank][p+1],
			       RAM[vid_bank][p]&0x10);
	 p+=2;
      }
   }
   for (y=0;y!=0x20;y++) {
      for (x=0;x!=0x40;x++) {
	 base_color=((RAM[vid_bank][p]&0x20)==0x20)? 32:0;
         affiche_brique_pixels(512+x*8, y*8,
			       RAM[vid_bank][p]&0xF, RAM[vid_bank][p+1],
			       RAM[vid_bank][p]&0x10);
	 p+=2;
      }
   }
   for (y=0;y!=0x20;y++) {
      for (x=0;x!=0x40;x++) {
	 base_color=((RAM[vid_bank][p]&0x20)==0x20)? 32:0;
         affiche_brique_pixels(x*8, 300+y*8, 
			       RAM[vid_bank][p]&0xF, RAM[vid_bank][p+1],
			       RAM[vid_bank][p]&0x10);
	 p+=2;
      }
   }
   for (y=0;y!=0x20;y++) {
      for (x=0;x!=0x40;x++) {
	 base_color=((RAM[vid_bank][p]&0x20)==0x20)? 32:0;
         affiche_brique_pixels(512+x*8, 300+y*8, 
			       RAM[vid_bank][p]&0xF, RAM[vid_bank][p+1],
			       RAM[vid_bank][p]&0x10);
	 p+=2;
      }
   }
   rect(screen, 0, 0, 512, 257, 255);
   rect(screen, 0, 300, 512, 557, 255);
   rect(screen, 512, 0, 1024, 257, 255);
   rect(screen, 512, 300, 1024, 557, 255);
   p=op;
   for (y=0;y!=2;y++)
   for (x=0;x!=2;x++) {
      sprintf(ws, "PAGE %01x", (p>>12)&0xF);
      textout(screen, font, ws, 512*x, 260+(300*y), 255);
      p+=0x1000;
   }
   clear_keybuf();
   touche=(readkey()>>8);
   set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   /*
   if ((touche>=KEY_F1)&&(touche<=KEY_F8)) {
      if (touche>KEY_F4) op=op+(32*(touche-KEY_F5))+0x1000;
      else op+=32*(touche-KEY_F1);
      for (y=0;y!=20;y++) {
	 for (x=0;x!=0x10;x++) {
	    printf("%02x:", RAM[vid_bank][op+(2*x)]);
	 }
	 printf("\n");
	 op+=0x80;
      }
      while (!keypressed());
      clear_keybuf();
   }*/
   TraceOff();
}

void dump_text_video() {
   int x, y, p=0;
   RGB pal;
   if (!strace) TraceOn();
   set_gfx_mode(GFX_VESA2B, 800, 600, 0, 0);
   pal.r=pal.g=pal.b=63;
   set_color(255, (RGB *)&pal);
   rect(screen, 0, 0, 513, 513, 255);
   base_color=0;
   brq_page=base_brq_page;
   for (y=0;y!=0x40;y++) {
      for (x=0;x!=0x40;x++) {
         affiche_brique_pixels(1+x*8, 1+y*8, 
			       /*RAM[txt_bank][p]&1*/0, RAM[txt_bank][p+1], 0);
	 p+=2;
      }
   }
   clear_keybuf();
   while (!keypressed());
   clear_keybuf();
   set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   TraceOff();
}

unsigned long hex2int(char *s) {
   int i, v=0, m=1, p;
   p=strlen(s);
   do {
      p--;
      if ((s[p]>='A')&&(s[p]<='Z'))
      	v+=(m*(10+(s[p]-'A')));
      else if ((s[p]>='a')&&(s[p]<='z'))
      	v+=(m*(10+(s[p]-'a')));
      else
      	v+=(m*(s[p]-'0'));
      m*=16;
   } while (p);
   return(v);
}

#endif
