;
; Note: by default SNMAIN start-up module does not initialise an
; extra stack. By default your program will use the already existing
; system stack which is 4Kbytes big.
;
; If you need more stack you should set the _stackinit variable
; in your C source code.
;
; eg: put these 2 lines in your main C source file where you have your
; global data (usually near the beginning, before any functions) :-
;
; int mystack[4096];
; void *_stackinit=&mystack[4096];
;
; In this case the stack pointer is initialised to the top
; of a 16Kbyte area of your BSS.
; Alternatively you can just initialise _stackinit to point to a label
; in another section of your program and let the linker fix it up.
;
	opt	c+

	section	.text
	section	.ctors
	section	.dtors
	section	.data
	section	.bss

	xdef	__SN_ENTRY_POINT,__main,__do_global_dtors
	xref	main,_stackinit

	section	.text

__SN_ENTRY_POINT
	mov.l	=sectend(.bss)-sect(.bss),r0	; clear bss
	mov.l	=sect(.bss),r1
	mov	#0,r2

	cmp/eq	#0,r0
	bt	@chstack

@1	mov.b	r2,@r1
	dt	r0
	bf/s	@1
	add.l	#1,r1

@chstack	mov.l	=_stackinit,r1
	mov.l	@r1,r0
	cmp/eq	#0,r0
	bt	@skstack

	mov.l	r0,sp

@skstack	bsr	__main	; initialise constructors
	nop

@2	mov.l	=main,r0
	jsr	@r0
	nop

@3	trapa	#$22	; return to downloader

	bra	@3
	nop

__main	mov.l	=__initialised,r1
	mov.l	@r1,r0
	cmp/eq	#0,r0
	bf	@exit

	mov.l	#1,r0
	mov.l	r0,@r1

	mov.l	=(sectend(.ctors)-sect(.ctors))/4,r0
	mov.l	=sect(.ctors),r1

	cmp/eq	#0,r0
	bt	@exit

	mov.l	pr,@-r15

@loop	mov.l	@r1+,r2

	mov.l	r0,@-r15
	mov.l	r1,@-r15

	jsr	@r2
	nop

	mov.l	@r15+,r1
	mov.l	@r15+,r0

	dt	r0
	bf	@loop

	mov.l	@r15+,pr

@exit	rts
	nop
	
__do_global_dtors

	mov.l	=__initialised,r1
	mov.l	@r1,r0
	cmp/eq	#0,r0
	bt	@exit

	mov.l	=(sectend(.dtors)-sect(.dtors))/4,r0
	mov.l	=sect(.dtors),r1

	cmp/eq	#0,r0
	bt	@exit

	mov.l	pr,@-r15

@loop	mov.l	@r1+,r2

	mov.l	r0,@-r15
	mov.l	r1,@-r15

	jsr	@r2
	nop

	mov.l	@r15+,r1
	mov.l	@r15+,r0

	dt	r0
	bf	@loop

	mov.l	@r15+,pr

@exit	rts
	nop

	littab

	section	.data

__initialised	dc.l	0

	end

