#include <stdio.h>
#include <process.h>
#include <string.h>

#define eofchr 0x1A

unsigned char buffer[1024];
unsigned char line[512];

unsigned char Drive[3] ;
unsigned char Dir[128] ;
unsigned char LastDir[128];
unsigned char fname[9] ;
unsigned char Ext[5] ;

unsigned char outname[127] ;
unsigned char tempname[127] ;
unsigned char currentfile[127] ;

int chrptr=-1;
int lineptr;

int disp=1;

FILE *in,*out,*temp;
int a,n,rp=1;
int asmcnt=0;
unsigned long linecnt,addr;

int main (int argc,char *argv[])
{
	char a1,a2,a3,a4;

/*	printf("Sega DSPASM sld extractor Copyright (c) 1995 A.R.Hartley\n\n");
*/

	if (argc == 1)
		{
		printf("Usage : dspsld source.lst\n\n");
		exit(1);
		}

	in = fopen(argv[1], "r");

	if (in == NULL) {
		printf("Error : can't open input file '%s'\n",argv[1]);
		exit(1);
	}

	fnsplit( argv[1], Drive,Dir,fname,Ext ) ;

	linecnt=1;
	addr=0;

	printf(">%s.dsp\n",fname);

	while (1)
	{
		read_line();

		if	(cmpline("0")==0)
		{
		printf("$%08lx * %lx\n", addr, linecnt);
		addr+=4;
		}		

		linecnt++;
		if (feof(in)==1) break;
	}
	fclose(in);
}

do_exit(int retcode)
{
	fclose(in);
	exit(retcode);
}

/****************************************
			   skip to next part
*****************************************/

skip_exp()
{
skiploop:

		a=getchr();

		if (a==eofchr)
		{
			/* printf("/* EOF reached in skipexp() */"); */
			do_exit(1);
		}
	
		if ((a==32) || (a==9) || (a==13) || (a==10))
		{
		nextchr();
		goto skiploop;
		}

		return (getchr());
}

/****************************************
			   skip to next line
*****************************************/

next_line()
{
		while(1)
		{
			a=getchr();

			if (a==eofchr)
			{
			/* printf("/* EOF reached in next_line */"); */
			do_exit(1);
			}
	
			if ((a==13) || (a==10))
			{
			nextchr();
			break;
			}
		}

		return (0);
}

/****************************************
	 read a whole line into line buffer
*****************************************/

read_line()
{
	setmem(line,sizeof(line),0);

	lineptr = 0;

	while(1)
	{
		a = getchr();

		if (a == eofchr)
			{
			/* printf("/* EOF reached in getline() */"); */
			do_exit(1);
			}

		if ((a == 10) || (a == 13))
				{
				nextchr();
				nextchr();
				break;
				}

		line[lineptr++] = a;
		nextchr();
	}
	line[lineptr]=0;

	return 0;
}

/****************************************
				show a line
*****************************************/

showline()
{
	lineptr = 0;

	while(1)
	{
		a = line[lineptr];

		if (a == eofchr)
			do_exit(1);

		if (a == 0)
				break;

		if ((a == '/') && (line[lineptr+1]=='/'))
				break;

		outchar(a);

			lineptr++;
	}

	outchar(13);
	outchar(10);

	return 0;
}


/****************************************
			find start of line
*****************************************/

startline()
{
	int st = 0;

	while ((line[st]==32) || (line[st]==9))
	st++;

	return st;
}

/****************************************
			compare line data
*****************************************/

cmpline(char * a_string)
{
		int st=startline();

		int ll=strlen(a_string);
		return(strncmp(&line[st],a_string, ll));
}

/****************************************
			   test option
*****************************************/

option(char * argv_str,char * test_str)
{
		int ll=strlen(test_str);
		return(strncmp(argv_str,test_str, ll));
}

/****************************************
				print a enter
*****************************************/

enter()
{
	fprintf(temp,"\n");
	return(0);
}

/****************************************
				output a char
*****************************************/

outchar(char ch)
{
	fprintf(temp,"%c",ch);
	return(0);
}

/****************************************
			  skip first bracket
*****************************************/

skip_first_brack()
{
	if	(skip_exp() != '{')
				{
				printf("Error : Could'nt locate '{'");
				do_exit(1);
				}

	nextchr();			/* skip '{' */
	return(0);
}

/****************************************
		   get a char from in file
*****************************************/

getchr()
{

	if ((chrptr == -1) || (chrptr == 1024))
		{
		setmem(buffer,1024,eofchr);
	   fread(buffer,1,1024,in);
		chrptr=0;
		}

	return(buffer[chrptr]);
}

/****************************************
			move to next char in file
*****************************************/

nextchr()
{
	if ((chrptr == -1) || (chrptr == 1024))
		{
		setmem(buffer,1024,eofchr);
	   fread(buffer,1,1024,in);
		chrptr=0;
		}

	return(buffer[chrptr++]);
}


