;*- MATRIX.DSP --------------------------------------------------------------*

			ORG	0

One			=	$10000

Mat_Size	=	12
Vertex_Size	=	3
Point_Size	=	4
Maxtr		=	16

;*- Start of RAM0

Mat			=	$00
Source		=	$01
VNSource	=	$02
Dest		=	$03
Count		=	$04
Light		=	$05

W_Matrix 	=	$14			; Work matrix

;*- Start of RAM1

W_S_Point	=	$00			; Source vertex chunk

;*- Start of RAM2

W_D_Point	=	$00			; Dest vertex chunk

;*- Start of RAM3

W_Count		=	$20			; Number of vertices to process for one loop
W_VertexDMA	=	$21			; Amount to dma on this chunk
W_PointDMA	=	$22			; Amount to dma on this chunk
W_Tptr		=	$23			; Temporary pointer for the matrix multiply

;*------- ALU Control -- X-Bus Control -- Y-Bus Control -- D1-Bus Contr. ----*

Start
;		;*- DMA the matrix into DSP ram0
															mov	Mat,ct0
															mov	m0,ra0
															mov	W_Matrix,ct0
			dma2 d0,mc0,Mat_Size										;dma here			

Chunk_Loop
		;*- Work out the amount to process for this chunk

															mov	W_Count,ct3
															mov	Count,ct0
												mov	m0,a	mov	Maxtr,pl
	sub														mov	m0,mc3
															mov	W_Count,ct3
			mvi	Maxtr,mc3,NS

		;*- Work out the Dma amount, this involves multiplying the chunk
		;*- counter by 3 for vertex and normal size and by 4 for point size

															mov	W_Count,ct3
												mov	m3,a	mov	Source,ct0
	sl											mov	alu,a	mov	W_PointDMA,ct3
	sl														mov	all,mc3			; W_PointDMA
															mov	m0,ra0

															mov	W_Count,ct3
												mov	m3,a	mov	mc3,pl
	sl											mov	alu,a	mov	W_S_Point,ct1
	add														mov	all,mc3			; W_VertexDMA

		;*- DMA a chunk of vertices into ram1
															mov	W_VertexDMA,ct3
			dma2 d0,m1,m3

		;*- Work out the loop number, just sub 1 from the chunk counter

															mov	Vect_Loop,top
															mov	W_D_Point,ct2

															mov	W_Count,ct3
												mov	m3,a	mov	1,pl
	sub														mov	all,lop

															mov	W_Tptr,ct3
															mov	W_S_Point,mc3
															mov	W_Tptr,ct3
Vect_Loop
		;*- Now do the matrix tranformation
															mov	W_Matrix,ct0
															mov	m3,ct1
			mov	mc1,x				mov	mc0,y
			mov	mc1,x	mov	mul,p	mov	mc0,y	clr a
	ad2		mov	mc1,x	mov	mul,p	mov	mc0,y	mov	alu,a 	mov	m3,ct1
	ad2				mov	mul,p	mov	mc0,y	mov	alu,a
			mvi	one,rx
	ad2		mov	mc1,x	mov	mul,p	mov	mc0,y	mov	alu,a
	ad2		mov	mc1,x	mov	mul,p	mov	mc0,y	clr	a	  	mov	alh,mc2			; Rotated X
	ad2		mov	mc1,x	mov	mul,p	mov	mc0,y	mov	alu,a 	mov	m3,ct1
	ad2				mov	mul,p	mov	mc0,y	mov	alu,a
			mvi	one,rx
	ad2		mov	mc1,x	mov	mul,p	mov	mc0,y	mov	alu,a
	ad2		mov	mc1,x	mov	mul,p	mov	mc0,y	clr	a	  	mov	alh,mc2			; Rotated Y
	ad2		mov	mc1,x	mov	mul,p	mov	mc0,y	mov	alu,a
	ad2				mov	mul,p	mov	mc0,y	mov	alu,a
			mvi	one,rx
	ad2				mov	mul,p				mov	alu,a
	ad2														mov	alh,mc2			; Rotated Z
			mvi	0,mc2

		;*- Advance the internal source pointer
												mov	m3,a	mov	Vertex_Size,pl
	add														mov	all,mc3			; Vertex Pointer
			btm
															mov	W_Tptr,ct3

		;*- Then DMA the result back out of ram2
															mov	Dest,ct0
															mov	m0,wa0
															mov	W_D_Point,ct2
															mov	W_PointDMA,ct3
			dma2 m2,d0,m3

		;*- Advance the pointers on some
															mov	Source,ct0
															mov	W_VertexDMA,ct3
												mov	m0,a	mov	mc3,pl
	add														mov	all,mc0			; Vertex source

															mov	Dest,ct0
												mov	m0,a	mov	m3,pl
	add														mov	all,mc0			; Point destination

		;*- Decrease the counter and check if all have been done

												mov	m0,a	mov	maxtr,pl
	sub														mov	all,mc0			; Vertex Counter
			jmp	NZS,Chunk_Loop
															mov	W_Count,ct3
			endi

;*---------------------------------------------------------------------------*
			ENDS
;*- End Of File -------------------------------------------------------------*
