/*
 * Decompiled with CFR 0.152.
 */
package main;

import component.FolderInfo;
import component.SetupUI;
import component.Tool;
import component.Tools;
import flap.FLAPSock;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import main.CLILogin;
import main.ClientDispatcher;
import main.ConnectionProps;
import main.GenericFLAPSockHandler;
import main.LoginAPI;
import main.LoginUI;
import main.Oscar;
import main.PersonalProps;
import main.ProxyProps;
import main.Redirect;
import proxy.ProxyBaseConnector;
import proxy.ProxyConnector;
import proxy.SimpleConnector;
import snac.SnacConstants;
import snac.TLV;
import uiutil.ChoiceListener;
import uiutil.ChoiceUI;
import uiutil.ErrorMgr;
import uiutil.PropertySheet;
import uiutil.UrlViewer;
import util.JUtil;
import util.JarDir;
import util.KeyBindings;
import util.Log;

public class LoginCore
extends GenericFLAPSockHandler
implements SnacConstants,
Tool,
ChoiceListener {
    private static final String MODULE = "LoginCore";
    public static final String MODULE_NAME = "tool.login";
    private static final String[] UIPACK_NAMES = new String[]{"tool.login"};
    private static final String DISPLAY_NAME = "Login";
    public static final int WARNING = -2;
    public static final int ERROR = -1;
    public static final int INITIAL = 0;
    public static final int OPEN_AUTHORIZER = 1;
    public static final int TALK_AUTHORIZER = 2;
    public static final int OPEN_SERVER = 3;
    public static final int TALK_SERVER = 4;
    public static final int CONNECTED = 5;
    private static String[] authorizationErrors = new String[]{null, "invalid screen name or password", "service temporarily unavailable", "all other errors", "incorrect nickname or password", "mismatch nickname or password", "bad input", "invalid account", "deleted account", "expired account", "no db access", "no resolver access", "invalid db fields", "bad db status", "bad resolver status", "internal error", "service temporarily offline", "suspended acct", "db send error", "db link error", "reservation map error", "reservation link error", "same ip connection", "same ip reservation", "reservation rate", "user too heavily warned", "reservation timeout", "client software upgrade required", "client software upgrade reccommended"};
    private static int LOGIN_FAILED_CHOICE;
    private static String[] messages;
    public static String LOGIN_KEY;
    public static String AUTO_CONNECT_KEY;
    public static String AUTO_LOGIN_KEY;
    public static String AUTH_HOST_KEY;
    public static String AUTH_PORT_KEY;
    public static String DEFAULT_AUTH_HOST_KEY;
    public static String DEFAULT_AUTH_PORT_KEY;
    public static String NICKNAME_KEY;
    public static String PASSWORD_KEY;
    public static String USE_PROXY_KEY;
    public static String USER_KEY;
    public static String EXPORT_NICKNAME_KEY;
    public static String DEFAULT_AUTHORIZER;
    public static String DEFAULT_PORT;
    private static String DIST_FILE;
    static int AUTH;
    static int BOS;
    private ClientDispatcher dispatcher;
    private Tools tools;
    private LoginAPI loginUI;
    private int state;
    private String nickname;
    private String password;
    private boolean userCancelled = false;
    private byte[] cookie;
    private boolean isReconnect = false;
    private JarDir proxyDir;
    private ProxyBaseConnector[] proxies;
    private static int[] roaster;
    static /* synthetic */ Class class$proxy$ProxyBaseConnector;

    LoginCore(ClientDispatcher clientDispatcher, Tools tools, boolean bl, boolean bl2, String string, boolean bl3) {
        this.dispatcher = clientDispatcher;
        this.tools = tools;
        this.isReconnect = bl3;
        tools.register(this.getModuleName(), this);
        this.loginUI = bl2 ? new CLILogin(this, string) : new LoginUI(this, string);
        if (bl || bl2) {
            this.loginUI.startLogin();
        }
    }

    public void cancel() {
        this.userCancelled = true;
        this.loginUI.update(-1, "Login cancelled.");
    }

    private void loadProxyInfo() {
        Class clazz = class$proxy$ProxyBaseConnector != null ? class$proxy$ProxyBaseConnector : (class$proxy$ProxyBaseConnector = LoginCore.class$("proxy.ProxyBaseConnector"));
        this.proxyDir = new JarDir(String.valueOf(Oscar.ROOT) + "modules", "proxy.");
        Vector vector = this.proxyDir.findClasses(clazz);
        if (vector == null) {
            vector = new Vector();
        }
        this.proxies = new ProxyConnector[vector.size()];
        int n = 0;
        while (n < this.proxies.length) {
            try {
                this.proxies[n] = (ProxyBaseConnector)((Class)vector.elementAt(n)).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    private void configureProxy() {
        Object object;
        KeyBindings keyBindings = Oscar.config.getKeyBindingsOrAdd(LOGIN_KEY);
        if (Oscar.connector != null) {
            object = keyBindings.getKeyBindings(Oscar.connector.getProxyName());
            Oscar.connector.unconfigure((KeyBindings)object);
        }
        if (this.proxyDir == null) {
            this.loadProxyInfo();
        }
        if (JUtil.isFalse((String)(object = keyBindings.getValueDefault(USE_PROXY_KEY, "false")))) {
            Oscar.connector = new SimpleConnector();
        } else {
            Oscar.connector = null;
            int n = 0;
            while (n < this.proxies.length) {
                String string = this.proxies[n].getProxyName();
                if (((String)object).equals(string)) {
                    Oscar.connector = this.proxies[n];
                    KeyBindings keyBindings2 = keyBindings.getKeyBindings(Oscar.connector.getProxyName());
                    Oscar.connector.configure(keyBindings2);
                }
                ++n;
            }
        }
        if (Oscar.connector == null) {
            Log.log(MODULE, Log.WARNING, "Said we were using " + (String)object + " as a proxy, but I didn't find it.");
        }
    }

    public void doLogin(String string, String string2) {
        this.nickname = string;
        this.password = string2;
        this.userCancelled = false;
        this.state = AUTH;
        KeyBindings keyBindings = Oscar.config.getKeyBindingsOrAdd(LOGIN_KEY);
        String string3 = keyBindings.getValue(AUTH_PORT_KEY);
        if (string3 == null) {
            string3 = keyBindings.getValue(DEFAULT_AUTH_PORT_KEY);
        }
        if (string3 != null) {
            try {
                Oscar.port = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorMgr.error(Oscar.FULL_NAME, "bad port specification in preferences " + string3 + " must be a number (eg. 9993)", numberFormatException);
            }
        }
        this.configureProxy();
        this.loginUI.update(0, messages[0]);
        String string4 = keyBindings.getFirstValue(AUTH_HOST_KEY);
        if (string4 == null) {
            string4 = keyBindings.getFirstValue(DEFAULT_AUTH_HOST_KEY);
        }
        if (string4 == null) {
            string4 = "";
        }
        this.loginUI.update(1, messages[1]);
        try {
            new FLAPSock(this, "Authorization", string4, Oscar.port, Oscar.connector);
            return;
        }
        catch (IOException iOException) {
            this.loginUI.update(-1, "Connection to authorizer failed.");
            ErrorMgr.warn(DISPLAY_NAME, "got exception opening connection to Authorizer " + iOException.getMessage(), iOException);
            return;
        }
    }

    public void setNameAndPassword(String string, String string2) {
        if (this.loginUI != null) {
            this.loginUI.setNameAndPassword(string, string2);
        }
    }

    private byte[] roast(String string) {
        byte[] byArray = new byte[string.length()];
        int n = 0;
        while (n < string.length() && n < 16) {
            byArray[n] = (byte)(string.charAt(n) ^ roaster[n]);
            ++n;
        }
        return byArray;
    }

    public void FLAPConnectionEstablished(FLAPSock fLAPSock) {
        if (this.userCancelled) {
            fLAPSock.close();
            return;
        }
        super.FLAPConnectionEstablished(fLAPSock);
        if (this.state == AUTH) {
            TLV tLV = new TLV(12);
            tLV.addTlv(1, this.nickname);
            tLV.addTlv(2, this.roast(this.password));
            tLV.addTlv(3, Oscar.clientProfile());
            tLV.addTlvU16(22, 1);
            tLV.addTlvU16(23, Oscar.majorVersion);
            tLV.addTlvU16(24, Oscar.minorVersion);
            tLV.addTlvU16(26, Oscar.buildNumber);
            tLV.addTlv(14, Oscar.config.getValueDefault("debug.country", "us"));
            tLV.addTlv(15, Oscar.config.getValueDefault("debug.language", "en"));
            if (Oscar.config.getValue("debug.script") != null) {
                tLV.addTlv(16, Oscar.config.getValue("debug.script"));
            }
            tLV.addTlvU16(9, Oscar.getDisconnectReason());
            this.setDistributionCode(tLV);
            this.loginUI.update(2, messages[2]);
            fLAPSock.sendSignOn(tLV);
            return;
        }
        if (this.state == BOS) {
            TLV tLV = new TLV();
            tLV.addTlv(6, this.cookie);
            this.loginUI.update(4, messages[4]);
            fLAPSock.sendSignOn(tLV);
        }
    }

    private boolean setDistributionCode(TLV tLV) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(String.valueOf(Oscar.ROOT) + DIST_FILE);
            if (fileInputStream.available() != 2) {
                return false;
            }
            byte[] byArray = new byte[2];
            fileInputStream.read(byArray);
            tLV.addTlv(20, byArray);
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {}
            }
            return false;
        }
        return true;
    }

    public boolean FLAPConnectionRetry(FLAPSock fLAPSock) {
        super.FLAPConnectionRetry(fLAPSock);
        if (!this.userCancelled) {
            this.loginUI.update(-2, "Connection failed, trying again");
        }
        return !this.userCancelled;
    }

    public void FLAPConnectionFailed(FLAPSock fLAPSock) {
        super.FLAPConnectionFailed(fLAPSock);
        this.loginUI.update(-1, "Could not establish connection.  Please try again later");
    }

    public void FLAPSignOn(FLAPSock fLAPSock, TLV tLV) {
        if (this.userCancelled) {
            fLAPSock.close();
            return;
        }
        super.FLAPSignOn(fLAPSock, tLV);
        if (this.state != AUTH && this.state == BOS) {
            Oscar.bosCore.setPendingBos(fLAPSock);
            this.dispatcher.takeoverFLAP(fLAPSock);
            this.loginUI.update(5, messages[5]);
            Oscar.mainTool.initiate(null, null);
        }
    }

    public void FLAPSignOnTimeout(FLAPSock fLAPSock) {
        super.FLAPSignOnTimeout(fLAPSock);
        this.loginUI.update(-1, "Lost connection");
    }

    public void FLAPData(FLAPSock fLAPSock, byte[] byArray) {
        super.FLAPData(fLAPSock, byArray);
        ErrorMgr.error(DISPLAY_NAME, "unexpected FLAP data " + JUtil.toHexString(byArray));
    }

    public void FLAPDataOrSignOffTimeout(FLAPSock fLAPSock) {
        super.FLAPDataOrSignOffTimeout(fLAPSock);
        if (this.state == AUTH) {
            this.loginUI.update(-1, "Lost connection");
            return;
        }
        if (this.state == BOS) {
            this.loginUI.update(-1, "Lost connection");
        }
    }

    public void FLAPError(FLAPSock fLAPSock, int n, String string) {
        super.FLAPError(fLAPSock, n, string);
    }

    public void choiceMade(int n, int n2, Object object) {
        if (n == LOGIN_FAILED_CHOICE && n2 == 1) {
            String string = (String)object;
            new UrlViewer(string);
        }
    }

    public void FLAPSignOff(FLAPSock fLAPSock, TLV tLV) {
        if (this.userCancelled) {
            fLAPSock.close();
            return;
        }
        super.FLAPSignOff(fLAPSock, tLV);
        if (this.state == AUTH) {
            fLAPSock.close();
            Redirect redirect = new Redirect(tLV);
            Log.log(MODULE, Log.INFO, "redirect " + redirect);
            if (tLV != null) {
                if (tLV.tlvTypePresent(17)) {
                    Oscar.emailAddress = tLV.getTlvDataAsString(17);
                }
                if (tLV.tlvTypePresent(19)) {
                    Oscar.registrationStatus = tLV.getTlvDataAsU16(19);
                }
            }
            if (redirect.failCode > 0 || redirect.fail != null || redirect.host == null) {
                String string = "Login Failed";
                if (redirect.failCode > 0 && redirect.failCode < authorizationErrors.length) {
                    string = String.valueOf(string) + " due to " + authorizationErrors[redirect.failCode];
                }
                String string2 = "";
                if (redirect.fail != null) {
                    string2 = "more info";
                }
                this.loginUI.update(-1, string);
                ChoiceUI.newChoiceUI(this, LOGIN_FAILED_CHOICE, redirect.fail, "login failed", string, "OK", string2, null, Oscar.WARNING_SOUND);
                return;
            }
            this.state = BOS;
            this.cookie = redirect.cookie;
            if (redirect.port == Redirect.undefinedPort) {
                redirect.port = Oscar.port;
            }
            this.loginUI.update(3, messages[3]);
            try {
                Log.log(MODULE, Log.INFO, "trying to open connection to BOS " + redirect.host + " " + redirect.port);
                new FLAPSock(this, "BOS", redirect.host, redirect.port, Oscar.connector);
                return;
            }
            catch (IOException iOException) {
                this.loginUI.update(-1, "Connection to Server failed.");
                ErrorMgr.warn(DISPLAY_NAME, String.valueOf(fLAPSock.toString()) + " got exception opening BOS " + iOException.getMessage(), iOException);
                return;
            }
        }
        if (this.state == BOS) {
            ErrorMgr.error(DISPLAY_NAME, String.valueOf(fLAPSock.toString()) + " got signoff FLAP from Bos");
        }
    }

    public void FLAPConnectionClosed(FLAPSock fLAPSock, boolean bl, String string, int n) {
        super.FLAPConnectionClosed(fLAPSock, bl, string, n);
        if (!bl) {
            this.loginUI.update(-1, "Connection failed " + string);
            ErrorMgr.warn(DISPLAY_NAME, "Error " + string);
        }
        Oscar.setDisconnectReason(n);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    public int id() {
        return 1;
    }

    public int version() {
        return 1;
    }

    public boolean configurable() {
        return true;
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        int n = 3;
        if (this.proxyDir == null) {
            this.loadProxyInfo();
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < this.proxies.length) {
            if (this.proxies[n2] instanceof ProxyConnector && ((ProxyConnector)this.proxies[n2]).hasPropertySheet()) {
                ++n;
                vector.addElement(this.proxies[n2].getProxyName());
            }
            ++n2;
        }
        FolderInfo[] folderInfoArray = new FolderInfo[n];
        int n3 = 0;
        folderInfoArray[n3] = new FolderInfo(this, 0, this.getDisplayName(), "Personal");
        folderInfoArray[++n3] = new FolderInfo(this, 1, this.getDisplayName(), "Connect");
        ProxyProps proxyProps = new ProxyProps(setupUI, vector);
        folderInfoArray[++n3] = new FolderInfo(this, 2, this.getDisplayName(), "Proxy", proxyProps, true);
        ++n3;
        KeyBindings keyBindings = Oscar.config.getKeyBindingsOrAdd(LOGIN_KEY);
        String string = keyBindings.getValueDefault(USE_PROXY_KEY, "false");
        if (string == null) {
            string = "";
        }
        int n4 = 0;
        while (n4 < this.proxies.length) {
            ProxyConnector proxyConnector;
            if (this.proxies[n4] instanceof ProxyConnector && (proxyConnector = (ProxyConnector)this.proxies[n4]).hasPropertySheet()) {
                String string2 = proxyConnector.getProxyName();
                KeyBindings keyBindings2 = keyBindings.getKeyBindings(string2);
                if (keyBindings2 == null) {
                    keyBindings2 = keyBindings.addKeyBindings(string2);
                }
                boolean bl = false;
                if (string.equals(proxyConnector.getProxyName())) {
                    bl = true;
                }
                folderInfoArray[n3] = new FolderInfo(this, n3, this.getDisplayName(), string2, proxyConnector.getPropertySheet(keyBindings2, setupUI), bl);
                ++n3;
            }
            ++n4;
        }
        return folderInfoArray;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        switch (folderInfo.getFolderId()) {
            case 0: {
                return new PersonalProps(this.tools, this, setupUI);
            }
            case 1: {
                return new ConnectionProps(this, setupUI);
            }
        }
        return null;
    }

    public void exportProperties(KeyBindings keyBindings, KeyBindings keyBindings2) {
        KeyBindings keyBindings3;
        String string;
        KeyBindings keyBindings4 = Oscar.config.getKeyBindings(LOGIN_KEY);
        String string2 = null;
        String string3 = keyBindings2.getValue(String.valueOf(LOGIN_KEY) + "." + NICKNAME_KEY);
        if ((string3 == null || JUtil.isTrue(string3)) && keyBindings4 != null && (string3 = keyBindings4.getValue(NICKNAME_KEY)) != null && string3.length() > 0) {
            keyBindings.setValue(EXPORT_NICKNAME_KEY, string3);
        }
        KeyBindings keyBindings5 = keyBindings.addKeyBindings(LOGIN_KEY);
        string3 = keyBindings2.getValue(String.valueOf(LOGIN_KEY) + "." + LOGIN_KEY);
        if ((string3 == null || JUtil.isTrue(string3)) && keyBindings4 != null) {
            int n = 0;
            while (n < keyBindings4.size()) {
                string = keyBindings4.getKeyAt(n);
                if (!string.equalsIgnoreCase(NICKNAME_KEY) && !string.startsWith(PASSWORD_KEY)) {
                    string3 = keyBindings4.getValue(string);
                    if (string3 != null && string3.length() > 0) {
                        keyBindings5.setValue(string, string3);
                    } else {
                        keyBindings3 = keyBindings4.getValues(string);
                        if (keyBindings3 != null && keyBindings3.size() > 0) {
                            keyBindings5.setValues(string, keyBindings3);
                        }
                    }
                }
                ++n;
            }
        }
        if (((string3 = keyBindings2.getValue(String.valueOf(LOGIN_KEY) + "." + USE_PROXY_KEY)) == null || JUtil.isTrue(string3)) && string2 != null && !JUtil.isFalse(string2) && (keyBindings3 = keyBindings4.getValues(string2)) != null && keyBindings3.size() > 0) {
            string = keyBindings3.getValue("username");
            String string4 = keyBindings3.getValue("password");
            if (string != null) {
                keyBindings3.deleteKey("username");
            }
            if (string4 != null) {
                keyBindings3.deleteKey("password");
            }
            keyBindings5.setValues(string2, keyBindings3);
            string3 = keyBindings2.getValue(String.valueOf(LOGIN_KEY) + "." + NICKNAME_KEY);
            if (string3 == null || JUtil.isTrue(string3)) {
                keyBindings.setValue(String.valueOf(USER_KEY) + "." + string2 + "." + "username", string);
            }
            if (string != null) {
                keyBindings3.setValue("username", string);
            }
            if (string4 != null) {
                keyBindings3.setValue("password", string4);
            }
        }
    }

    public void importProperties(KeyBindings keyBindings, KeyBindings keyBindings2, KeyBindings keyBindings3, boolean bl) {
        KeyBindings keyBindings4;
        String string;
        String string2;
        KeyBindings keyBindings5 = Oscar.config.getKeyBindings(LOGIN_KEY);
        if (!bl && keyBindings5 != null) {
            keyBindings2.setValues(LOGIN_KEY, keyBindings5);
        }
        if (((string2 = keyBindings3.getValue(String.valueOf(LOGIN_KEY) + "." + NICKNAME_KEY)) == null || JUtil.isTrue(string2)) && (string2 = keyBindings.getValue(EXPORT_NICKNAME_KEY)) != null && string2.length() > 0) {
            keyBindings2.setValue(String.valueOf(LOGIN_KEY) + "." + NICKNAME_KEY, string2);
        }
        KeyBindings keyBindings6 = keyBindings.getKeyBindings(LOGIN_KEY);
        KeyBindings keyBindings7 = keyBindings2.addKeyBindings(LOGIN_KEY);
        string2 = keyBindings3.getValue(String.valueOf(LOGIN_KEY) + "." + LOGIN_KEY);
        if ((string2 == null || JUtil.isTrue(string2)) && keyBindings6 != null) {
            int n = 0;
            while (n < keyBindings6.size()) {
                string = keyBindings6.getKeyAt(n);
                string2 = keyBindings6.getValue(string);
                if (string2 != null && string2.length() > 0) {
                    keyBindings7.setValue(string, string2);
                } else {
                    keyBindings4 = keyBindings6.getValues(string);
                    if (keyBindings4 != null && keyBindings4.size() > 0) {
                        keyBindings7.setValues(string, keyBindings4);
                    }
                }
                ++n;
            }
        }
        if (((string2 = keyBindings3.getValue(String.valueOf(LOGIN_KEY) + "." + USE_PROXY_KEY)) == null || JUtil.isTrue(string2)) && (string = keyBindings6.getValue(USE_PROXY_KEY)) != null && !JUtil.isFalse(string)) {
            String string3;
            keyBindings4 = keyBindings6.getValues(string);
            if (keyBindings4 != null && keyBindings4.size() > 0) {
                keyBindings7.setValues(string, keyBindings4);
            }
            if (((string2 = keyBindings3.getValue(String.valueOf(LOGIN_KEY) + "." + NICKNAME_KEY)) == null || JUtil.isTrue(string2)) && (string3 = keyBindings.getValue(String.valueOf(USER_KEY) + "." + string + "." + "username")) != null && string3.length() > 0) {
                keyBindings7.setValue(String.valueOf(string) + "." + "username", string2);
            }
        }
    }

    public boolean initiate(Vector vector, KeyBindings keyBindings) {
        return false;
    }

    public void shutdown() {
        if (this.loginUI != null) {
            this.loginUI.shutdown();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        messages = new String[]{"", "Contacting Authorizer", "Talking to Authorizer", "Contacting Server", "Talking to Server", "Login Successful"};
        LOGIN_KEY = DISPLAY_NAME;
        AUTO_CONNECT_KEY = "autoConnect";
        AUTO_LOGIN_KEY = "autoLogin";
        AUTH_HOST_KEY = "authorizer.hostname";
        AUTH_PORT_KEY = "authorizer.port";
        DEFAULT_AUTH_HOST_KEY = "default.authorizer.hostname";
        DEFAULT_AUTH_PORT_KEY = "default.authorizer.port";
        NICKNAME_KEY = "nickname";
        PASSWORD_KEY = "password";
        USE_PROXY_KEY = "useProxy";
        USER_KEY = "User";
        EXPORT_NICKNAME_KEY = String.valueOf(USER_KEY) + ".screenName";
        DEFAULT_AUTHORIZER = "login.oscar.aol.com";
        DEFAULT_PORT = "5190";
        DIST_FILE = "dist.dat";
        AUTH = 1;
        BOS = 2;
        roaster = new int[]{243, 179, 108, 153, 149, 63, 172, 182, 197, 250, 107, 99, 105, 108, 195, 154};
    }
}

