/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import main.ReqIDEntry;
import snac.Listener;
import snac.ReqID;
import util.Timer;
import util.TimerListener;

class ReqIDMgr
implements TimerListener {
    private static int REQID_TIMEOUT_EVENT;
    Hashtable ids = new Hashtable();
    long lastGC = System.currentTimeMillis();
    boolean weAreClient;
    static int REQ_ID_TIMEOUT;

    ReqIDMgr(boolean bl) {
        this.weAreClient = bl;
    }

    public String toString() {
        String string = "ReqIDMgr: lastGC " + this.lastGC + " ";
        if (this.ids == null || this.ids.size() == 0) {
            string = String.valueOf(string) + "with no ids";
        } else {
            Enumeration enumeration = this.ids.elements();
            try {
                while (enumeration.hasMoreElements()) {
                    ReqIDEntry reqIDEntry = (ReqIDEntry)enumeration.nextElement();
                    string = String.valueOf(string) + reqIDEntry.toString() + " ";
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        return string;
    }

    public synchronized ReqID generateID() {
        ReqID reqID;
        while (this.ids.get(new Integer((reqID = this.weAreClient ? ReqID.generateClientReqID() : ReqID.generateServerReqID()).hashCode())) != null) {
        }
        return reqID;
    }

    synchronized ReqIDEntry lookupID(ReqID reqID) {
        return (ReqIDEntry)this.ids.get(new Integer(reqID.hashCode()));
    }

    synchronized void registerID(ReqID reqID, Listener listener, Object object) {
        if (reqID == null || listener == null) {
            return;
        }
        ReqIDEntry reqIDEntry = new ReqIDEntry(reqID, listener, object);
        this.ids.put(new Integer(reqID.hashCode()), reqIDEntry);
        Timer.createEvent("System", this, REQID_TIMEOUT_EVENT, reqIDEntry, REQ_ID_TIMEOUT);
    }

    public void timerEvent(String string, int n, Object object) {
        if (n == REQID_TIMEOUT_EVENT) {
            if (object == null) {
                return;
            }
            ReqIDEntry reqIDEntry = (ReqIDEntry)object;
            if (this.lookupID(reqIDEntry.id) != null) {
                this.deregisterID(reqIDEntry.id);
                reqIDEntry.listener.requestTimedOut(reqIDEntry.callbackData);
            }
        }
    }

    synchronized void deregisterID(ReqID reqID) {
        if (reqID == null) {
            return;
        }
        if (!this.isIncomingID(reqID)) {
            this.ids.remove(new Integer(reqID.hashCode()));
        }
    }

    boolean isIncomingID(ReqID reqID) {
        if (this.weAreClient) {
            return reqID.isServerID();
        }
        return !reqID.isServerID();
    }

    static {
        REQ_ID_TIMEOUT = 100000;
    }
}

