/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.AdminHostListener;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacAdmininfo;
import snac.SnacHandler;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class AdminHostHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public AdminHostHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(7, 1, this);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeInfoQuery(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got adminInfoQuery SNAC");
        AdminHostListener adminHostListener = (AdminHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (adminHostListener != null) {
                        n2 = this.updateHandledState(n2, adminHostListener.adminInfoQuery(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    AdminHostListener adminHostListener2;
                    if ((adminHostListener2 = (AdminHostListener)vector.elementAt(n)) != adminHostListener) {
                        n2 = this.updateHandledState(n2, adminHostListener2.adminInfoQuery(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminInfoQuery " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void infoReply(FLAPSock fLAPSock, AdminHostListener adminHostListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing adminInfoReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacAdmininfo)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, adminHostListener, object, 7, 3, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminInfoReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeInfoChangeRequest(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got adminInfoChangeRequest SNAC");
        AdminHostListener adminHostListener = (AdminHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (adminHostListener != null) {
                        n2 = this.updateHandledState(n2, adminHostListener.adminInfoChangeRequest(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    AdminHostListener adminHostListener2;
                    if ((adminHostListener2 = (AdminHostListener)vector.elementAt(n)) != adminHostListener) {
                        n2 = this.updateHandledState(n2, adminHostListener2.adminInfoChangeRequest(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminInfoChangeRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void infoChangeReply(FLAPSock fLAPSock, AdminHostListener adminHostListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing adminInfoChangeReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacAdmininfo)vector.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, adminHostListener, object, 7, 5, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminInfoChangeReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    private void decodeAcctConfirmRequest(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got adminAcctConfirmRequest SNAC");
        AdminHostListener adminHostListener = (AdminHostListener)listener;
        int n = this.initHandledState();
        if (adminHostListener != null) {
            n = this.updateHandledState(n, adminHostListener.adminAcctConfirmRequest(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            AdminHostListener adminHostListener2 = (AdminHostListener)vector.elementAt(n2);
            if (adminHostListener2 != adminHostListener) {
                n = this.updateHandledState(n, adminHostListener2.adminAcctConfirmRequest(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void acctConfirmReply(FLAPSock fLAPSock, AdminHostListener adminHostListener, Object object, int n, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing adminAcctConfirmReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.writeShort(n);
            int n2 = 0;
            while (n2 < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n2)).write(outputBuffer);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, adminHostListener, object, 7, 7, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminAcctConfirmReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeAcctDeleteRequest(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got adminAcctDeleteRequest SNAC");
        AdminHostListener adminHostListener = (AdminHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (adminHostListener != null) {
                        n2 = this.updateHandledState(n2, adminHostListener.adminAcctDeleteRequest(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    AdminHostListener adminHostListener2;
                    if ((adminHostListener2 = (AdminHostListener)vector.elementAt(n)) != adminHostListener) {
                        n2 = this.updateHandledState(n2, adminHostListener2.adminAcctDeleteRequest(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminAcctDeleteRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void acctDeleteReply(FLAPSock fLAPSock, AdminHostListener adminHostListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing adminAcctDeleteReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, adminHostListener, object, 7, 9, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminAcctDeleteReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 2) {
            this.decodeInfoQuery(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 4) {
            this.decodeInfoChangeRequest(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 6) {
            this.decodeAcctConfirmRequest(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 8) {
            this.decodeAcctDeleteRequest(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Admin", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

