/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.InviteListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class InviteHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public InviteHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(6, 1, this);
    }

    public void request(FLAPSock fLAPSock, InviteListener inviteListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing inviteRequest SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, inviteListener, object, 6, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Invite", "got IOException in inviteRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    private void decodeRequestAck(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got inviteRequestAck SNAC");
        InviteListener inviteListener = (InviteListener)listener;
        int n = this.initHandledState();
        if (inviteListener != null) {
            n = this.updateHandledState(n, inviteListener.inviteRequestAck(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            InviteListener inviteListener2 = (InviteListener)vector.elementAt(n2);
            if (inviteListener2 != inviteListener) {
                n = this.updateHandledState(n, inviteListener2.inviteRequestAck(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 3) {
            this.decodeRequestAck(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Invite", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

