/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacTlv;
import snac.TLV;
import snac.UserLookupListener;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class UserLookupHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public UserLookupHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(10, 1, this);
    }

    public void findBYEmail(FLAPSock fLAPSock, UserLookupListener userLookupListener, Object object, byte[] byArray) {
        Log.log(MODULE, Log.DB1, "writing userLookupFindBYEmail SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            if (byArray.length < 0) {
                throw new IOException("write underflow");
            }
            if (byArray.length > 8192) {
                throw new IOException("write overflow");
            }
            outputBuffer.write(byArray, 0, byArray.length);
            this.dispatcher.queueOutput(fLAPSock, userLookupListener, object, 10, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("UserLookup", "got IOException in userLookupFindBYEmail " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeFindReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got userLookupFindReply SNAC");
        UserLookupListener userLookupListener = (UserLookupListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (userLookupListener != null) {
                        n2 = this.updateHandledState(n2, userLookupListener.userLookupFindReply(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    UserLookupListener userLookupListener2;
                    if ((userLookupListener2 = (UserLookupListener)vector.elementAt(n)) != userLookupListener) {
                        n2 = this.updateHandledState(n2, userLookupListener2.userLookupFindReply(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("UserLookup", "got IOException in userLookupFindReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 3) {
            this.decodeFindReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("UserLookup", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

