/*
 * Decompiled with CFR 0.152.
 */
package tool.icbm;

import component.FolderInfo;
import component.SetupUI;
import component.Tool;
import component.Tools;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import main.BOSCore;
import main.IcbmAPI;
import main.MissedIcbm;
import main.Nickname;
import main.Oscar;
import main.Rate;
import module.Modules;
import tool.EvilEvent;
import tool.EvilListener;
import tool.ToolStatusEvent;
import tool.icbm.ChannelVersionInfo;
import tool.icbm.IcbmChannel;
import tool.icbm.IcbmChannelEvent;
import tool.icbm.IcbmChannelListener;
import tool.icbm.IcbmRateEvent;
import tool.icbm.SendInfo;
import uiutil.ChoiceUI;
import uiutil.ErrorMgr;
import uiutil.PropertySheet;
import util.EventBus;
import util.EventBusEvent;
import util.EventBusProducer;
import util.JUtil;
import util.KeyBindings;
import util.Log;
import util.Timer;
import util.TimerListener;

public class IcbmTool
implements Tool,
TimerListener,
IcbmAPI,
IcbmChannelListener,
EventBusProducer,
EvilListener {
    private static final String MODULE = "IcbmTool";
    public static final String MODULE_NAME = "tool.icbm";
    private static final String[] UIPACK_NAMES = new String[]{"tool.icbm"};
    private static final String DISPLAY_NAME = "IM";
    public static final String CHANNELBUS = "CHANNELBUS";
    private static int UPDATE_RATE_EVENT;
    private static int MAX_EVIL;
    private static int MAX_SNAC_LEN;
    private BOSCore bosCore;
    private Tools tools;
    private boolean dMessagesEnabled = true;
    private int dMaxIncommingIcbmSize = MAX_SNAC_LEN;
    private long dMinInterIcbmInterval = 100L;
    private int dMaxSenderEvil = MAX_EVIL;
    private int dMaxReceiverEvil = MAX_EVIL;
    private Hashtable channelVersionCache;
    private Hashtable outgoingIcbms;
    private int RATE_INTERVAL = 1000;
    private boolean timerStarted = false;
    private boolean disabled = true;
    Hashtable channels;
    public static final String CHANNEL_KEY = "Channel";
    private EventBus systemBus;
    private EventBus channelBus;
    public static String IM_KEY;
    public static String ANONYMOUS_KEY;
    public static String TIMESTAMP_KEY;
    public static String ENTER_KEY;
    public static String SEND_SOUND_KEY;
    public static String RECEIVE_SOUND_KEY;
    public static String RING_SOUND_KEY;
    public static String FONT_NAME_KEY;
    public static String FONT_STYLE_KEY;
    public static String FONT_SIZE_KEY;
    public static String FONT_FG_COLOR_KEY;
    public static String FONT_BG_COLOR_KEY;
    public static String WINDOW_COLOR_KEY;
    public static String LOCAL_NAME_COLOR_KEY;
    public static String REMOTE_NAME_COLOR_KEY;
    static /* synthetic */ Class class$tool$icbm$IcbmRateEvent;
    static /* synthetic */ Class class$tool$EvilEvent;
    static /* synthetic */ Class class$tool$icbm$IcbmChannelEvent;
    static /* synthetic */ Class class$tool$icbm$IcbmChannel;

    public IcbmTool(BOSCore bOSCore, Tools tools) {
        this.bosCore = bOSCore;
        this.tools = tools;
        this.channelVersionCache = new Hashtable();
        this.outgoingIcbms = new Hashtable();
        tools.register(this.getModuleName(), this);
        this.systemBus = EventBus.joinBus(EventBus.SYSTEM_BUS);
        this.systemBus.addProducerFor(this, class$tool$icbm$IcbmRateEvent != null ? class$tool$icbm$IcbmRateEvent : (class$tool$icbm$IcbmRateEvent = IcbmTool.class$("tool.icbm.IcbmRateEvent")));
        this.systemBus.addListenerFor(this, class$tool$EvilEvent != null ? class$tool$EvilEvent : (class$tool$EvilEvent = IcbmTool.class$("tool.EvilEvent")));
        this.channelBus = EventBus.joinBus(CHANNELBUS);
        this.channelBus.addListenerFor(this, class$tool$icbm$IcbmChannelEvent != null ? class$tool$icbm$IcbmChannelEvent : (class$tool$icbm$IcbmChannelEvent = IcbmTool.class$("tool.icbm.IcbmChannelEvent")));
    }

    public void register(int n, IcbmChannel icbmChannel) {
        this.channels.put(new Integer(n), icbmChannel);
        icbmChannel.setDefaults(this.dMessagesEnabled, this.dMaxIncommingIcbmSize, this.dMinInterIcbmInterval, this.dMaxSenderEvil, this.dMaxReceiverEvil);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    public int id() {
        return 1;
    }

    public int version() {
        return 1;
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        this.loadChannels();
        return null;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        return null;
    }

    public void exportProperties(KeyBindings keyBindings, KeyBindings keyBindings2) {
        KeyBindings keyBindings3;
        String string = keyBindings2.getValue(IM_KEY);
        if ((string == null || JUtil.isTrue(string)) && (keyBindings3 = Oscar.config.getKeyBindingsOrAdd(IM_KEY)) != null) {
            keyBindings.setValues(IM_KEY, keyBindings3);
        }
    }

    public void importProperties(KeyBindings keyBindings, KeyBindings keyBindings2, KeyBindings keyBindings3, boolean bl) {
        KeyBindings keyBindings4 = Oscar.config.getKeyBindings(IM_KEY);
        if (!bl && keyBindings4 != null) {
            keyBindings2.setValues(IM_KEY, keyBindings4);
        }
        KeyBindings keyBindings5 = keyBindings.getKeyBindings(IM_KEY);
        String string = keyBindings3.getValue(IM_KEY);
        if ((string == null || JUtil.isTrue(string)) && keyBindings5 != null) {
            KeyBindings keyBindings6 = keyBindings2.addKeyBindings(IM_KEY);
            int n = 0;
            while (n < keyBindings5.size()) {
                String string2 = keyBindings5.getKeyAt(n);
                string = keyBindings5.getValue(string2);
                if (string != null && string.length() > 0) {
                    keyBindings6.setValue(string2, string);
                } else {
                    keyBindings4 = keyBindings5.getValues(string2);
                    if (keyBindings4 != null && keyBindings4.size() > 0) {
                        keyBindings6.setValues(string2, keyBindings4);
                    }
                }
                ++n;
            }
        }
    }

    public boolean initiate(Vector vector, KeyBindings keyBindings) {
        Object object;
        String string = null;
        if (vector != null) {
            string = (String)vector.elementAt(0);
        }
        if (!this.timerStarted) {
            Timer.createEvent("System", this, UPDATE_RATE_EVENT, null, this.RATE_INTERVAL);
            this.timerStarted = true;
        }
        int n = 1;
        if (keyBindings != null && keyBindings.size() > 0) {
            object = keyBindings.getValueDefault(CHANNEL_KEY, "1");
            try {
                n = new Integer((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                Log.log(MODULE, Log.ERROR, "invalid channel for initiate: " + (String)object);
                return false;
            }
        }
        object = new IcbmChannelEvent(this, 1100, n, new Nickname(string));
        this.channelBus.postEvent((EventBusEvent)object);
        return true;
    }

    public void shutdown() {
        Log.log(MODULE, Log.INFO, "got shutdown");
    }

    public String toString() {
        return this.getClass().getName();
    }

    private void loadChannels() {
        if (this.channels == null) {
            this.channels = new Hashtable();
            KeyBindings keyBindings = Oscar.config.getKeyBindings("ICBM.Channels");
            if (keyBindings == null) {
                Oscar.config.addKeyBindings("ICBM.Channels");
                keyBindings = Oscar.config.getKeyBindings("ICBM.Channels");
                keyBindings.setKeySeparator('#');
                keyBindings.addKeyBindings("icbm.aolim.jar");
                if (Oscar.config.getValue("debug.rendezvousTest") != null) {
                    keyBindings.addKeyBindings("icbm.rendezvous.jar");
                }
                keyBindings.setKeySeparator('.');
                Oscar.saveConfiguration();
            }
            Vector vector = Modules.loadModules(keyBindings, class$tool$icbm$IcbmChannel != null ? class$tool$icbm$IcbmChannel : (class$tool$icbm$IcbmChannel = IcbmTool.class$("tool.icbm.IcbmChannel")));
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                IcbmChannel icbmChannel = (IcbmChannel)vector.elementAt(n2);
                icbmChannel.initiate(this);
                ++n2;
            }
        }
    }

    public void connect() {
        this.loadChannels();
        ToolStatusEvent toolStatusEvent = new ToolStatusEvent(this, 1400, "ICBM");
        this.systemBus.postEvent(toolStatusEvent);
    }

    public void disconnect() {
        ToolStatusEvent toolStatusEvent = new ToolStatusEvent(this, 1401, "ICBM");
        this.systemBus.postEvent(toolStatusEvent);
    }

    public void setEnabled(boolean bl) {
        ToolStatusEvent toolStatusEvent = bl ? new ToolStatusEvent(this, 1402, "ICBM") : new ToolStatusEvent(this, 1403, "ICBM");
        this.systemBus.postEvent(toolStatusEvent);
    }

    public void service() {
    }

    public void eventListenerAdded(String string, Class clazz, EventListener eventListener) {
        if (string.equals("System") && clazz == (class$tool$icbm$IcbmRateEvent != null ? class$tool$icbm$IcbmRateEvent : (class$tool$icbm$IcbmRateEvent = IcbmTool.class$("tool.icbm.IcbmRateEvent")))) {
            Rate rate = this.bosCore.getRate(BOSCore.SendMessage, System.currentTimeMillis());
            if (rate != null) {
                IcbmRateEvent icbmRateEvent = new IcbmRateEvent(this, 1100, rate);
                icbmRateEvent.deliverEvent(eventListener);
            }
            if (!this.timerStarted) {
                Timer.createEvent("System", this, UPDATE_RATE_EVENT, null, this.RATE_INTERVAL);
                this.timerStarted = true;
            }
        }
    }

    public void eventListenerRemoved(String string, Class clazz, EventListener eventListener) {
    }

    public void updateRate() {
        Rate rate = this.bosCore.getRate(BOSCore.SendMessage, System.currentTimeMillis());
        if (rate == null) {
            return;
        }
        IcbmRateEvent icbmRateEvent = new IcbmRateEvent(this, 1100, rate);
        this.systemBus.postEvent(icbmRateEvent);
    }

    public void updateUserEvil(String string, int n) {
    }

    public void updateUserInfo(Nickname nickname) {
    }

    public void acknowledgeEvil(int n, int n2, String string) {
        ChoiceUI.newChoiceUI("Warning Confirmation", "You Warned " + string + " with " + n + " units of Warning for a total Warning level of " + n2 + ".");
    }

    public int getMaxIncommingIcbmSize(int n) {
        IcbmChannel icbmChannel = (IcbmChannel)this.channels.get(new Integer(n));
        if (icbmChannel == null) {
            return -1;
        }
        return icbmChannel.getMaxIncommingIcbmSize();
    }

    public boolean getMessagesState(int n) {
        IcbmChannel icbmChannel = (IcbmChannel)this.channels.get(new Integer(n));
        if (icbmChannel == null) {
            return false;
        }
        return icbmChannel.getMessagesState();
    }

    public long getMinInterIcbmInterval(int n) {
        IcbmChannel icbmChannel = (IcbmChannel)this.channels.get(new Integer(n));
        if (icbmChannel == null) {
            return -1L;
        }
        return icbmChannel.getMinInterIcbmInterval();
    }

    public int getMaxSenderEvil(int n) {
        IcbmChannel icbmChannel = (IcbmChannel)this.channels.get(new Integer(n));
        if (icbmChannel == null) {
            return -1;
        }
        return icbmChannel.getMaxSenderEvil();
    }

    public int getMaxReceiverEvil(int n) {
        IcbmChannel icbmChannel = (IcbmChannel)this.channels.get(new Integer(n));
        if (icbmChannel == null) {
            return -1;
        }
        return icbmChannel.getMaxReceiverEvil();
    }

    public void receiveMessage(Nickname nickname, int n, byte[] byArray, byte[] byArray2, boolean bl) {
        ChannelVersionInfo channelVersionInfo = this.lookupChannelVersionInfo(nickname.nickname, n);
        Log.log(MODULE, Log.DB0, "recieveMessage " + channelVersionInfo.toString());
        if (!channelVersionInfo.versionKnown()) {
            Log.log(MODULE, Log.NOTICE, "channel version unknown " + nickname + " " + n);
            this.bosCore.sendIcbmPayloadError(nickname.nickname, n, byArray, "you sent an icbm on channel " + n + " but I don't know your " + "channel version");
            if (channelVersionInfo.state == ChannelVersionInfo.unknownVersion) {
                channelVersionInfo.state = ChannelVersionInfo.versionQueryPending;
                this.bosCore.getChannelVersion(nickname.nickname, n, this.bosCore.getCookie());
                return;
            }
        } else {
            if (channelVersionInfo.state != ChannelVersionInfo.knownCompatibleVersion) {
                if (channelVersionInfo.state != ChannelVersionInfo.knownIncompatibleVersion) {
                    Log.log(MODULE, Log.NOTICE, "version is incompatible " + nickname + " " + n);
                    this.bosCore.sendUnsupportedChannelError(nickname.nickname, n, byArray, "you sent an icbm on channel " + n + " but we don't support version " + channelVersionInfo.version);
                    return;
                }
                Log.log(MODULE, Log.NOTICE, "version is unsupported " + nickname + n);
                this.bosCore.sendUnsupportedChannelError(nickname.nickname, n, byArray, "you sent an icbm on channel " + n + " but you told us that you didn't support that channel ");
                return;
            }
            IcbmChannel icbmChannel = (IcbmChannel)this.channels.get(new Integer(n));
            if (icbmChannel == null) {
                ErrorMgr.warn(MODULE, "unable to get channel " + n + ".");
                return;
            }
            IcbmChannelEvent icbmChannelEvent = new IcbmChannelEvent(this, 1102, n, nickname, byArray2, byArray, bl);
            this.channelBus.postEvent(icbmChannelEvent);
        }
    }

    public boolean isCompatibleVersion(int n, String string) {
        IcbmChannel icbmChannel = (IcbmChannel)this.channels.get(new Integer(n));
        if (icbmChannel == null) {
            return false;
        }
        String string2 = JUtil.bytesToString(icbmChannel.getChannelVersion());
        return string2.equals(string);
    }

    public byte[] getChannelVersion(int n) {
        IcbmChannel icbmChannel = (IcbmChannel)this.channels.get(new Integer(n));
        if (icbmChannel == null) {
            return null;
        }
        return icbmChannel.getChannelVersion();
    }

    public void setChannelVersion(String string, int n, byte[] byArray, byte[] byArray2) {
        ChannelVersionInfo channelVersionInfo = this.storeChannelVersionInfo(string, n, JUtil.bytesToString(byArray2));
        int n2 = 0;
        while (n2 < channelVersionInfo.msgsToSend.size()) {
            SendInfo sendInfo = (SendInfo)channelVersionInfo.msgsToSend.elementAt(n2);
            if (sendInfo != null && sendInfo.state == SendInfo.pending) {
                if (channelVersionInfo.state == ChannelVersionInfo.knownCompatibleVersion) {
                    byte[] byArray3 = this.bosCore.getCookie();
                    this.recordSend(sendInfo.name, sendInfo.channel, byArray3, sendInfo.data);
                    this.bosCore.sendMessage(sendInfo.name, sendInfo.channel, byArray3, sendInfo.data, sendInfo.autoResponse);
                } else {
                    this.reportBadChannelToUser(sendInfo.name, sendInfo.channel, sendInfo.data);
                }
            }
            this.clearSend(byArray);
            ++n2;
        }
        channelVersionInfo.msgsToSend.removeAllElements();
    }

    public void unsupportedChannel(String string, int n, byte[] byArray, String string2) {
        ChannelVersionInfo channelVersionInfo = this.storeChannelVersionInfo(string, n, null);
        channelVersionInfo.state = ChannelVersionInfo.unsupportedChannel;
        SendInfo sendInfo = this.lookupSend(byArray);
        if (sendInfo != null) {
            this.reportBadChannelToUser(sendInfo.name, sendInfo.channel, sendInfo.data);
            this.clearSend(byArray);
        }
    }

    private void reportBadChannelToUser(String string, int n, byte[] byArray) {
        ErrorMgr.warn(MODULE, "Sorry " + string + "'s client does not support a " + "compatible version of channel " + n);
    }

    public void payloadError(String string, int n, byte[] byArray, String string2) {
        IcbmChannel icbmChannel = (IcbmChannel)this.channels.get(new Integer(n));
        if (icbmChannel == null) {
            if (string2 == null) {
                string2 = "of an unknown reason";
            }
            ErrorMgr.warn(MODULE, "The ICBM you sent to " + string + " was rejected because " + string2);
            return;
        }
        IcbmChannelEvent icbmChannelEvent = new IcbmChannelEvent(this, 1103, n, new Nickname(string), null, byArray, false);
        this.channelBus.postEvent(icbmChannelEvent);
    }

    public void channelError(String string, int n, byte[] byArray, String string2) {
        IcbmChannel icbmChannel = (IcbmChannel)this.channels.get(new Integer(n));
        if (icbmChannel == null) {
            ErrorMgr.warn(MODULE, "The ICBM you sent to " + string + " on unregistered channel " + n + " was rejected.");
            return;
        }
        IcbmChannelEvent icbmChannelEvent = new IcbmChannelEvent(this, 1105, n, new Nickname(string), null, byArray, false);
        this.channelBus.postEvent(icbmChannelEvent);
    }

    public void channelSpecificError(String string, int n, byte[] byArray, byte[] byArray2) {
        IcbmChannel icbmChannel = (IcbmChannel)this.channels.get(new Integer(n));
        if (icbmChannel == null) {
            ErrorMgr.warn(MODULE, "The ICBM you sent to " + string + " on unregistered channel " + n + " was rejected.");
            return;
        }
        IcbmChannelEvent icbmChannelEvent = new IcbmChannelEvent(this, 1105, n, new Nickname(string), byArray2, byArray, false);
        this.channelBus.postEvent(icbmChannelEvent);
        System.out.println("Channel-specific error:\n    from: " + string + " channel: " + n + "  cookie: " + JUtil.bytesToHexString(byArray) + "    info: " + new String(byArray2));
    }

    public void missedIcbms(Vector vector) {
        if (vector == null || vector.size() < 1) {
            return;
        }
        String string = "";
        int n = 0;
        while (n < vector.size()) {
            if (n > 0) {
                string = String.valueOf(string) + ", ";
            }
            MissedIcbm missedIcbm = (MissedIcbm)vector.elementAt(n);
            String string2 = "";
            if (missedIcbm.reason == MissedIcbm.tooLarge) {
                string2 = " because they were too large";
            } else if (missedIcbm.reason == MissedIcbm.rateExceeded) {
                string2 = " because they were sent too fast";
            } else if (missedIcbm.reason == MissedIcbm.senderTooEvil) {
                string2 = " because they are too heavily Warned";
            } else if (missedIcbm.reason == MissedIcbm.receiverTooEvil) {
                string2 = " because you are too heavily Warned";
            }
            string = String.valueOf(string) + "missed " + missedIcbm.numMissed + " icbms from " + missedIcbm.from.nickname + string2;
            ++n;
        }
        ErrorMgr.warn(MODULE, string);
    }

    public void isAvailable(String string, boolean bl) {
        String string2 = bl ? "is online" : "is not online";
        ChoiceUI.newChoiceUI(String.valueOf(string) + string2, String.valueOf(string) + string2);
    }

    public void setDefaults(boolean bl, int n, long l, int n2, int n3) {
        this.dMessagesEnabled = bl;
        this.dMaxSenderEvil = n2;
        this.dMaxReceiverEvil = n3;
        Enumeration enumeration = this.channels.elements();
        while (enumeration.hasMoreElements()) {
            IcbmChannel icbmChannel = (IcbmChannel)enumeration.nextElement();
            icbmChannel.setDefaults(this.dMessagesEnabled, this.dMaxIncommingIcbmSize, this.dMinInterIcbmInterval, this.dMaxSenderEvil, this.dMaxReceiverEvil);
        }
    }

    public void receiveMessage(IcbmChannelEvent icbmChannelEvent) {
    }

    public void sendMessage(IcbmChannelEvent icbmChannelEvent) {
        this.sendMessage(icbmChannelEvent.getChannel(), icbmChannelEvent.getNickname().nickname, icbmChannelEvent.getData(), icbmChannelEvent.isAutoResponse());
    }

    public void initiateMessage(IcbmChannelEvent icbmChannelEvent) {
    }

    public void payloadError(IcbmChannelEvent icbmChannelEvent) {
        if (icbmChannelEvent.getId() == 1104) {
            this.bosCore.sendIcbmPayloadError(icbmChannelEvent.getNickname().nickname, icbmChannelEvent.getChannel(), icbmChannelEvent.getCookie(), "unspecified reason");
        }
    }

    public void channelError(IcbmChannelEvent icbmChannelEvent) {
        if (icbmChannelEvent.getId() == 1106) {
            this.bosCore.sendChannelSpecificError(icbmChannelEvent.getNickname().nickname, icbmChannelEvent.getChannel(), icbmChannelEvent.getCookie(), icbmChannelEvent.getData());
        }
    }

    public void attributeChanged() {
    }

    public void sendEvil(EvilEvent evilEvent) {
        this.bosCore.sendEvil(evilEvent.getRemoteUser().nickname, evilEvent.isAnonymous());
    }

    public void sendMessage(int n, String string, byte[] byArray, boolean bl) {
        Log.log(MODULE, Log.INFO, "sending message to " + string + " on channel " + n + " autoResponse=" + bl);
        byte[] byArray2 = this.bosCore.getCookie();
        ChannelVersionInfo channelVersionInfo = this.lookupChannelVersionInfo(string, n);
        Log.log(MODULE, Log.DB0, "sendMessage " + channelVersionInfo.toString());
        if (!channelVersionInfo.versionKnown()) {
            Log.log(MODULE, Log.DB0, "about to record send.");
            SendInfo sendInfo = this.recordPendingSend(string, n, byArray2, byArray, bl);
            channelVersionInfo.msgsToSend.addElement(sendInfo);
            channelVersionInfo.state = ChannelVersionInfo.versionQueryPending;
            Log.log(MODULE, Log.DB0, "querying for channel version.");
            this.bosCore.getChannelVersion(string, n, byArray2);
            return;
        }
        if (channelVersionInfo.state == ChannelVersionInfo.knownIncompatibleVersion || channelVersionInfo.state == ChannelVersionInfo.unsupportedChannel) {
            this.reportBadChannelToUser(string, n, byArray);
            return;
        }
        this.recordSend(string, n, byArray2, byArray);
        this.bosCore.sendMessage(string, n, byArray2, byArray, bl);
    }

    public void sendChannelSpecificError(int n, String string, byte[] byArray, byte[] byArray2) {
        Log.log(MODULE, Log.INFO, "sending channel-specific error to " + string + " on channel " + n + " optionalInfo=" + byArray2);
        this.bosCore.sendChannelSpecificError(string, n, byArray, byArray2);
    }

    public void timerEvent(String string, int n, Object object) {
        if (n == UPDATE_RATE_EVENT) {
            this.updateRate();
            Timer.createEvent("System", this, UPDATE_RATE_EVENT, null, this.RATE_INTERVAL);
        }
    }

    private synchronized ChannelVersionInfo storeChannelVersionInfo(String string, int n, String string2) {
        Vector<ChannelVersionInfo> vector = (Vector<ChannelVersionInfo>)this.channelVersionCache.get(string);
        if (vector == null) {
            vector = new Vector<ChannelVersionInfo>(1);
            this.channelVersionCache.put(string, vector);
        }
        ChannelVersionInfo channelVersionInfo = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            ChannelVersionInfo channelVersionInfo2 = (ChannelVersionInfo)vector.elementAt(n2);
            if (channelVersionInfo2.channel == n) {
                channelVersionInfo = channelVersionInfo2;
                break;
            }
            ++n2;
        }
        if (channelVersionInfo == null) {
            channelVersionInfo = new ChannelVersionInfo(n, string2);
            vector.addElement(channelVersionInfo);
        }
        channelVersionInfo.version = string2;
        channelVersionInfo.state = string2 == null ? ChannelVersionInfo.unsupportedChannel : (this.isCompatibleVersion(n, string2) ? ChannelVersionInfo.knownCompatibleVersion : ChannelVersionInfo.knownIncompatibleVersion);
        return channelVersionInfo;
    }

    public void clearUserInfo(String[] stringArray) {
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            String string = stringArray[n];
            this.clearChannelVersionInfo(string, -1);
            ++n;
        }
    }

    private synchronized void clearChannelVersionInfo(String string, int n) {
        if (n == -1) {
            this.channelVersionCache.remove(string);
            return;
        }
        Vector vector = (Vector)this.channelVersionCache.get(string);
        if (vector == null) {
            return;
        }
        ChannelVersionInfo channelVersionInfo = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            ChannelVersionInfo channelVersionInfo2 = (ChannelVersionInfo)vector.elementAt(n2);
            if (channelVersionInfo2.channel == n) {
                channelVersionInfo = channelVersionInfo2;
                break;
            }
            ++n2;
        }
        if (channelVersionInfo == null) {
            return;
        }
        channelVersionInfo.version = null;
        channelVersionInfo.state = ChannelVersionInfo.unknownVersion;
    }

    private synchronized ChannelVersionInfo lookupChannelVersionInfo(String string, int n) {
        ChannelVersionInfo channelVersionInfo = null;
        Vector vector = (Vector)this.channelVersionCache.get(string);
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                ChannelVersionInfo channelVersionInfo2 = (ChannelVersionInfo)vector.elementAt(n2);
                if (channelVersionInfo2.channel == n) {
                    channelVersionInfo = channelVersionInfo2;
                    break;
                }
                ++n2;
            }
        }
        if (channelVersionInfo == null) {
            channelVersionInfo = this.storeChannelVersionInfo(string, n, null);
            channelVersionInfo.state = ChannelVersionInfo.unknownVersion;
        }
        return channelVersionInfo;
    }

    private synchronized SendInfo recordPendingSend(String string, int n, byte[] byArray, byte[] byArray2, boolean bl) {
        SendInfo sendInfo = new SendInfo(string, n, byArray2, bl);
        sendInfo.state = SendInfo.pending;
        this.outgoingIcbms.put(new String(byArray), sendInfo);
        return sendInfo;
    }

    private synchronized void garbageCollectSends() {
    }

    private synchronized SendInfo recordSend(String string, int n, byte[] byArray, byte[] byArray2) {
        SendInfo sendInfo = new SendInfo(string, n, byArray2, false);
        sendInfo.state = SendInfo.sent;
        this.outgoingIcbms.put(new String(byArray), sendInfo);
        this.garbageCollectSends();
        return sendInfo;
    }

    private synchronized SendInfo lookupSend(byte[] byArray) {
        return (SendInfo)this.outgoingIcbms.get(new String(byArray));
    }

    public void clearSend(byte[] byArray) {
        SendInfo sendInfo = (SendInfo)this.outgoingIcbms.remove(new String(byArray));
        if (sendInfo != null) {
            sendInfo.state = SendInfo.aborted;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        MAX_EVIL = 999;
        MAX_SNAC_LEN = 7999;
        IM_KEY = DISPLAY_NAME;
        ANONYMOUS_KEY = "anonymousEvil";
        TIMESTAMP_KEY = "viewTimestamp";
        ENTER_KEY = "enterKeyInserts";
        SEND_SOUND_KEY = "sendSound";
        RECEIVE_SOUND_KEY = "receiveSound";
        RING_SOUND_KEY = "ringSound";
        FONT_NAME_KEY = "font.face";
        FONT_STYLE_KEY = "font.style";
        FONT_SIZE_KEY = "font.size";
        FONT_FG_COLOR_KEY = "font.textColor";
        FONT_BG_COLOR_KEY = "font.bgColor";
        WINDOW_COLOR_KEY = "windowColor";
        LOCAL_NAME_COLOR_KEY = "localNameColor";
        REMOTE_NAME_COLOR_KEY = "remoteNameColor";
    }
}

