/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.util.Vector;
import uiutil.FocusGroupMember;

public class FocusGroup {
    private Vector list;
    private FocusGroupMember focusOwner;
    private String name;

    public FocusGroup() {
        this(null, 5);
    }

    public FocusGroup(String string) {
        this(string, 5);
    }

    public FocusGroup(int n) {
        this(null, n);
    }

    public FocusGroup(String string, int n) {
        this.name = string;
        this.list = new Vector(n);
    }

    public FocusGroupMember getFocusOwner() {
        return this.focusOwner;
    }

    public synchronized void add(FocusGroupMember focusGroupMember) {
        boolean bl = false;
        int n = 0;
        while (n < this.list.size()) {
            if ((FocusGroupMember)this.list.elementAt(n) == focusGroupMember) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.list.addElement(focusGroupMember);
        }
    }

    public synchronized void remove(FocusGroupMember focusGroupMember) {
        this.list.removeElement(focusGroupMember);
        if (this.list.size() < 1) {
            this.focusOwner = null;
        }
    }

    public synchronized void relinquishFocus(FocusGroupMember focusGroupMember) {
        if (focusGroupMember == this.focusOwner) {
            focusGroupMember.removeFocus();
            focusGroupMember = null;
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "FOCUS GROUP " + this.name + " has " + this.list.size() + " elements.";
    }

    public synchronized void claimFocus(FocusGroupMember focusGroupMember) {
        boolean bl = false;
        int n = 0;
        while (n < this.list.size()) {
            if ((FocusGroupMember)this.list.elementAt(n) == focusGroupMember) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            if (this.focusOwner != null && this.focusOwner != focusGroupMember) {
                this.focusOwner.removeFocus();
            }
            this.focusOwner = focusGroupMember;
            this.focusOwner.setFocus();
        }
    }

    public void setPrevious() {
        this.setPrevious(this.focusOwner);
    }

    public synchronized void setPrevious(FocusGroupMember focusGroupMember) {
        if (focusGroupMember != this.focusOwner) {
            return;
        }
        int n = this.list.size();
        int n2 = this.list.indexOf(focusGroupMember);
        int n3 = (n2 + n - 1) % n;
        FocusGroupMember focusGroupMember2 = focusGroupMember;
        while (n3 != n2) {
            focusGroupMember2 = (FocusGroupMember)this.list.elementAt(n3);
            if (focusGroupMember2.canHaveFocus()) break;
            n3 = (n3 + n - 1) % n;
        }
        if (n3 != n2) {
            this.focusOwner.removeFocus();
            this.focusOwner = focusGroupMember2;
            focusGroupMember2.setFocus();
        }
    }

    public void setNext() {
        this.setNext(this.focusOwner);
    }

    public synchronized void setNext(FocusGroupMember focusGroupMember) {
        if (focusGroupMember != this.focusOwner) {
            return;
        }
        int n = this.list.size();
        int n2 = this.list.indexOf(focusGroupMember);
        int n3 = (n2 + 1) % n;
        FocusGroupMember focusGroupMember2 = focusGroupMember;
        while (n3 != n2) {
            focusGroupMember2 = (FocusGroupMember)this.list.elementAt(n3);
            if (focusGroupMember2.canHaveFocus()) break;
            n3 = (n3 + 1) % n;
        }
        if (n3 != n2) {
            this.focusOwner.removeFocus();
            this.focusOwner = focusGroupMember2;
            focusGroupMember2.setFocus();
        }
    }

    public synchronized void setFirst() {
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            FocusGroupMember focusGroupMember = (FocusGroupMember)this.list.elementAt(n2);
            if (focusGroupMember.canHaveFocus()) {
                this.claimFocus(focusGroupMember);
                return;
            }
            ++n2;
        }
    }

    public synchronized void setLast() {
        int n = this.list.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            FocusGroupMember focusGroupMember = (FocusGroupMember)this.list.elementAt(n2);
            if (focusGroupMember.canHaveFocus()) {
                this.claimFocus(focusGroupMember);
                return;
            }
            --n2;
        }
    }

    public boolean focusIsFree() {
        return this.focusOwner == null;
    }

    public void clear() {
        this.list.removeAllElements();
        this.focusOwner = null;
    }
}

