/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import uiutil.ChangeListener;
import uiutil.EListListener;
import uiutil.EditableList;
import util.ItemChecker;

public class ListEditor
extends Container
implements EListListener,
ActionListener {
    public static int ORIGLIST;
    public static int CURLIST;
    public static int ADDLIST;
    public static int DELETELIST;
    public static String initialEntryText;
    private ChangeListener changeListener;
    private EditableList list;
    private String title;
    private Button addButton;
    private Button deleteButton;
    private Vector[] lists;
    private boolean listHasChanged;
    private Label titleLabel;
    private boolean removeDefault = false;

    public ListEditor() {
        this("List Editor", "Add", "Delete", null, null);
    }

    public ListEditor(String string, String string2, String string3, ChangeListener changeListener, ItemChecker itemChecker) {
        this.changeListener = changeListener;
        this.title = string;
        this.list = new EditableList();
        this.list.registerListener(this);
        this.list.registerItemChecker(itemChecker);
        this.lists = new Vector[4];
        this.setLayout(new BorderLayout());
        if (string != null) {
            this.titleLabel = new Label(string);
            this.add("North", this.titleLabel);
        }
        this.add("Center", this.list);
        Panel panel = new Panel();
        this.addButton = new Button(string2);
        panel.add(this.addButton);
        this.addButton.addActionListener(this);
        this.deleteButton = new Button(string3);
        panel.add(this.deleteButton);
        this.deleteButton.addActionListener(this);
        this.add("South", panel);
    }

    public void setButtonLabel(String string, String string2) {
        this.addButton.setLabel(string);
        this.deleteButton.setLabel(string2);
    }

    public void setEntryText(String string) {
        initialEntryText = string;
    }

    public void removeNotify() {
        if (this.list != null) {
            this.list.destroy();
            this.list = null;
        }
        this.addButton = null;
        this.deleteButton = null;
        this.changeListener = null;
        int n = 0;
        while (n < this.lists.length) {
            if (this.lists[n] != null) {
                this.lists[n] = null;
            }
            ++n;
        }
        this.lists = null;
        super.removeNotify();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            this.addItem();
            return;
        }
        if (object == this.deleteButton) {
            this.delItem();
        }
    }

    public boolean validItem(String string) {
        return this.list.validItem(string);
    }

    public void addItem() {
        int n = this.list.getSelectedIndex();
        if (n >= 0) {
            if (!this.validItem(this.list.getItem(n))) {
                return;
            }
            this.list.addItem(initialEntryText, n);
            this.list.select(n);
        } else {
            this.list.addItem(initialEntryText);
            n = this.list.count() - 1;
            this.list.select(n);
        }
        if (this.changeListener != null) {
            this.changeListener.setChanged(true);
        }
        this.listHasChanged = true;
    }

    public void entryChanged(int n) {
        if (n < 0) {
            return;
        }
        if (this.changeListener != null) {
            this.changeListener.setChanged(true);
        }
        this.listHasChanged = true;
    }

    public void delItem() {
        int n = this.list.getSelectedIndex();
        if (n >= 0) {
            this.list.delItem(n);
        } else {
            this.list.delItem();
        }
        if (this.changeListener != null) {
            this.changeListener.setChanged(true);
        }
        this.listHasChanged = true;
    }

    private void showItems() {
        this.calculateChangeLists();
        Vector vector = this.list.getItems();
        if (vector != null) {
            System.out.println("Current list.. " + vector);
        }
        if (this.lists[ADDLIST] != null) {
            System.out.println("Add list <<< " + this.lists[ADDLIST]);
        }
        if (this.lists[DELETELIST] != null) {
            System.out.println("Delete list >>> " + this.lists[DELETELIST]);
        }
    }

    public void clear() {
        if (this.list != null) {
            this.list.clear();
        }
        int n = 0;
        while (n < this.lists.length) {
            if (this.lists[n] != null) {
                this.lists[n].removeAllElements();
            }
            ++n;
        }
    }

    public void setValues(Vector vector) {
        this.lists[ListEditor.ORIGLIST] = vector;
        if (vector != null) {
            this.list.clear();
            this.list.addItems(vector);
            return;
        }
        this.lists[ListEditor.ORIGLIST] = new Vector();
    }

    public void setValues(String[] stringArray) {
        if (stringArray != null) {
            this.lists[ListEditor.ORIGLIST] = new Vector(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.lists[ORIGLIST].addElement(stringArray[n]);
                ++n;
            }
            this.list.clear();
            this.list.addItems(this.lists[ORIGLIST]);
        }
    }

    private void calculateChangeLists() {
        int n;
        if (!this.listHasChanged) {
            return;
        }
        Vector vector = this.getItems();
        if (vector == null || (n = vector.size()) <= 0) {
            return;
        }
        this.lists[ListEditor.CURLIST] = new Vector(vector.size());
        this.lists[ListEditor.DELETELIST] = new Vector(10);
        n = this.lists[ORIGLIST] == null ? 0 : this.lists[ORIGLIST].size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.lists[ORIGLIST].elementAt(n2);
            boolean bl = vector.removeElement(string);
            if (!bl) {
                this.lists[DELETELIST].addElement(string);
            } else {
                this.lists[CURLIST].addElement(string);
            }
            ++n2;
        }
        this.lists[ListEditor.ADDLIST] = vector;
        n = vector.size();
        n2 = 0;
        while (n2 < n) {
            this.lists[CURLIST].addElement(vector.elementAt(n2));
            ++n2;
        }
        this.listHasChanged = false;
    }

    public boolean hasChanged() {
        Vector vector = this.getItems();
        int n = this.lists[ORIGLIST] == null ? 0 : this.lists[ORIGLIST].size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.lists[ORIGLIST].elementAt(n2);
            if (!vector.removeElement(string)) {
                return true;
            }
            ++n2;
        }
        return vector.size() > 0;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
        this.list.setEnabled(bl);
        if (this.title != null) {
            if (bl) {
                this.titleLabel.setForeground(Color.black);
            } else {
                this.titleLabel.setForeground(Color.gray);
            }
        }
        this.list.requestFocus();
    }

    public void setAddList(Vector vector) {
        this.lists[ListEditor.ADDLIST] = vector == null ? new Vector() : vector;
    }

    public void setDeleteList(Vector vector) {
        this.lists[ListEditor.DELETELIST] = vector == null ? new Vector() : vector;
    }

    private final Vector getItems() {
        Vector vector = this.list.getItems();
        if (vector == null || !this.removeDefault) {
            return vector;
        }
        Vector<String> vector2 = new Vector<String>(vector.size());
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            if (!string.equals(initialEntryText)) {
                vector2.addElement(string);
            }
            ++n2;
        }
        return vector2;
    }

    public void setRemoveDefaultEntries(boolean bl) {
        this.removeDefault = bl;
    }

    public int getDefaultEntryCount() {
        int n = 0;
        Vector vector = this.list.getItems();
        if (vector == null) {
            return 0;
        }
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            if (((String)vector.elementAt(n3)).equals(initialEntryText)) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public Vector getListVector() {
        return this.getItems();
    }

    public String[] getList() {
        String[] stringArray = null;
        Vector vector = this.getItems();
        int n = vector.size();
        if (n > 0) {
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
        }
        return stringArray;
    }

    public Vector getAddList() {
        this.calculateChangeLists();
        return this.lists[ADDLIST];
    }

    public Vector getDeleteList() {
        this.calculateChangeLists();
        return this.lists[DELETELIST];
    }

    static {
        CURLIST = 1;
        ADDLIST = 2;
        DELETELIST = 3;
        initialEntryText = "*New Buddy*";
    }
}

