/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import uiutil.DBFrame;

public class ProgressBar
extends Component {
    String fileName;
    long fileSize;
    long received;

    public ProgressBar(String string, long l) {
        this.fileName = string;
        this.fileSize = l;
    }

    public void update(long l) {
        this.received = l;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 60);
    }

    public Dimension getMinimumSize() {
        return new Dimension(250, 60);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (graphics != null) {
            graphics.drawString("File: " + this.fileName, 20, 10);
            graphics.drawString("Transferred: " + this.received + "  Total: " + this.fileSize, 20, 50);
            graphics.setColor(Color.gray);
            graphics.fillRect(15, 20, 200, 15);
            float f = (float)this.received / (float)this.fileSize;
            graphics.setColor(Color.blue);
            graphics.fillRect(15, 20, (int)(f * 200.0f), 15);
            graphics.setColor(Color.white);
            graphics.drawString(String.valueOf((int)(f * 100.0f)) + "%", 105, 32);
        }
    }

    public static void main(String[] stringArray) {
        DBFrame dBFrame = new DBFrame("File Transfer");
        ProgressBar progressBar = new ProgressBar("Test", 100L);
        dBFrame.add(progressBar);
        dBFrame.pack();
        dBFrame.show();
        int n = 1;
        while (n < 101) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            progressBar.update(n);
            ++n;
        }
    }
}

