/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.fileTransfer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import module.rendezvous.fileTransfer.FileTransfer;
import module.rendezvous.fileTransfer.FxferUI;
import snac.TLV;
import tool.icbm.RendezvousEvent;
import util.JUtil;

class ErrorPanel
extends Panel
implements ActionListener {
    private static final String[] errorMsg = new String[]{"REQUEST_UNSUPPORTED", "REQUEST_DENIED", "REQUEST_IGNORED", "BUSTED_PARAMETERS", "REQUEST_TIMED_OUT", "ONLINE_BUT_NOT_AVAILABLE"};
    Button okButton;
    FxferUI fxferUI;
    FileTransfer fileTransfer;

    public ErrorPanel(FileTransfer fileTransfer, FxferUI fxferUI, RendezvousEvent rendezvousEvent) {
        this.fxferUI = fxferUI;
        this.fileTransfer = fileTransfer;
        Panel panel = new Panel();
        this.okButton = new Button("OK");
        panel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add("South", panel);
        this.add("Center", new Label(this.getErrorMsg(rendezvousEvent)));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.fxferUI.dispose();
        }
    }

    private String getErrorMsg(RendezvousEvent rendezvousEvent) {
        rendezvousEvent.getCookie();
        TLV tLV = rendezvousEvent.getRendezvousParams();
        if (tLV == null) {
            return "Unknown: Null Parameter";
        }
        int n = 0;
        String string = null;
        int n2 = 0;
        while (n2 < 6) {
            if (tLV.tlvTypePresent(n2)) {
                n = n2;
                string = JUtil.bytesToHexString((byte[])tLV.getTlvData(n));
                break;
            }
            ++n2;
        }
        return errorMsg[n];
    }
}

