/*
 * Decompiled with CFR 0.152.
 */
package module.rendezvous.fileTransfer;

import java.io.IOException;
import util.InputBuffer;
import util.JUtil;
import util.OutputBuffer;

public class FtTLV {
    public static int SUBTYPE_SEND_FILE = 1;
    public static int SUBTYPE_SEND_DIR = 2;
    public static int SUBTYPE_GET_FILE = 17;
    public static int SUBTYPE_GET_LIST = 18;
    int subtype;
    int numFiles;
    long totalSize;
    String name;
    boolean valid;

    public FtTLV(int n, int n2, long l, String string) {
        this.subtype = n;
        this.numFiles = n2;
        this.totalSize = l;
        this.name = string;
    }

    byte[] getBytes() throws IOException {
        OutputBuffer outputBuffer = new OutputBuffer(32);
        try {
            outputBuffer.writeShort(this.subtype);
        }
        catch (IOException iOException) {
            System.out.println("Cannot write subtype.");
        }
        try {
            outputBuffer.writeShort(this.numFiles);
        }
        catch (IOException iOException) {
            System.out.println("Cannot write numFiles.");
        }
        try {
            outputBuffer.writeInt((int)this.totalSize);
        }
        catch (IOException iOException) {
            System.out.println("Cannot write totalSize.");
        }
        try {
            if (this.name != null) {
                outputBuffer.writeBytes(this.name);
                outputBuffer.writeInt(0);
            }
        }
        catch (IOException iOException) {
            System.out.println("Cannot write file name.");
        }
        System.out.println("FtTLV: out data = " + JUtil.bytesToHexString((byte[])outputBuffer.bytes()));
        return outputBuffer.bytes();
    }

    boolean isValid() {
        return this.valid;
    }

    FtTLV(byte[] byArray) {
        this.valid = true;
        InputBuffer inputBuffer = new InputBuffer(byArray);
        System.out.println("FtTLV: data = " + JUtil.bytesToHexString((byte[])byArray));
        try {
            this.subtype = inputBuffer.d.readUnsignedShort();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read subtype.");
            this.valid = false;
            this.subtype = 0;
        }
        try {
            this.numFiles = inputBuffer.d.readUnsignedShort();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read numFiles.");
            this.valid = false;
            this.numFiles = 0;
        }
        try {
            this.totalSize = inputBuffer.d.readInt();
        }
        catch (IOException iOException) {
            System.out.println("Cannot read totalSize.");
            this.valid = false;
            this.totalSize = 0L;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(10);
            byte by = inputBuffer.d.readByte();
            while (by > 0) {
                stringBuffer.append((char)by);
                by = inputBuffer.d.readByte();
            }
            this.name = stringBuffer.toString();
            return;
        }
        catch (IOException iOException) {
            System.out.println("Cannot read file name.");
            this.name = null;
            return;
        }
    }
}

