/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BuddyAttribute;
import component.BuddyGeneralProps;
import component.BuddyList;
import component.BuddyListProps;
import component.BuddyUI;
import component.BuddyWindowProps;
import component.FolderInfo;
import component.SetupUI;
import component.Tool;
import component.Tools;
import component.User;
import java.util.Vector;
import main.BOSCore;
import main.BuddyAPI;
import main.Nickname;
import main.Oscar;
import main.Permissions;
import uiutil.ChoiceUI;
import uiutil.ColorSelector;
import uiutil.PropertySheet;
import util.ItemChecker;
import util.JUtil;
import util.KeyBindings;
import util.Log;
import util.Timer;
import util.TimerListener;

public class BuddyCore
implements Tool,
BuddyAPI,
ItemChecker,
TimerListener {
    private static final String MODULE = "BuddyCore";
    public static final String MODULE_NAME = "tool.buddylist";
    private static final String[] UIPACK_NAMES = new String[]{"tool.buddylist"};
    private static final String DISPLAY_NAME = "Buddy List";
    private static int DEFAULT_MAX_BUDDIES = 10;
    private static int DEFAULT_MAX_WATCHERS = 10;
    private static int LOGIN_STATUS_ALARM = 1;
    private BOSCore bosCore;
    private Tools tools;
    private BuddyUI buddyUI;
    private boolean enabled = false;
    private int maxBuddies;
    private int maxWatchers;
    private KeyBindings buddyListsConfig;
    protected KeyBindings buddyListPrefs;
    protected BuddyList[] buddyLists;
    protected long Timeout = 60000L;
    private long logonTime;
    private BuddyAttribute buddyAttribute;
    public static String SOUND_LOGON = "loginSound";
    public static String SOUND_LOGOFF = "logoutSound";
    public static String SHOW_CLASS = "showClass";
    public static String SHOW_EVIL = "showEvil";
    public static String SHOW_IDLE_TIME = "showIdleTime";
    public static String SHOW_SIGNON_TIME = "showSignonTime";
    public static String BUDDY_LIST_KEY = "Buddy.List";
    public static String BUDDY_PREFS_KEY = "Buddy.Prefs";
    public static String FONT_NAME_KEY = "Buddy.font.name";
    public static String FONT_STYLE_KEY = "Buddy.font.style";
    public static String FONT_SIZE_KEY = "Buddy.font.size";
    public static String TEXT_FGCOLOR_KEY = "Buddy.textFgColor";
    public static String TEXT_BGCOLOR_KEY = "Buddy.textBgColor";
    public static String TEXT_DIMCOLOR_KEY = "Buddy.textDimColor";
    public static String WINDOW_X = "Buddy.windowX";
    public static String WINDOW_Y = "Buddy.windowY";
    public static String WINDOW_WIDTH = "Buddy.windowWidth";
    public static String WINDOW_HEIGHT = "Buddy.windowHeight";

    public BuddyCore(BOSCore bOSCore, Tools tools) {
        this.bosCore = bOSCore;
        this.tools = tools;
        tools.register(this.getModuleName(), this);
        this.buddyListsConfig = this.loadBuddyLists();
        this.buddyLists = this.getBuddyListsFromKeyBindings(this.buddyListsConfig);
        this.buddyListPrefs = this.loadPreferences();
        this.maxBuddies = DEFAULT_MAX_BUDDIES;
        this.maxWatchers = DEFAULT_MAX_WATCHERS;
        this.setBuddyAttribute();
    }

    public void addBuddies(Vector vector) {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = new String(((User)vector.elementAt((int)n)).name);
            ++n;
        }
        if (stringArray.length > 0) {
            this.bosCore.addBuddies(stringArray);
        }
    }

    public boolean buddyOnList(String string, User[] userArray) {
        boolean bl = false;
        if (userArray != null) {
            int n = 0;
            while (n < userArray.length) {
                if (userArray[n].status != 3 && Nickname.normalize(string).equals(userArray[n].name())) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public void deleteBuddies(Vector vector) {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = new String(((User)vector.elementAt((int)n)).name);
            ++n;
        }
        if (stringArray.length > 0) {
            this.bosCore.deleteBuddies(stringArray);
        }
    }

    private int[] getAllowedClasses(Permissions permissions) {
        int n = 0;
        if (permissions.permitDT) {
            ++n;
        }
        if (permissions.permitAdmin) {
            ++n;
        }
        if (permissions.permitAOLUser) {
            ++n;
        }
        if (permissions.permitOscarPayUser) {
            ++n;
        }
        if (permissions.permitOscarFreeUser) {
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        if (permissions.permitDT) {
            nArray[n++] = 0;
        }
        if (permissions.permitAdmin) {
            nArray[n++] = 4;
        }
        if (permissions.permitAOLUser) {
            nArray[n++] = 3;
        }
        if (permissions.permitOscarPayUser) {
            nArray[n++] = 2;
        }
        if (permissions.permitOscarFreeUser) {
            nArray[n++] = 1;
        }
        return nArray;
    }

    public Vector getBuddiesExcluded(Vector vector) {
        Vector vector2 = this.getAllBuddyNames();
        if (vector == null || vector2 == null) {
            return vector2;
        }
        int n = vector.size();
        int n2 = vector2.size();
        int n3 = 0;
        while (n3 < n) {
            String string = (String)vector.elementAt(n3);
            int n4 = 0;
            while (n4 < n2) {
                String string2 = (String)vector2.elementAt(n4);
                if (Nickname.normalize(string2).equals(Nickname.normalize(string))) {
                    vector2.removeElementAt(n4);
                    --n2;
                    --n4;
                }
                ++n4;
            }
            ++n3;
        }
        return vector2;
    }

    public Vector getBuddiesNotOnList(User[] userArray) {
        Vector<User> vector = new Vector<User>();
        User[] userArray2 = this.getAllBuddies();
        int n = 0;
        while (n < userArray.length) {
            if (!this.buddyOnList(userArray[n].name, userArray2)) {
                vector.addElement(userArray[n]);
            }
            ++n;
        }
        return vector;
    }

    public BuddyList[] getBuddyListsFromKeyBindings(KeyBindings keyBindings) {
        BuddyList[] buddyListArray = null;
        int n = keyBindings.size();
        buddyListArray = new BuddyList[n];
        int n2 = 0;
        while (n2 < n) {
            String string = keyBindings.getKeyAt(n2);
            KeyBindings keyBindings2 = keyBindings.getValuesAt(n2);
            buddyListArray[n2] = new BuddyList(string, keyBindings2);
            ++n2;
        }
        return buddyListArray;
    }

    public String getSelectedNickname() {
        return this.buddyUI.getSelectedNickname();
    }

    public BuddyUI getUI() {
        return this.buddyUI;
    }

    public boolean getValue(String string, boolean bl) {
        String string2 = this.buddyListPrefs.getValue(string);
        boolean bl2 = string2 != null ? string2.equalsIgnoreCase("true") : bl;
        return bl2;
    }

    private void putBuddyListsToKeyBindings(BuddyList[] buddyListArray, KeyBindings keyBindings) {
        int n = 0;
        while (n < buddyListArray.length) {
            if (buddyListArray[n].change == BuddyList.DELETED) {
                keyBindings.deleteKey(buddyListArray[n].oldName());
            } else {
                keyBindings.setValues(buddyListArray[n].oldName(), buddyListArray[n].toKeyBindings());
                if (buddyListArray[n].renamed()) {
                    KeyBindings keyBindings2 = keyBindings.getValues(buddyListArray[n].oldName());
                    keyBindings.deleteKey(buddyListArray[n].oldName());
                    keyBindings.setValues(buddyListArray[n].name(), keyBindings2);
                }
            }
            ++n;
        }
    }

    private void makePermissionsUpdate(Vector vector, int[] nArray) {
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < this.buddyLists.length) {
            this.buddyLists[n].makePermissionsUpdate(l, vector, nArray);
            ++n;
        }
    }

    private void initializeBuddyLists() {
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < this.buddyLists.length) {
            this.buddyLists[n].initialize(l);
            ++n;
        }
    }

    public KeyBindings loadBuddyLists() {
        return Oscar.config.getKeyBindingsOrAdd(BUDDY_LIST_KEY);
    }

    public KeyBindings loadPreferences() {
        return Oscar.config.getKeyBindingsOrAdd(BUDDY_PREFS_KEY);
    }

    public void markBuddiesOfflineByName(Vector vector) {
        int n = 0;
        while (n < this.buddyLists.length) {
            this.buddyLists[n].markBuddiesOfflineByName(vector);
            ++n;
        }
    }

    public void printBuddyLists() {
        int n = 0;
        while (n < this.buddyLists.length) {
            Log.log(MODULE, Log.DB0, "   " + this.buddyLists[n]);
            ++n;
        }
    }

    public void saveEditedBuddyList(String string, String string2, boolean bl, User[] userArray, User[] userArray2) {
        if (this.enabled && userArray != null) {
            this.addBuddies(this.getBuddiesNotOnList(userArray));
        }
        userArray2 = this.updateBuddyList(string, string2, bl, userArray, userArray2);
        this.putBuddyListsToKeyBindings(this.buddyLists, this.buddyListsConfig);
        Oscar.saveConfiguration();
        if (this.enabled && userArray2 != null) {
            this.deleteBuddies(this.getBuddiesNotOnList(userArray2));
        }
        if (this.enabled) {
            this.buddyUI.update();
        }
        this.clearBuddyListChanges();
    }

    public void saveEditedBuddyLists(String[] stringArray, String[] stringArray2, boolean[] blArray, Vector[] vectorArray, Vector[] vectorArray2) {
        int n = 0;
        while (n < stringArray.length) {
            this.saveEditedBuddyList(stringArray[n], stringArray2[n], blArray[n], User.toUsers(vectorArray[n]), User.toUsers(vectorArray2[n]));
            ++n;
        }
    }

    public boolean savePreferences() {
        this.markAllBuddiesChanged();
        if (this.enabled) {
            this.buddyUI.update();
        }
        this.clearBuddyListChanges();
        return Oscar.saveConfiguration();
    }

    private void clearBuddyListChanges() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.buddyLists.length) {
            if (this.buddyLists[n2].change != BuddyList.DELETED) {
                this.buddyLists[n2].clearChanges(this.Timeout);
            } else {
                ++n;
            }
            ++n2;
        }
        if (n > 0) {
            int n3 = this.buddyLists.length - n;
            BuddyList[] buddyListArray = new BuddyList[n3];
            n2 = 0;
            int n4 = 0;
            while (n2 < this.buddyLists.length && n4 < n3) {
                if (this.buddyLists[n2].change != BuddyList.DELETED) {
                    buddyListArray[n4++] = this.buddyLists[n2];
                }
                ++n2;
            }
            this.buddyLists = buddyListArray;
        }
    }

    private void markAllBuddiesChanged() {
        int n = 0;
        while (n < this.buddyLists.length) {
            this.buddyLists[n].markAllBuddiesChanged();
            ++n;
        }
    }

    private void markAllBuddiesOffline() {
        int n = 0;
        while (n < this.buddyLists.length) {
            this.buddyLists[n].markAllBuddiesOffline();
            ++n;
        }
    }

    private final void setBuddyAttribute() {
        int n = 12;
        this.buddyAttribute = new BuddyAttribute();
        String string = Oscar.config.getValue(FONT_NAME_KEY);
        if (string != null) {
            this.buddyAttribute.fontName = string;
        }
        if ((string = Oscar.config.getValue(FONT_STYLE_KEY)) != null) {
            this.buddyAttribute.fontStyle = string.equalsIgnoreCase("bold") ? 1 : (string.equalsIgnoreCase("italic") ? 2 : (string.equalsIgnoreCase("bold italic") ? 3 : 0));
        }
        if ((string = Oscar.config.getValue(FONT_SIZE_KEY)) != null) {
            n = Integer.parseInt(string);
        }
        if (n < 8 || n > 24) {
            n = 12;
        }
        this.buddyAttribute.fontSize = n;
        string = Oscar.config.getValue(TEXT_FGCOLOR_KEY);
        if (string != null) {
            this.buddyAttribute.textFgColor = ColorSelector.getColor(string);
        }
        if ((string = Oscar.config.getValue(TEXT_BGCOLOR_KEY)) != null) {
            this.buddyAttribute.textBgColor = ColorSelector.getColor(string);
        }
        if ((string = Oscar.config.getValue(TEXT_DIMCOLOR_KEY)) != null) {
            this.buddyAttribute.textDimColor = ColorSelector.getColor(string);
        }
    }

    public void attributeChanged() {
        if (this.buddyUI != null) {
            this.buddyUI.setBuddyAttribute(this.buddyAttribute);
        }
    }

    public BuddyAttribute getBuddyAttribute() {
        return this.buddyAttribute;
    }

    public User[] getAllBuddies() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.buddyLists.length) {
            n += this.buddyLists[n3].size();
            ++n3;
        }
        User[] userArray = new User[n];
        n3 = 0;
        while (n3 < this.buddyLists.length) {
            User[] userArray2 = this.buddyLists[n3].getBuddies();
            if (userArray2 != null) {
                int n4 = 0;
                while (n4 < userArray2.length) {
                    userArray[n2++] = userArray2[n4];
                    ++n4;
                }
            }
            ++n3;
        }
        return userArray;
    }

    public Vector getAllBuddyNames() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.buddyLists.length) {
            User[] userArray = this.buddyLists[n].getBuddies();
            if (userArray != null) {
                int n2 = 0;
                while (n2 < userArray.length) {
                    if (userArray[n2].status != 3) {
                        vector.addElement(userArray[n2].name());
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return vector;
    }

    public User[] getBuddies(String string) {
        BuddyList buddyList = this.getBuddyList(string);
        User[] userArray = null;
        if (buddyList != null) {
            userArray = buddyList.getBuddies();
        }
        return userArray;
    }

    public User getBuddy(String string) {
        User user = null;
        int n = 0;
        while (n < this.buddyLists.length) {
            user = this.buddyLists[n].getBuddy(string);
            if (user != null) {
                return user;
            }
            ++n;
        }
        return null;
    }

    public String[] getBuddyNames(String string) {
        BuddyList buddyList = this.getBuddyList(string);
        String[] stringArray = null;
        if (buddyList != null) {
            stringArray = buddyList.getBuddyNames();
        }
        return stringArray;
    }

    public Vector getBuddyVector(String string) {
        String[] stringArray = this.getBuddyNames(string);
        Vector<String> vector = null;
        if (stringArray != null && stringArray.length > 0) {
            vector = new Vector<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        return vector;
    }

    public BuddyList getBuddyList(String string) {
        BuddyList buddyList = null;
        if (this.buddyLists != null) {
            int n = 0;
            while (n < this.buddyLists.length) {
                if (this.buddyLists[n].name().equals(string)) {
                    buddyList = this.buddyLists[n];
                    break;
                }
                ++n;
            }
        }
        return buddyList;
    }

    public BuddyList[] getBuddyLists() {
        return this.buddyLists;
    }

    public void deleteBuddyList(String string) {
        BuddyList buddyList = this.getBuddyList(string);
        if (buddyList != null) {
            buddyList.change = BuddyList.DELETED;
            User[] userArray = buddyList.getBuddies();
            if (userArray != null) {
                int n = 0;
                while (n < userArray.length) {
                    userArray[n].markDeleted();
                    ++n;
                }
            }
        }
    }

    public String[] getBuddyListNames() {
        if (this.buddyLists == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.buddyLists.length) {
            if (this.buddyLists[n2].change != BuddyList.DELETED) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray = null;
        if (n > 0) {
            stringArray = new String[n];
            n2 = 0;
            int n3 = 0;
            while (n3 < n && n2 < this.buddyLists.length) {
                if (this.buddyLists[n2].change != BuddyList.DELETED) {
                    stringArray[n3++] = new String(this.buddyLists[n2].name());
                }
                ++n2;
            }
        }
        return stringArray;
    }

    public User[] updateBuddyList(String string, String string2, boolean bl, User[] userArray, User[] userArray2) {
        BuddyList buddyList = this.getBuddyList(string2);
        if (buddyList != null) {
            if (bl) {
                buddyList.change = BuddyList.DELETED;
                userArray2 = buddyList.getBuddies();
                if (userArray2 != null) {
                    int n = 0;
                    while (n < userArray2.length) {
                        userArray2[n].markDeleted();
                        ++n;
                    }
                }
            } else {
                if (string != null && !string.equals(string2)) {
                    buddyList.rename(string);
                }
                buddyList.addBuddies(userArray);
                buddyList.deleteBuddies(userArray2);
            }
        } else if (!bl) {
            BuddyList[] buddyListArray = new BuddyList[this.buddyLists.length + 1];
            int n = 0;
            while (n < this.buddyLists.length) {
                buddyListArray[n] = this.buddyLists[n];
                ++n;
            }
            buddyListArray[n] = new BuddyList(string);
            buddyListArray[n].addBuddies(userArray);
            this.buddyLists = buddyListArray;
        }
        return userArray2;
    }

    public void updateBuddyLists(Permissions permissions) {
        int[] nArray = this.getAllowedClasses(permissions);
        if (permissions.isPermit) {
            if (permissions.names != null && permissions.names.size() > 0) {
                this.makePermissionsUpdate(permissions.names, nArray);
                this.markBuddiesOfflineByName(this.getBuddiesExcluded(permissions.names));
            } else {
                Vector<String> vector = new Vector<String>(1);
                vector.addElement(Oscar.nickname);
                this.markBuddiesOfflineByName(this.getBuddiesExcluded(vector));
            }
        } else if (permissions.names != null && permissions.names.size() > 0) {
            this.markBuddiesOfflineByName(permissions.names);
            this.makePermissionsUpdate(this.getBuddiesExcluded(permissions.names), nArray);
        } else {
            this.makePermissionsUpdate(this.getAllBuddyNames(), nArray);
        }
        if (this.enabled) {
            this.buddyUI.update();
        }
        this.clearBuddyListChanges();
    }

    public void buddiesArrived(Nickname[] nicknameArray) {
        int n = 0;
        while (n < this.buddyLists.length) {
            this.buddyLists[n].buddiesArrived(nicknameArray, this.Timeout);
            ++n;
        }
        this.buddyUI.update();
        this.clearBuddyListChanges();
    }

    public void buddiesDeparted(Nickname[] nicknameArray) {
        int n = 0;
        while (n < this.buddyLists.length) {
            this.buddyLists[n].buddiesDeparted(nicknameArray, this.Timeout);
            ++n;
        }
        this.buddyUI.update();
        this.clearBuddyListChanges();
    }

    public String[] getBuddyList() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.buddyLists.length) {
            n += this.buddyLists[n2].size();
            ++n2;
        }
        String[] stringArray = new String[n];
        n2 = 0;
        int n3 = 0;
        while (n2 < this.buddyLists.length) {
            User[] userArray = this.buddyLists[n2].getBuddies();
            int n4 = 0;
            while (n4 < userArray.length && n3 < n) {
                stringArray[n3] = new String(userArray[n4].name);
                ++n4;
                ++n3;
            }
            ++n2;
        }
        return stringArray;
    }

    public void setMaxBuddies(int n) {
        this.maxBuddies = n;
    }

    public void connect() {
    }

    public void disconnect() {
        this.markAllBuddiesOffline();
        this.buddyUI.update();
        this.clearBuddyListChanges();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void service() {
    }

    public void updateRate() {
    }

    public void updateUserEvil(String string, int n) {
        int n2 = 0;
        while (n2 < this.buddyLists.length) {
            this.buddyLists[n2].updateBuddyEvil(string, n);
            ++n2;
        }
        this.buddyUI.update();
        this.clearBuddyListChanges();
    }

    public void updateUserInfo(Nickname nickname) {
        String string = Nickname.normalize(nickname.nickname);
        if (string != null && string.equals(Nickname.normalize(Oscar.nickname))) {
            int n = 0;
            while (n < this.buddyLists.length) {
                this.buddyLists[n].updateBuddyInfo(nickname);
                ++n;
            }
        }
        this.buddyUI.update();
        this.clearBuddyListChanges();
    }

    public boolean validItem(String string, boolean bl) {
        boolean bl2 = true;
        if (Oscar.validateNickname(string) == null) {
            if (bl) {
                ChoiceUI.newChoiceUI("Invalid Buddy Name", "You entered \"" + string + "\" which is not a valid " + "name for a buddy. Make sure you use only letters, " + "numbers and spaces for buddy names and that each " + "name is at least 3 non-space characters in length.", Oscar.WARNING_SOUND);
            }
            bl2 = false;
        }
        return bl2;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String[] getUIPackNames() {
        return UIPACK_NAMES;
    }

    public int id() {
        return 1;
    }

    public int version() {
        return 1;
    }

    public FolderInfo[] configure(SetupUI setupUI) {
        FolderInfo[] folderInfoArray = new FolderInfo[]{new FolderInfo(this, 0, this.getDisplayName(), "List"), new FolderInfo(this, 1, this.getDisplayName(), "General"), new FolderInfo(this, 2, this.getDisplayName(), "Visual")};
        return folderInfoArray;
    }

    public PropertySheet getPropertySheet(FolderInfo folderInfo, SetupUI setupUI) {
        switch (folderInfo.getFolderId()) {
            case 0: {
                return new BuddyListProps(this, setupUI);
            }
            case 1: {
                return new BuddyGeneralProps(this, setupUI);
            }
            case 2: {
                return new BuddyWindowProps(this, setupUI);
            }
        }
        return null;
    }

    public void exportProperties(KeyBindings keyBindings, KeyBindings keyBindings2) {
        String string;
        KeyBindings keyBindings3;
        int n;
        Object object;
        KeyBindings keyBindings4 = keyBindings2.getValues(BUDDY_LIST_KEY);
        if (this.buddyLists.length > 0 && keyBindings4 != null && keyBindings4.size() > 0) {
            object = new BuddyList[keyBindings4.size()];
            n = 0;
            int n2 = 0;
            while (n2 < this.buddyLists.length) {
                if (keyBindings4.contains(this.buddyLists[n2].name())) {
                    object[n++] = this.buddyLists[n2];
                }
                ++n2;
            }
            keyBindings3 = keyBindings.addKeyBindings(BUDDY_LIST_KEY);
            this.putBuddyListsToKeyBindings((BuddyList[])object, keyBindings3);
        }
        if ((string = keyBindings2.getValue(BUDDY_PREFS_KEY)) != null && JUtil.isTrue(string) && this.buddyListPrefs != null) {
            keyBindings3 = keyBindings.addKeyBindings(BUDDY_PREFS_KEY);
            n = 0;
            while (n < this.buddyListPrefs.size()) {
                object = this.buddyListPrefs.getKeyAt(n);
                string = this.buddyListPrefs.getValue((String)object);
                if (string != null && string.length() > 0) {
                    keyBindings3.setValue((String)object, string);
                }
                ++n;
            }
        }
    }

    public void importProperties(KeyBindings keyBindings, KeyBindings keyBindings2, KeyBindings keyBindings3, boolean bl) {
        int n;
        Object object;
        KeyBindings keyBindings4;
        KeyBindings keyBindings5 = null;
        new Vector();
        KeyBindings keyBindings6 = Oscar.config.getKeyBindings(BUDDY_LIST_KEY);
        if (!bl && keyBindings6 != null) {
            keyBindings2.setValues(BUDDY_LIST_KEY, keyBindings6);
        }
        keyBindings6 = Oscar.config.getKeyBindings(BUDDY_PREFS_KEY);
        if (!bl && keyBindings6 != null) {
            keyBindings2.setValues(BUDDY_PREFS_KEY, keyBindings6);
        }
        if ((keyBindings4 = keyBindings.getKeyBindings(BUDDY_LIST_KEY)) == null) {
            return;
        }
        BuddyList[] buddyListArray = this.getBuddyListsFromKeyBindings(keyBindings4);
        keyBindings6 = keyBindings3.getKeyBindings(BUDDY_LIST_KEY);
        if (buddyListArray.length > 0 && keyBindings6 != null && keyBindings6.size() > 0) {
            object = new BuddyList[keyBindings6.size()];
            int n2 = 0;
            n = 0;
            while (n < buddyListArray.length) {
                if (keyBindings6.contains(buddyListArray[n].name())) {
                    object[n2++] = buddyListArray[n];
                }
                ++n;
            }
            keyBindings5 = keyBindings2.addKeyBindings(BUDDY_LIST_KEY);
            this.putBuddyListsToKeyBindings((BuddyList[])object, keyBindings5);
        }
        object = keyBindings3.getValue(BUDDY_PREFS_KEY);
        keyBindings4 = keyBindings.getKeyBindings(BUDDY_PREFS_KEY);
        if ((object == null || JUtil.isTrue((String)object)) && keyBindings4 != null) {
            n = 0;
            while (n < keyBindings4.size()) {
                String string = keyBindings4.getKeyAt(n);
                keyBindings5 = keyBindings2.addKeyBindings(BUDDY_PREFS_KEY);
                object = keyBindings4.getValue(string);
                if (object != null && ((String)object).length() > 0) {
                    keyBindings5.setValue(string, (String)object);
                }
                ++n;
            }
        }
    }

    public boolean initiate(Vector vector, KeyBindings keyBindings) {
        this.logonTime = System.currentTimeMillis();
        if (this.buddyUI == null) {
            this.buddyUI = new BuddyUI(this, this.tools);
            this.buddyUI.setBuddyAttribute(this.buddyAttribute);
        }
        this.initializeBuddyLists();
        this.buddyUI.update();
        this.clearBuddyListChanges();
        this.setLoginStatusAlarm();
        return true;
    }

    public void shutdown() {
        Log.log(MODULE, Log.INFO, "got shutdown.");
    }

    private boolean doTimeout(User user, long l) {
        boolean bl = false;
        if ((user.status == 1 || user.status == 0) && l - user.logTime > this.Timeout && l - user.logTime <= 2L * this.Timeout) {
            bl = true;
        }
        return bl;
    }

    private void setLoginStatusAlarm() {
        Timer.createEvent("System", this, LOGIN_STATUS_ALARM, null, (int)this.Timeout);
    }

    public void timerEvent(String string, int n, Object object) {
        if (n == LOGIN_STATUS_ALARM) {
            this.timeoutLoginStatus();
        }
    }

    private void timeoutLoginStatus() {
        long l = System.currentTimeMillis();
        int n = 0;
        while (n < this.buddyLists.length) {
            User[] userArray = this.buddyLists[n].getBuddies();
            if (userArray != null) {
                int n2 = 0;
                while (n2 < userArray.length) {
                    if (this.doTimeout(userArray[n2], l)) {
                        userArray[n2].changed = true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        this.buddyUI.update();
        this.setLoginStatusAlarm();
    }
}

