/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.ChatProtoTool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import main.Nickname;
import main.Oscar;
import uiutil.ErrorMgr;
import uiutil.OFrame;
import uiutil.Spacer;
import util.Log;
import util.Timer;
import util.TimerListener;

class ChatProtoRoomUI
extends OFrame
implements ActionListener,
ItemListener,
TimerListener,
WindowListener {
    private static final String MODULE = "ChatProtoRoomUI";
    private static final String OCCUPANT_TEXT = " Occupant(s)";
    private static final String WHISPER_HINT = "Whisper by first selecting a name from the Occupants list.";
    private static final String EVIL_HINT = " Select a name.";
    private static final String OSCAR_HOST = "OscarHost";
    private static final String LABEL_PLACEHOLDER = "MMMMMM";
    private static final String LABEL_BLANK = "---";
    private static final int TEXT_ROWS = 17;
    private static final int TEXT_COLS = 45;
    private static final int ARRIVAL_TIMEOUT = 5000;
    private ChatProtoTool chatTool;
    private Tools tools;
    private Object room;
    private String name;
    private Button sayButton;
    private Button whisperButton;
    private Label whisperLabel;
    private Button evilButton;
    private Label evilLabel;
    private Checkbox evilCheck;
    private TextField chatInput;
    private TextArea chatDialog;
    private Label occupantLabel;
    private List occupantList;
    private String lastSelectedName = "";
    private Label occupantEvilLabel;
    private Label evilGeneratedLabel;
    private Label roomActivityLabel;
    private Label roomGrossEvilLabel;
    private Label roomNetEvilLabel;
    private boolean enabled = false;
    private boolean justConnected = false;

    public ChatProtoRoomUI(Object object, ChatProtoTool chatProtoTool, Tools tools, String string) {
        this.room = object;
        this.chatTool = chatProtoTool;
        this.tools = tools;
        this.name = string;
        this.setTitle(string);
        ((Component)this).setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        this.add("Center", panel);
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel.add("Center", panel2);
        panel2.setLayout(new BorderLayout());
        this.chatDialog = new TextArea(17, 45);
        panel2.add("Center", this.chatDialog);
        Panel panel3 = new Panel();
        panel2.add("South", panel3);
        panel3.setLayout(new BorderLayout());
        Panel panel4 = new Panel();
        panel3.add("North", panel4);
        this.chatInput = new TextField(45);
        panel4.add(this.chatInput);
        this.chatInput.addActionListener(this);
        this.sayButton = new Button(" Say ");
        panel4.add(this.sayButton);
        this.sayButton.addActionListener(this);
        panel4 = new Panel();
        panel3.add("South", panel4);
        panel4.setLayout(new FlowLayout(0));
        this.whisperButton = new Button("Whisper");
        panel4.add(this.whisperButton);
        this.whisperLabel = new Label(WHISPER_HINT);
        panel4.add(this.whisperLabel);
        this.whisperButton.addActionListener(this);
        panel2 = new Panel();
        panel.add("East", panel2);
        panel2.setLayout(new BorderLayout());
        panel2.add("West", new Spacer());
        panel2.add("East", new Spacer());
        panel3 = new Panel();
        panel2.add("Center", panel3);
        panel3.setLayout(new BorderLayout());
        panel4 = new Panel();
        panel3.add("North", panel4);
        panel4.setLayout(new BorderLayout());
        panel4.add("North", new Label("<<< Ad Placeholder >>>", 1));
        this.occupantLabel = new Label(String.valueOf(0) + OCCUPANT_TEXT);
        panel4.add("South", this.occupantLabel);
        panel4 = new Panel();
        panel3.add("Center", panel4);
        panel4.setLayout(new BorderLayout());
        this.occupantList = new List(6);
        panel4.add("North", this.occupantList);
        this.occupantList.addItemListener(this);
        Panel panel5 = new Panel();
        panel4.add("Center", panel5);
        panel5.setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel6 = new Panel();
        panel5.add(panel6);
        panel6.setLayout(new FlowLayout(0, 0, 0));
        this.evilButton = new Button("Warn:");
        panel6.add(this.evilButton);
        this.evilButton.addActionListener(this);
        this.evilLabel = new Label(EVIL_HINT);
        panel6.add(this.evilLabel);
        this.evilCheck = new Checkbox("Anonymous Warning", false);
        panel5.add(this.evilCheck);
        panel6 = new Panel();
        panel5.add(panel6);
        panel6.setLayout(new FlowLayout(0, 0, 0));
        panel6.add(new Label("Occupant Evil:"));
        this.occupantEvilLabel = new Label(LABEL_PLACEHOLDER);
        panel6.add(this.occupantEvilLabel);
        panel6 = new Panel();
        panel5.add(panel6);
        panel6.setLayout(new FlowLayout(0, 0, 0));
        panel6.add(new Label("Evil Generated:"));
        this.evilGeneratedLabel = new Label(LABEL_PLACEHOLDER);
        panel6.add(this.evilGeneratedLabel);
        panel6 = new Panel();
        panel5.add(panel6);
        panel6.setLayout(new FlowLayout(0, 0, 0));
        panel6.add(new Label("Room Activity:"));
        this.roomActivityLabel = new Label(LABEL_PLACEHOLDER);
        panel6.add(this.roomActivityLabel);
        panel6 = new Panel();
        panel5.add(panel6);
        panel6.setLayout(new FlowLayout(0, 0, 0));
        panel6.add(new Label("Room Gross Evil:"));
        this.roomGrossEvilLabel = new Label(LABEL_PLACEHOLDER);
        panel6.add(this.roomGrossEvilLabel);
        panel6 = new Panel();
        panel5.add(panel6);
        panel6.setLayout(new FlowLayout(0, 0, 0));
        panel6.add(new Label("Room Net Evil:"));
        this.roomNetEvilLabel = new Label(LABEL_PLACEHOLDER);
        panel6.add(this.roomNetEvilLabel);
        panel5.add(new Spacer());
        panel5.add(new Spacer());
        panel5.add(new Spacer());
        this.pack();
        this.occupantEvilLabel.setText(LABEL_BLANK);
        this.evilGeneratedLabel.setText(LABEL_BLANK);
        this.roomActivityLabel.setText(LABEL_BLANK);
        this.roomGrossEvilLabel.setText(LABEL_BLANK);
        this.roomNetEvilLabel.setText(LABEL_BLANK);
        this.addWindowListener(this);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.sayButton) || object.equals(this.chatInput)) {
            this.sayAction();
            return;
        }
        if (object.equals(this.whisperButton)) {
            this.whisperAction();
            return;
        }
        if (object.equals(this.evilButton)) {
            this.evilAction();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.occupantList)) {
            String string = this.occupantList.getSelectedItem();
            if (string == null || string.equals(this.lastSelectedName)) {
                this.occupantList.deselect(this.occupantList.getSelectedIndex());
                this.lastSelectedName = "";
                this.whisperButton.setEnabled(false);
                this.whisperLabel.setText(WHISPER_HINT);
                this.evilButton.setEnabled(false);
                this.evilLabel.setText(EVIL_HINT);
                this.evilCheck.setEnabled(false);
                return;
            }
            this.whisperButton.setEnabled(true);
            this.whisperLabel.setText("To: " + string);
            this.evilButton.setEnabled(true);
            this.evilLabel.setText(" " + string);
            this.evilCheck.setEnabled(true);
            this.lastSelectedName = new String(string);
        }
    }

    private void leaveRoom() {
        ((Component)this).setVisible(false);
        this.chatTool.leaveRoom(this.room);
        this.dispose();
    }

    public void receiveMessage(String string, String string2, boolean bl, boolean bl2) {
        Log.log(MODULE, Log.DEBUG, "receiveMessage: received " + string2);
        String string3 = "";
        if (bl) {
            string3 = String.valueOf(string3) + " Whispers";
        }
        if (bl2) {
            string3 = String.valueOf(string3) + " (auto)";
        }
        this.chatDialog.append(String.valueOf(string) + string3 + ":\t" + string2 + "\n");
    }

    public void evilAction() {
        String string = this.occupantList.getSelectedItem();
        if (string == null || string.length() == 0) {
            ErrorMgr.warn(MODULE, "Please indicate who to warn.");
            return;
        }
        this.chatTool.evilRequest(this.room, string, this.chatTool.MAX_EVIL, this.evilCheck.getState());
    }

    public void sayAction() {
        String string = this.chatInput.getText();
        if (string == null || string.length() == 0) {
            ErrorMgr.warn(MODULE, "Please enter something to say.");
            return;
        }
        Log.log(MODULE, Log.DEBUG, "sayAction: sending " + string);
        this.chatTool.sendChannelMessage(this.room, 1, null, string.getBytes(), false, false);
        ((TextComponent)this.chatInput).setText("");
    }

    public void whisperAction() {
        String string = this.occupantList.getSelectedItem();
        String string2 = this.chatInput.getText();
        if (string2 == null || string2.length() == 0) {
            ErrorMgr.warn(MODULE, "Please enter something to say.");
            return;
        }
        if (string == null || string.length() == 0) {
            ErrorMgr.warn(MODULE, "Please indicate who to whisper to.");
            return;
        }
        Log.log(MODULE, Log.DEBUG, "whisperAction: sending " + string2);
        this.chatTool.sendChannelMessage(this.room, 1, string, string2.getBytes(), true, false);
        ((TextComponent)this.chatInput).setText("");
        this.chatDialog.append("You Whisper to " + string + ":\t" + string2 + "\n");
    }

    public void setEnabled(boolean bl) {
        if (!this.enabled && bl) {
            this.justConnected = true;
            Timer.createEvent("System", this, 0, null, 5000);
        }
        this.enabled = bl;
        this.chatInput.setEnabled(bl);
        this.sayButton.setEnabled(bl);
        this.whisperButton.setEnabled(false);
        this.evilButton.setEnabled(false);
        this.evilCheck.setEnabled(false);
        if (bl) {
            if (this.occupantList.getSelectedItem() != null) {
                this.whisperButton.setEnabled(true);
                this.evilButton.setEnabled(true);
                this.evilCheck.setEnabled(true);
            }
            ((Component)this).setCursor(Cursor.getDefaultCursor());
            String string = "\nOscarHost:\nOscarHost:\t*** You are in \"" + this.name + "\". ***\n" + OSCAR_HOST + ":\n";
            this.chatDialog.append(string);
            return;
        }
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
    }

    public void timerEvent(String string, int n, Object object) {
        this.justConnected = false;
    }

    public void updateRoomInfo(String string, Integer n, Integer n2, Integer n3, Integer n4, Integer n5) {
        Log.log(MODULE, Log.DEBUG, "updateRoomInfo: for room " + this.name);
        this.name = new String(string);
        this.setTitle(this.name);
        if (n != null) {
            this.occupantEvilLabel.setText(n.toString());
        }
        if (n2 != null) {
            this.evilGeneratedLabel.setText(n2.toString());
        }
        if (n3 != null) {
            this.roomActivityLabel.setText(n3.toString());
        }
        if (n4 != null) {
            this.roomGrossEvilLabel.setText(n4.toString());
        }
        if (n5 != null) {
            this.roomNetEvilLabel.setText(n5.toString());
        }
    }

    public void usersJoined(Nickname[] nicknameArray) {
        Log.log(MODULE, Log.DEBUG, "usersJoined: " + nicknameArray.length);
        if (nicknameArray != null && nicknameArray.length > 0) {
            String[] stringArray = this.occupantList.getItems();
            int n = 0;
            while (n < nicknameArray.length) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (nicknameArray[n].nickname.equals(stringArray[n2])) {
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) {
                    Log.log(MODULE, Log.DEBUG, "usersJoined: adding " + nicknameArray[n].nickname);
                    this.occupantList.add(nicknameArray[n].nickname);
                    if (!this.justConnected) {
                        this.chatDialog.append("OscarHost:\t" + nicknameArray[n].nickname + " has arrived!\n");
                    }
                }
                ++n;
            }
            this.occupantLabel.setText(String.valueOf(this.occupantList.getItemCount()) + OCCUPANT_TEXT);
        }
    }

    public void usersLeft(Nickname[] nicknameArray) {
        Log.log(MODULE, Log.DEBUG, "usersLeft: " + nicknameArray.length);
        if (nicknameArray != null && nicknameArray.length > 0) {
            int n = 0;
            while (n < nicknameArray.length) {
                Log.log(MODULE, Log.DEBUG, "usersLeft: removing user[" + n + "]=" + nicknameArray[n].nickname);
                try {
                    this.occupantList.remove(nicknameArray[n].nickname);
                    this.chatDialog.append("OscarHost:\t" + nicknameArray[n].nickname + " has left.\n");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++n;
            }
            this.occupantLabel.setText(String.valueOf(this.occupantList.getItemCount()) + OCCUPANT_TEXT);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.leaveRoom();
    }
}

