/*
 * Decompiled with CFR 0.152.
 */
package main;

import flap.FLAPSock;
import java.io.IOException;
import main.ClientDispatcher;
import main.GenericFLAPSockHandler;
import main.Oscar;
import main.UIAPI;
import snac.TLV;
import uiutil.ErrorMgr;
import util.JUtil;

class GenericFLAPSockOpener
extends GenericFLAPSockHandler {
    private String name;
    private UIAPI ui;
    private ClientDispatcher dispatcher;
    private byte[] cookie;

    GenericFLAPSockOpener(String string, UIAPI uIAPI, String string2, int n, byte[] byArray, ClientDispatcher clientDispatcher) {
        this.name = string;
        this.ui = uIAPI;
        this.cookie = byArray;
        this.dispatcher = clientDispatcher;
        try {
            new FLAPSock(this, string, string2, n, Oscar.connector);
            return;
        }
        catch (IOException iOException) {
            uIAPI.disconnect();
            return;
        }
    }

    public void FLAPConnectionEstablished(FLAPSock fLAPSock) {
        super.FLAPConnectionEstablished(fLAPSock);
        TLV tLV = new TLV();
        tLV.addTlv(6, this.cookie);
        fLAPSock.sendSignOn(tLV);
    }

    public void FLAPConnectionFailed(FLAPSock fLAPSock) {
        super.FLAPConnectionFailed(fLAPSock);
        this.ui.disconnect();
    }

    public void FLAPSignOn(FLAPSock fLAPSock, TLV tLV) {
        super.FLAPSignOn(fLAPSock, tLV);
        this.dispatcher.takeoverFLAP(fLAPSock);
        this.ui.connect();
    }

    public void FLAPSignOnTimeout(FLAPSock fLAPSock) {
        super.FLAPSignOnTimeout(fLAPSock);
        this.ui.disconnect();
    }

    public void FLAPData(FLAPSock fLAPSock, byte[] byArray) {
        super.FLAPData(fLAPSock, byArray);
        ErrorMgr.error(this.name, "unexpected FLAP data " + JUtil.toHexString(byArray));
        this.ui.disconnect();
        fLAPSock.close();
    }

    public void FLAPDataOrSignOffTimeout(FLAPSock fLAPSock) {
        super.FLAPDataOrSignOffTimeout(fLAPSock);
        this.ui.disconnect();
    }

    public void FLAPError(FLAPSock fLAPSock, int n, String string) {
        super.FLAPError(fLAPSock, n, string);
    }

    public void FLAPSignOff(FLAPSock fLAPSock, TLV tLV) {
        super.FLAPSignOff(fLAPSock, tLV);
        this.ui.disconnect();
    }

    public void FLAPConnectionClosed(FLAPSock fLAPSock, boolean bl, String string, int n) {
        super.FLAPConnectionClosed(fLAPSock, bl, string, n);
        this.ui.disconnect();
    }
}

