/*
 * Decompiled with CFR 0.152.
 */
package main;

import component.AdminTool;
import component.AdminUIListener;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import main.LoginCore;
import main.Oscar;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.PasswordField;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.JUtil;
import util.KeyBindings;
import util.RefRegistry;

public class PersonalProps
extends PropertySheet
implements ActionListener,
AdminUIListener,
KeyListener,
MouseListener {
    private Tools tools;
    private LoginCore login;
    private AdminTool admin;
    private ChangeListener changeListener;
    private Label changeLabel;
    private Label nicknameLabel;
    private TextField nicknameField;
    private Button nicknameButton;
    private Label passwordLabel;
    private TextField passwordField;
    private Button passwordButton;
    private Label emailLabel;
    private TextField emailField;
    private Button emailButton;
    private TextField saveNicknameField;
    private PasswordField savePasswordField;
    private boolean changed = false;

    public PersonalProps(Tools tools, LoginCore loginCore, ChangeListener changeListener) {
        this.tools = tools;
        this.login = loginCore;
        this.admin = (AdminTool)tools.get("tool.admin");
        this.admin.addAdminUIListener(this);
        this.changeListener = changeListener;
        this.setLayout(new BorderLayout());
        this.add("North", new Spacer());
        this.add("East", new Spacer());
        this.add("West", new Spacer());
        TransparentPanel transparentPanel = new TransparentPanel();
        this.add("Center", transparentPanel);
        transparentPanel.setLayout(new GridLayout(0, 1));
        transparentPanel.add(new Label("Save this nickname and password for login", 0));
        TransparentPanel transparentPanel2 = new TransparentPanel(new FlowLayout(2, 5, 0));
        transparentPanel.add(transparentPanel2);
        transparentPanel2.add(new Label("Nickname: ", 2));
        this.saveNicknameField = new TextField(23);
        transparentPanel2.add(this.saveNicknameField);
        this.saveNicknameField.addKeyListener(this);
        transparentPanel2 = new TransparentPanel(new FlowLayout(2, 5, 0));
        transparentPanel.add(transparentPanel2);
        transparentPanel2.add(new Label("Password: ", 2));
        this.savePasswordField = new PasswordField(23);
        transparentPanel2.add(this.savePasswordField);
        this.savePasswordField.setEchoChar('*');
        this.savePasswordField.addKeyListener(this);
        transparentPanel.add(new Spacer());
        this.changeLabel = new Label("Change personal information", 0);
        transparentPanel.add(this.changeLabel);
        transparentPanel2 = new TransparentPanel(new FlowLayout(2, 5, 0));
        transparentPanel.add(transparentPanel2);
        this.nicknameButton = new Button("Nickname...");
        transparentPanel2.add(this.nicknameButton);
        this.nicknameButton.addActionListener(this);
        this.nicknameField = new TextField(23);
        transparentPanel2.add(this.nicknameField);
        this.nicknameField.setEditable(false);
        this.nicknameField.addKeyListener(this);
        this.nicknameField.addMouseListener(this);
        transparentPanel2 = new TransparentPanel(new FlowLayout(2, 5, 0));
        transparentPanel.add(transparentPanel2);
        this.passwordButton = new Button("Password...");
        transparentPanel2.add(this.passwordButton);
        this.passwordButton.addActionListener(this);
        this.passwordField = new TextField(23);
        transparentPanel2.add(this.passwordField);
        this.passwordField.setEditable(false);
        this.passwordField.addKeyListener(this);
        this.passwordField.addMouseListener(this);
        transparentPanel2 = new TransparentPanel(new FlowLayout(2, 5, 0));
        transparentPanel.add(transparentPanel2);
        this.emailButton = new Button("Email...");
        transparentPanel2.add(this.emailButton);
        this.emailButton.addActionListener(this);
        this.emailField = new TextField(23);
        transparentPanel2.add(this.emailField);
        this.emailField.setEditable(false);
        this.emailField.addKeyListener(this);
        this.emailField.addMouseListener(this);
        transparentPanel.add(new Spacer());
        this.updateOnlineInfo();
        RefRegistry.register(this);
    }

    public void updateOnlineInfo() {
        boolean bl = Oscar.mainTool.getEnabled();
        if (bl) {
            this.changeLabel.setText("Change personal information");
        } else {
            this.changeLabel.setText("Change personal info (You must be online)");
        }
        this.nicknameButton.setEnabled(bl);
        this.nicknameField.setEnabled(bl);
        this.passwordButton.setEnabled(bl);
        this.passwordField.setEnabled(bl);
        this.emailButton.setEnabled(bl);
        this.emailField.setEnabled(bl);
        this.setValues();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.nicknameButton)) {
            this.admin.showUI(0, this.nicknameField.getText());
            return;
        }
        if (object.equals(this.passwordButton)) {
            this.admin.showUI(1, null);
            return;
        }
        if (object.equals(this.emailButton)) {
            this.admin.showUI(2, this.emailField.getText());
        }
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Personal Information Help", "This folder is where you change personal information. Use the buttons to change your password, email address and appearance of your nickname. Use the text areas to save your name and password for automatic login. You must be connected to the service in order to change your password, email address or nickname. If you are not connected, these buttons will be disabled.");
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            Component component = keyEvent.getComponent();
            if (component == this.nicknameField) {
                this.admin.showUI(0, this.nicknameField.getText());
            } else if (component == this.passwordField) {
                this.admin.showUI(1, null);
            } else if (component == this.emailField) {
                this.admin.showUI(2, this.emailField.getText());
            } else if (component == this.saveNicknameField) {
                this.savePasswordField.requestFocus();
            }
        }
        this.setChanged(true);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this.nicknameField) {
            this.admin.showUI(0, this.nicknameField.getText());
            return;
        }
        if (component == this.passwordField) {
            this.admin.showUI(1, null);
            return;
        }
        if (component == this.emailField) {
            this.admin.showUI(2, this.emailField.getText());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void removeNotify() {
        RefRegistry.remove(this);
        this.removeAll();
        this.tools = null;
        this.login = null;
        if (this.admin != null) {
            this.admin.removeAdminUIListener(this);
            this.admin = null;
        }
        this.changeListener = null;
        this.changeLabel = null;
        this.nicknameLabel = null;
        this.nicknameField = null;
        this.nicknameButton = null;
        this.passwordLabel = null;
        this.passwordField = null;
        this.passwordButton = null;
        this.emailLabel = null;
        this.emailField = null;
        this.emailButton = null;
        this.saveNicknameField = null;
        this.savePasswordField = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public boolean save() {
        KeyBindings keyBindings = Oscar.config.getKeyBindingsOrAdd(LoginCore.LOGIN_KEY);
        String string = this.saveNicknameField.getText();
        if (string != null && string.length() > 0) {
            keyBindings.setValue(LoginCore.NICKNAME_KEY, string);
        } else {
            keyBindings.deleteKey(LoginCore.NICKNAME_KEY);
        }
        String string2 = this.savePasswordField.getPassword();
        if (string2 != null && string2.length() > 0) {
            JUtil.putPassword(keyBindings, string2, LoginCore.PASSWORD_KEY);
        } else {
            keyBindings.deleteKey(LoginCore.PASSWORD_KEY);
        }
        this.login.setNameAndPassword(string, string2);
        this.setChanged(false);
        return true;
    }

    private void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    public void setValues() {
        KeyBindings keyBindings = Oscar.config.getKeyBindingsOrAdd(LoginCore.LOGIN_KEY);
        String string = keyBindings.getValue(LoginCore.NICKNAME_KEY);
        String string2 = JUtil.getPassword(keyBindings, LoginCore.PASSWORD_KEY);
        if (string != null) {
            ((TextComponent)this.saveNicknameField).setText(string);
        }
        if (string2 != null) {
            this.savePasswordField.setPassword(string2);
        }
        if (Oscar.mainTool.getEnabled()) {
            ((TextComponent)this.nicknameField).setText(Oscar.nickname);
            ((TextComponent)this.passwordField).setText("**********");
            if (this.admin.timeToUpdateEmailAddress()) {
                ((TextComponent)this.emailField).setText(AdminTool.REQUESTING_STRING);
                this.admin.requestEmailAddress();
            } else {
                ((TextComponent)this.emailField).setText(Oscar.emailAddress);
            }
        }
        this.setChanged(false);
    }

    public void setNickname(String string) {
        ((TextComponent)this.nicknameField).setText(string);
    }

    public void setEmailAddress(String string) {
        ((TextComponent)this.emailField).setText(string);
    }

    public void setRegistrationStatus(int n) {
    }

    public void error(int n, String string, String string2) {
        if (n == 2) {
            ((TextComponent)this.emailField).setText("(Address Unavailable)");
        }
    }

    public void changeSuccessful(int n, Object object) {
        if (n == 0) {
            ((TextComponent)this.nicknameField).setText((String)object);
            String string = this.saveNicknameField.getText();
            if (string != null && string.length() > 0) {
                String string2 = (String)object;
                ((TextComponent)this.saveNicknameField).setText(string2);
                if (string2 != null && string2.length() > 0) {
                    Oscar.config.setValue(String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.NICKNAME_KEY, string2);
                    Oscar.saveConfiguration();
                }
                this.login.setNameAndPassword(string2, JUtil.getPassword(Oscar.config, String.valueOf(LoginCore.LOGIN_KEY) + "." + LoginCore.PASSWORD_KEY));
            }
        }
    }

    public void changeFailed(int n, String string, String string2) {
    }
}

