/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.ChatNavHostListener;
import snac.ChatRoomDesc;
import snac.ChatRoomID;
import snac.ChatRoomIDWDetail;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class ChatNavHostHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public ChatNavHostHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(13, 1, this);
    }

    private void decodeRequestChatRights(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatNavRequestChatRights SNAC");
        ChatNavHostListener chatNavHostListener = (ChatNavHostListener)listener;
        int n = this.initHandledState();
        if (chatNavHostListener != null) {
            n = this.updateHandledState(n, chatNavHostListener.chatNavRequestChatRights(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            ChatNavHostListener chatNavHostListener2 = (ChatNavHostListener)vector.elementAt(n2);
            if (chatNavHostListener2 != chatNavHostListener) {
                n = this.updateHandledState(n, chatNavHostListener2.chatNavRequestChatRights(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRequestExchangeInfo(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatNavRequestExchangeInfo SNAC");
        ChatNavHostListener chatNavHostListener = (ChatNavHostListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            int n2 = this.initHandledState();
            if (chatNavHostListener != null) {
                n2 = this.updateHandledState(n2, chatNavHostListener.chatNavRequestExchangeInfo(fLAPSock, object, sNACHeader.reqID, n2, n));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                ChatNavHostListener chatNavHostListener2 = (ChatNavHostListener)vector.elementAt(n3);
                if (chatNavHostListener2 != chatNavHostListener) {
                    n2 = this.updateHandledState(n2, chatNavHostListener2.chatNavRequestExchangeInfo(fLAPSock, object, sNACHeader.reqID, n2, n));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavRequestExchangeInfo " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRequestRoomInfo(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatNavRequestRoomInfo SNAC");
        ChatNavHostListener chatNavHostListener = (ChatNavHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<ChatRoomIDWDetail> vector2;
                block7: {
                    vector2 = new Vector<ChatRoomIDWDetail>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new ChatRoomIDWDetail(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (chatNavHostListener != null) {
                        n2 = this.updateHandledState(n2, chatNavHostListener.chatNavRequestRoomInfo(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ChatNavHostListener chatNavHostListener2;
                    if ((chatNavHostListener2 = (ChatNavHostListener)vector.elementAt(n)) != chatNavHostListener) {
                        n2 = this.updateHandledState(n2, chatNavHostListener2.chatNavRequestRoomInfo(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavRequestRoomInfo " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRequestMoreRoomInfo(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatNavRequestMoreRoomInfo SNAC");
        ChatNavHostListener chatNavHostListener = (ChatNavHostListener)listener;
        try {
            int n = dataInputStream.available();
            if (n > 8192) {
                throw new IOException("read overflow");
            }
            if (n < 0) {
                throw new IOException("read underflow");
            }
            byte[] byArray = new byte[n];
            if (n > 0) {
                dataInputStream.read(byArray, 0, n);
            }
            int n2 = this.initHandledState();
            if (chatNavHostListener != null) {
                n2 = this.updateHandledState(n2, chatNavHostListener.chatNavRequestMoreRoomInfo(fLAPSock, object, sNACHeader.reqID, n2, byArray));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                ChatNavHostListener chatNavHostListener2 = (ChatNavHostListener)vector.elementAt(n3);
                if (chatNavHostListener2 != chatNavHostListener) {
                    n2 = this.updateHandledState(n2, chatNavHostListener2.chatNavRequestMoreRoomInfo(fLAPSock, object, sNACHeader.reqID, n2, byArray));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavRequestMoreRoomInfo " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRequestOccupantList(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatNavRequestOccupantList SNAC");
        ChatNavHostListener chatNavHostListener = (ChatNavHostListener)listener;
        try {
            ChatRoomID chatRoomID = new ChatRoomID(dataInputStream);
            int n = this.initHandledState();
            if (chatNavHostListener != null) {
                n = this.updateHandledState(n, chatNavHostListener.chatNavRequestOccupantList(fLAPSock, object, sNACHeader.reqID, n, chatRoomID));
            }
            int n2 = 0;
            while (vector != null) {
                if (n2 >= vector.size()) return;
                if (!this.proceed(n)) {
                    return;
                }
                ChatNavHostListener chatNavHostListener2 = (ChatNavHostListener)vector.elementAt(n2);
                if (chatNavHostListener2 != chatNavHostListener) {
                    n = this.updateHandledState(n, chatNavHostListener2.chatNavRequestOccupantList(fLAPSock, object, sNACHeader.reqID, n, chatRoomID));
                }
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavRequestOccupantList " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeSearchForRoom(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatNavSearchForRoom SNAC");
        ChatNavHostListener chatNavHostListener = (ChatNavHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                int n3;
                block7: {
                    n3 = dataInputStream.readUnsignedShort();
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (chatNavHostListener != null) {
                        n2 = this.updateHandledState(n2, chatNavHostListener.chatNavSearchForRoom(fLAPSock, object, sNACHeader.reqID, n2, n3, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ChatNavHostListener chatNavHostListener2;
                    if ((chatNavHostListener2 = (ChatNavHostListener)vector.elementAt(n)) != chatNavHostListener) {
                        n2 = this.updateHandledState(n2, chatNavHostListener2.chatNavSearchForRoom(fLAPSock, object, sNACHeader.reqID, n2, n3, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavSearchForRoom " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeCreateRoom(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got chatNavCreateRoom SNAC");
        ChatNavHostListener chatNavHostListener = (ChatNavHostListener)listener;
        try {
            ChatRoomDesc chatRoomDesc = new ChatRoomDesc(dataInputStream);
            int n = this.initHandledState();
            if (chatNavHostListener != null) {
                n = this.updateHandledState(n, chatNavHostListener.chatNavCreateRoom(fLAPSock, object, sNACHeader.reqID, n, chatRoomDesc));
            }
            int n2 = 0;
            while (vector != null) {
                if (n2 >= vector.size()) return;
                if (!this.proceed(n)) {
                    return;
                }
                ChatNavHostListener chatNavHostListener2 = (ChatNavHostListener)vector.elementAt(n2);
                if (chatNavHostListener2 != chatNavHostListener) {
                    n = this.updateHandledState(n, chatNavHostListener2.chatNavCreateRoom(fLAPSock, object, sNACHeader.reqID, n, chatRoomDesc));
                }
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavCreateRoom " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void navInfo(FLAPSock fLAPSock, ChatNavHostListener chatNavHostListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing chatNavNavInfo SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, chatNavHostListener, object, 13, 9, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("ChatNav", "got IOException in chatNavNavInfo " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 2) {
            this.decodeRequestChatRights(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 3) {
            this.decodeRequestExchangeInfo(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 4) {
            this.decodeRequestRoomInfo(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 5) {
            this.decodeRequestMoreRoomInfo(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 6) {
            this.decodeRequestOccupantList(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 7) {
            this.decodeSearchForRoom(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 8) {
            this.decodeCreateRoom(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("ChatNav", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

