/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacTlv;
import snac.StatsListener;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class StatsHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public StatsHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(11, 1, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeSetMinReportInterval(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got statsSetMinReportInterval SNAC");
        StatsListener statsListener = (StatsListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            int n2 = this.initHandledState();
            if (statsListener != null) {
                n2 = this.updateHandledState(n2, statsListener.statsSetMinReportInterval(fLAPSock, object, sNACHeader.reqID, n2, n));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                StatsListener statsListener2 = (StatsListener)vector.elementAt(n3);
                if (statsListener2 != statsListener) {
                    n2 = this.updateHandledState(n2, statsListener2.statsSetMinReportInterval(fLAPSock, object, sNACHeader.reqID, n2, n));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Stats", "got IOException in statsSetMinReportInterval " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void reportEvents(FLAPSock fLAPSock, StatsListener statsListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing statsReportEvents SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, statsListener, object, 11, 3, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Stats", "got IOException in statsReportEvents " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    private void decodeReportAck(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got statsReportAck SNAC");
        StatsListener statsListener = (StatsListener)listener;
        int n = this.initHandledState();
        if (statsListener != null) {
            n = this.updateHandledState(n, statsListener.statsReportAck(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            StatsListener statsListener2 = (StatsListener)vector.elementAt(n2);
            if (statsListener2 != statsListener) {
                n = this.updateHandledState(n, statsListener2.statsReportAck(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 2) {
            this.decodeSetMinReportInterval(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 4) {
            this.decodeReportAck(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Stats", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

