/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.List;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.io.InputStream;
import main.Oscar;
import sun.audio.AudioPlayer;
import uiutil.HImageFilter;
import uiutil.Icon;
import uiutil.ImageLabel;
import uiutil.ImagePanel;
import uiutil.MediaStore;
import uiutil.OFrame;
import uiutil.SoundThread;
import uiutil.Spacer;
import uiutil.UIPack;
import util.Log;

public class IUtil {
    private static final String MODULE = "UIUTIL";
    public static boolean playSounds = true;
    public static String SOUND_SUFFIX = ".au";

    public static boolean loadImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        mediaTracker.statusAll(true);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            Log.log(MODULE, Log.WARNING, "Had difficulties tracking image. " + interruptedException);
            return false;
        }
        if ((mediaTracker.statusAll(true) & 4) != 0) {
            Log.log(MODULE, Log.WARNING, "Encountered error in loading image for " + component);
        }
        return true;
    }

    public static String getStringFromColor(Color color) {
        String string = "#";
        String string2 = Integer.toHexString(color.getRed());
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        string = String.valueOf(string) + string2;
        string2 = Integer.toHexString(color.getGreen());
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        string = String.valueOf(string) + string2;
        string2 = Integer.toHexString(color.getBlue());
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        return String.valueOf(string) + string2;
    }

    public static boolean inList(String string, List list) {
        if (list == null) {
            return false;
        }
        int n = list.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(list.getItem(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Image getFilteredImage(Image image, Component component) {
        Image image2;
        try {
            HImageFilter hImageFilter = new HImageFilter();
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), hImageFilter);
            image2 = component.createImage(filteredImageSource);
        }
        catch (Exception exception) {
            image2 = image;
            Log.log(MODULE, Log.WARNING, "Encountered problem in creating image.");
        }
        if (!IUtil.loadImage(component, image2)) {
            image2 = image;
            Log.log(MODULE, Log.WARNING, "Failed to track a highlighted image!");
        }
        return image2;
    }

    public static ImagePanel getCheckbox(Checkbox checkbox, Icon icon, String string, int n, int n2, int n3, boolean bl) {
        ImagePanel imagePanel = new ImagePanel();
        imagePanel.setLayout(new FlowLayout(0, 0, 0));
        if (bl) {
            imagePanel.add(new Spacer());
        }
        imagePanel.add(checkbox);
        if (icon != null) {
            imagePanel.add(icon);
        }
        ImageLabel imageLabel = new ImageLabel(string, 2, n2, n3);
        imagePanel.add(imageLabel);
        imageLabel.setTextStyle(n);
        return imagePanel;
    }

    public static int getIdleTime() {
        long l = System.currentTimeMillis();
        return (int)((l - OFrame.lastEventTime) / 1000L);
    }

    public static boolean shouldAutoConnect() {
        return false;
    }

    public static String format(String string, int n) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 < n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n3 = 0;
        while (n3 < n2) {
            int n4 = -1;
            int n5 = n3;
            while (n5 < n2 && n5 < n3 + n) {
                if (string.charAt(n5) == '\n') {
                    n4 = n5;
                    break;
                }
                if (Character.isWhitespace(string.charAt(n5))) {
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 == -1) {
                n4 = n5;
            } else if (n5 == n2 && n5 < n3 + n) {
                n4 = n2;
            }
            stringBuffer.append(string.substring(n3, n4));
            if (n4 >= n2) break;
            if (n4 > 0) {
                stringBuffer.append('\n');
            }
            n5 = n4;
            while (n5 < n2) {
                if (!Character.isWhitespace(string.charAt(n5))) break;
                n4 = n5 + 1;
                if (string.charAt(n5) == '\n') break;
                ++n5;
            }
            n3 = n4;
        }
        return stringBuffer.toString();
    }

    public static Thread playLoopingSound(UIPack uIPack, String string) {
        if (!playSounds || uIPack == null || string == null) {
            return null;
        }
        return IUtil.playSoundInThread(uIPack, string, true);
    }

    public static void stopLoopingSound(Thread thread) {
        if (thread != null) {
            ((SoundThread)thread).stopSound();
        }
    }

    public static boolean playSound(UIPack uIPack, String string) {
        if (!playSounds || uIPack == null || string == null) {
            return false;
        }
        if (Oscar.config.getValue("debug.soundthread") == null) {
            return IUtil.playSoundDirect(uIPack, string);
        }
        return IUtil.playSoundInThread(uIPack, string, false) != null;
    }

    public static boolean playSoundDirect(UIPack uIPack, String string) {
        InputStream inputStream = MediaStore.getSound(uIPack.getUIPackNames(), String.valueOf(string) + SOUND_SUFFIX);
        if (inputStream == null) {
            return false;
        }
        AudioPlayer.player.start(inputStream);
        return true;
    }

    public static Thread playSoundInThread(UIPack uIPack, String string, boolean bl) {
        InputStream inputStream = MediaStore.getSound(uIPack.getUIPackNames(), String.valueOf(string) + SOUND_SUFFIX);
        if (inputStream == null) {
            return null;
        }
        SoundThread soundThread = new SoundThread(inputStream, bl);
        soundThread.start();
        return soundThread;
    }

    public static Frame findFrame(Component component) {
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        if (component == null) {
            return null;
        }
        return (Frame)component;
    }
}

