/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import uiutil.MediaStore;
import uiutil.SLCInfo;
import uiutil.SLCommandListener;
import uiutil.SLComp;
import uiutil.SLConstraint;
import uiutil.UIPack;
import util.JUtil;
import util.Log;

public class SuperLayout
implements LayoutManager {
    public static final int NOVAL = -34567;
    private static final String MODULE = "SuperLayout";
    static boolean debug;
    static SLCommandListener defaultHandler;
    Hashtable components = new Hashtable(20);
    SLCommandListener handler;
    UIPack uipack;
    Container con;
    int minWidth = 20;
    int minHeight = 20;

    public SuperLayout() {
        this(null, null, null);
    }

    public SuperLayout(Container container, UIPack uIPack) {
        this(container, defaultHandler, uIPack);
    }

    public SuperLayout(Container container, SLCommandListener sLCommandListener, UIPack uIPack) {
        this.con = container;
        this.handler = sLCommandListener;
        this.uipack = uIPack;
    }

    public void setMinHint(int n, int n2) {
        this.minWidth = n;
        this.minHeight = n2;
    }

    public static void setDefaultHandler(SLCommandListener sLCommandListener) {
        defaultHandler = sLCommandListener;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string == null) {
            throw new IllegalArgumentException("cannot add to layout: constraint must be a string");
        }
        SLComp sLComp = new SLComp(string, component);
        this.components.put(string, sLComp);
    }

    public Component getLayoutComponent(String string) {
        SLComp sLComp = (SLComp)this.components.get(string);
        if (sLComp == null) {
            return null;
        }
        return sLComp.comp;
    }

    public void removeLayoutComponent(Component component) {
        Enumeration enumeration = this.components.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            SLComp sLComp = (SLComp)this.components.get(string);
            if (sLComp.comp != component) continue;
            this.components.remove(string);
            return;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this.GetInfo(container, false);
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = this.GetInfo(container, true);
        return dimension;
    }

    public void layoutContainer(Container container) {
        this.GetInfo(container, false);
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        this.initSLCs(3, "layoutContainer");
        if (debug) {
            System.out.println("LAYOUT CONTAINER size = " + dimension);
        }
        this.findSize(container, dimension, false);
        Enumeration enumeration = this.components.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            SLComp sLComp = (SLComp)this.components.get(string);
            if (sLComp.cons == null) continue;
            sLComp.comp.setBounds(insets.left + sLComp.cons.west.value, insets.top + sLComp.cons.north.value, sLComp.cons.east.value - sLComp.cons.west.value, sLComp.cons.south.value - sLComp.cons.north.value);
        }
    }

    public void loadLayout(String string) {
        try {
            BufferedReader bufferedReader = MediaStore.getLayout(this.uipack.getUIPackNames(), string);
            this.setInput(bufferedReader);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setInput(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() <= 2 || string.charAt(0) == '#') continue;
                if (string.charAt(0) == '*') {
                    if (this.handler == null || this.handler.processCommand(this, this.uipack, this.con, string)) continue;
                    Log.log(MODULE, Log.NOTICE, "Unknown Command: " + string);
                    continue;
                }
                SLConstraint sLConstraint = new SLConstraint(string);
                SLComp sLComp = (SLComp)this.components.get(sLConstraint.name);
                if (sLComp == null) {
                    Log.log(MODULE, Log.NOTICE, "No component named " + sLConstraint.name + " in container.");
                    continue;
                }
                sLComp.cons = sLConstraint;
            }
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public int center(SLComp sLComp, int n, SLCInfo sLCInfo, Dimension dimension, boolean bl) {
        SLCInfo sLCInfo2;
        SLComp sLComp2;
        SLCInfo sLCInfo3 = sLComp.cons.getOpInfo(n);
        int n2 = 0;
        int n3 = 0;
        if (sLCInfo.type == 5) {
            n3 = 0;
        } else if (sLCInfo.type == 3) {
            sLComp2 = (SLComp)this.components.get(sLCInfo.rname);
            if (sLComp2 == null) {
                return 0;
            }
            sLCInfo2 = sLComp2.cons.getOpInfo(n);
            if (sLCInfo2.value == -34567) {
                return 0;
            }
            n3 = sLCInfo2.value;
        }
        if (sLCInfo3.type == 5) {
            n2 = n == 0 ? dimension.width : dimension.height;
        } else if (sLCInfo3.type == 3) {
            sLComp2 = (SLComp)this.components.get(sLCInfo3.rname);
            if (sLComp2 == null) {
                return 0;
            }
            sLCInfo2 = sLComp2.cons.getInfo(n);
            if (sLCInfo2.value == -34567) {
                return 0;
            }
            n2 = sLCInfo2.value;
        }
        if (n == 0) {
            sLCInfo.value = (n2 - n3 - sLComp.width) / 2;
            sLCInfo3.value = sLCInfo.value + sLComp.width;
        } else {
            sLCInfo.value = (n2 - n3 - sLComp.height) / 2;
            sLCInfo3.value = sLCInfo.value + sLComp.height;
        }
        return 0;
    }

    public int set(SLComp sLComp, int n, SLCInfo sLCInfo, Dimension dimension, boolean bl) {
        if (sLCInfo.offset == -999) {
            return this.center(sLComp, n, sLCInfo, dimension, bl);
        }
        switch (sLCInfo.type) {
            case 0: {
                Log.log(MODULE, Log.NOTICE, "Don't know " + sLCInfo);
                break;
            }
            case 5: {
                if (n == 0) {
                    if (bl && 2 * sLCInfo.offset + sLComp.width > dimension.width) {
                        dimension.width = 2 * sLCInfo.offset + sLComp.width;
                        this.initSLCs(1, "1: SIDE");
                        return 1;
                    }
                    sLCInfo.value = sLCInfo.offset;
                    return 1;
                }
                if (n == 1) {
                    if (bl && 2 * sLCInfo.offset + sLComp.height > dimension.height) {
                        dimension.height = 2 * sLCInfo.offset + sLComp.height;
                        this.initSLCs(2, "2: SIDE");
                        return 1;
                    }
                    sLCInfo.value = sLCInfo.offset;
                    return 1;
                }
                if (n == 2) {
                    if (bl && 2 * sLCInfo.offset + sLComp.width > dimension.width) {
                        dimension.width = 2 * sLCInfo.offset + sLComp.width;
                        this.initSLCs(1, "3: SIDE");
                        return 1;
                    }
                    sLCInfo.value = dimension.width - sLCInfo.offset;
                    return 1;
                }
                if (n == 3) {
                    if (bl && 2 * sLCInfo.offset + sLComp.height > dimension.height) {
                        dimension.height = 2 * sLCInfo.offset + sLComp.height;
                        this.initSLCs(2, "4: SIDE");
                        return 1;
                    }
                    sLCInfo.value = dimension.height - sLCInfo.offset;
                    return 1;
                }
                return 0;
            }
            case 2: {
                sLCInfo.value = n % 2 == 0 ? dimension.width * sLCInfo.pos / 100 : dimension.height * sLCInfo.pos / 100;
                return 1;
            }
            case 1: {
                if (n % 2 == 0) {
                    sLCInfo.value = sLCInfo.pos;
                    if (bl && sLCInfo.pos > dimension.width) {
                        dimension.width = sLCInfo.value;
                        this.initSLCs(1, "1: ABSOLUTE");
                        return 1;
                    }
                } else {
                    sLCInfo.value = sLCInfo.pos;
                    if (bl && sLCInfo.value > dimension.height) {
                        dimension.height = sLCInfo.value;
                        this.initSLCs(2, "2: ABSOLUTE");
                        return 1;
                    }
                }
                SLCInfo sLCInfo2 = sLComp.cons.getOpInfo(n);
                if (sLCInfo2.value != -34567) {
                    if (bl && n == 0 && sLCInfo.value + sLComp.width > sLCInfo2.value) {
                        dimension.width = Math.max(sLCInfo.value + sLComp.width + sLCInfo.offset, dimension.width);
                        this.initSLCs(1, "3: ABSOLUTE");
                    } else if (bl && n == 1 && sLCInfo.value + sLComp.height > sLCInfo2.value) {
                        dimension.height = Math.max(sLCInfo.value + sLComp.height + sLCInfo.offset, dimension.height);
                        this.initSLCs(2, "4: ABSOLUTE");
                    }
                }
                return 1;
            }
            case 4: {
                Object object = sLComp.cons.getOpInfo(n);
                if (((SLCInfo)object).value == -34567) {
                    return 0;
                }
                if (n == 0) {
                    sLCInfo.value = ((SLCInfo)object).value - sLComp.width;
                    return 1;
                }
                if (n == 1) {
                    sLCInfo.value = ((SLCInfo)object).value - sLComp.height;
                    return 1;
                }
                if (n == 2) {
                    sLCInfo.value = ((SLCInfo)object).value + sLComp.width;
                    if (bl && sLCInfo.value > dimension.width) {
                        dimension.width = sLCInfo.value;
                        this.initSLCs(1, "1: SIZE");
                    }
                    return 1;
                }
                if (n == 3) {
                    sLCInfo.value = ((SLCInfo)object).value + sLComp.height;
                    if (bl && sLCInfo.value > dimension.height) {
                        dimension.height = sLCInfo.value;
                        this.initSLCs(2, "2: SIZE");
                    }
                    return 1;
                }
            }
            case 3: {
                Object object = (SLComp)this.components.get(sLCInfo.rname);
                if (object == null) {
                    Log.log(MODULE, Log.NOTICE, "Didn't find relative " + sLCInfo.rname);
                    return 0;
                }
                SLCInfo sLCInfo3 = sLCInfo.offset == -9999 ? ((SLComp)object).cons.getInfo(n) : ((SLComp)object).cons.getOpInfo(n);
                if (sLCInfo3.value == -34567) {
                    return 0;
                }
                if (sLCInfo.offset == -9999) {
                    sLCInfo.value = sLCInfo3.value;
                    return 1;
                }
                sLCInfo.value = n <= 1 ? sLCInfo3.value + sLCInfo.offset : sLCInfo3.value - sLCInfo.offset;
                if (bl && n == 0 && sLCInfo.value + sLComp.width > dimension.width) {
                    dimension.width = sLCInfo.value + sLComp.width;
                    this.initSLCs(1, "1: RELATIVE");
                    return 1;
                }
                if (bl && n == 1 && sLCInfo.value + sLComp.height > dimension.height) {
                    dimension.height = sLCInfo.value + sLComp.height;
                    this.initSLCs(2, "2: RELATIVE");
                    return 1;
                }
                SLCInfo sLCInfo4 = sLComp.cons.getOpInfo(n);
                if (sLCInfo4.value == -34567 || !bl) {
                    return 1;
                }
                int n2 = n == 0 || n == 1 ? sLCInfo4.value - sLCInfo.value : sLCInfo.value - sLCInfo4.value;
                if (n % 2 == 0 && n2 < sLComp.width) {
                    dimension.width += sLComp.width - n2;
                    this.initSLCs(1, "3: RELATIVE");
                } else if (n % 2 == 1 && n2 < sLComp.height) {
                    dimension.height += sLComp.height - n2;
                    this.initSLCs(2, "4: RELATIVE");
                }
                return 1;
            }
        }
        return 0;
    }

    public Dimension findSize(Container container, Dimension dimension, boolean bl) {
        int n = 1;
        while (n > 0) {
            n = 0;
            Enumeration enumeration = this.components.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                SLComp sLComp = (SLComp)this.components.get(string);
                if (sLComp.cons == null) {
                    Log.log(MODULE, Log.NOTICE, "findSize slc.cons == null for " + string);
                    continue;
                }
                if (sLComp.cons.west.value == -34567) {
                    n += this.set(sLComp, 0, sLComp.cons.west, dimension, bl);
                }
                if (sLComp.cons.north.value == -34567) {
                    n += this.set(sLComp, 1, sLComp.cons.north, dimension, bl);
                }
                if (sLComp.cons.east.value == -34567) {
                    n += this.set(sLComp, 2, sLComp.cons.east, dimension, bl);
                }
                if (sLComp.cons.south.value != -34567) continue;
                n += this.set(sLComp, 3, sLComp.cons.south, dimension, bl);
            }
        }
        return dimension;
    }

    public void initSLCs(int n, String string) {
        Enumeration enumeration = this.components.keys();
        boolean bl = (n & 1) == 1;
        boolean bl2 = (n & 2) == 2;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            SLComp sLComp = (SLComp)this.components.get(string2);
            if (sLComp.cons == null) {
                if (!debug) continue;
                System.out.println("initSLCs slc.cons == null for " + string2);
                continue;
            }
            if (bl2) {
                sLComp.cons.north.value = -34567;
                sLComp.cons.south.value = -34567;
            }
            if (!bl) continue;
            sLComp.cons.east.value = -34567;
            sLComp.cons.west.value = -34567;
        }
    }

    public Dimension GetInfo(Container container, boolean bl) {
        Object object;
        Object object2;
        Dimension dimension = new Dimension(this.minWidth, this.minHeight);
        this.initSLCs(3, "GetInfo");
        Enumeration enumeration = this.components.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (SLComp)this.components.get(object2);
            if (((SLComp)object).comp == null) {
                Log.log(MODULE, Log.ERROR, "No component for " + object);
                continue;
            }
            Dimension dimension2 = bl ? ((SLComp)object).comp.getMinimumSize() : ((SLComp)object).comp.getPreferredSize();
            if (dimension2 == null) {
                Log.log(MODULE, Log.ERROR, "The component " + object + " has no minimum/preferred size.");
                continue;
            }
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            if (dimension2.height > dimension.height) {
                dimension.height = dimension2.height;
            }
            ((SLComp)object).width = dimension2.width;
            ((SLComp)object).height = dimension2.height;
        }
        object2 = this.findSize(container, dimension, true);
        object = container.getInsets();
        ((Dimension)object2).width += ((Insets)object).left + ((Insets)object).right;
        ((Dimension)object2).height += ((Insets)object).top + ((Insets)object).bottom;
        return object2;
    }

    public static void test1() {
        try {
            String string = "LEFT north=SIDE west=SIDE\nRIGHT north=SIDE east=SIDE\nBOTTOM north=50 south=SIDE southoffset=5 west=50 east=SIDE\n";
            SuperLayout superLayout = new SuperLayout();
            Frame frame = new Frame("test1");
            frame.setLayout(superLayout);
            frame.add("RIGHT", new Button("RIGHT"));
            frame.add("LEFT", new Button("LEFT"));
            frame.add("BOTTOM", new Button("BOTTOM"));
            superLayout.setInput(new BufferedReader(new StringReader(string)));
            frame.pack();
            frame.show();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void test2() {
        try {
            String string = "Top north=SIDE east=SIDE west=SIDE south=40%\nMiddle1 north=Top south=Button1 west=SIDE\nButton1 south=SIDE west=SIDE\nButton2 south=SIDE east=SIDE\n";
            SuperLayout superLayout = new SuperLayout();
            Frame frame = new Frame("test2");
            frame.setLayout(superLayout);
            frame.add("Top", new Label("Top"));
            frame.add("Middle1", new Label("Middle1"));
            frame.add("Button1", new Button("Button1"));
            frame.add("Button2", new Button("Button2"));
            superLayout.setInput(new BufferedReader(new StringReader(string)));
            frame.pack();
            frame.show();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void test3() {
        try {
            String string = "Top north=SIDE east=SIDE west=SIDE south=40%\nMiddle1 north=Top west=SIDE\nMiddle2 north=Top west=Middle1\nMiddle3 north=Top west=Middle2 westoffset=30\nBottom north=Middle3 south=Button1 west=SIDE east=SIDE\nButton1 south=SIDE west=SIDE\nButton2 south=SIDE east=SIDE\n";
            SuperLayout superLayout = new SuperLayout();
            Frame frame = new Frame("test3");
            frame.setLayout(superLayout);
            frame.add("Top", new Label("Top"));
            frame.add("Middle1", new Label("Middle1"));
            frame.add("Middle2", new Label("Middle2"));
            frame.add("Middle3", new Label("Middle3"));
            frame.add("Bottom", new Label("Bottom"));
            frame.add("Button1", new Button("Button1"));
            frame.add("Button2", new Button("Button2"));
            superLayout.setInput(new BufferedReader(new StringReader(string)));
            frame.pack();
            frame.show();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void imtest() {
        try {
            String string = "DisplayArea     north=SIDE east=SIDE west=SIDE south=FgColor offset=1\nFgColor         north=SIDE northoffset=BETWEEN south=RateBar southoffset=BETWEEN west=SIDE\nTalkArea        north=FgColor east=SIDE west=SIDE south=RateBar offset=1\nRateBar         south=Zap west=SIDE east=SIDE\nZap             south=SIDE west=SIDE\nInfo            south=SIDE west=Zap\nCancel          south=SIDE east=SIDE\nSend            south=SIDE east=Cancel\nBgColor         north=SIDE northoffset=BETWEEN south=RateBar southoffset=BETWEEN west=FgColor\nFontSmaller     north=SIDE northoffset=BETWEEN south=RateBar southoffset=BETWEEN west=BgColor westoffset=20\nFontNormal      north=SIDE northoffset=BETWEEN south=RateBar southoffset=BETWEEN west=FontSmaller\nFontBigger      north=SIDE northoffset=BETWEEN south=RateBar southoffset=BETWEEN west=FontNormal\nBold            north=SIDE northoffset=BETWEEN south=RateBar southoffset=BETWEEN west=FontBigger westoffset=20\nItalic          north=SIDE northoffset=BETWEEN south=RateBar southoffset=BETWEEN west=Bold\nUnderline       north=SIDE northoffset=BETWEEN south=RateBar southoffset=BETWEEN west=Italic\n";
            SuperLayout superLayout = new SuperLayout();
            Frame frame = new Frame("IM Test");
            frame.setLayout(superLayout);
            frame.add("DisplayArea", new TextArea());
            frame.add("FgColor", new Button("Fg"));
            frame.add("BgColor", new Button("Bg"));
            frame.add("FontSmaller", new Button("Av"));
            frame.add("FontNormal", new Button("A"));
            frame.add("FontBigger", new Button("^A"));
            frame.add("Bold", new Button("B"));
            frame.add("Italic", new Button("I"));
            frame.add("Underline", new Button("U"));
            frame.add("TalkArea", new TextArea());
            frame.add("RateBar", new Label(" ---=== Rate Bar === ---", 1));
            frame.add("Zap", new Button("Zap"));
            frame.add("Info", new Button("Info"));
            frame.add("Cancel", new Button("Canel"));
            frame.add("Send", new Button("Send"));
            superLayout.setInput(new BufferedReader(new StringReader(string)));
            frame.pack();
            frame.show();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void buddytest() {
        try {
            String string = "Ad     \t north=SIDE east=SIDE eastoffset=BETWEEN west=SIDE westoffset=BETWEEN\nBuddyList       north=Ad northoffset=10 south=Info southoffset=10 west=SIDE east=SIDE\nInfo            south=SIDE west=SIDE\nIM              south=SIDE west=Info\nNews            south=SIDE west=IM\nEvil            south=SIDE west=News\n";
            SuperLayout superLayout = new SuperLayout();
            Frame frame = new Frame("Buddy List Test");
            frame.setLayout(superLayout);
            MenuBar menuBar = new MenuBar();
            frame.setMenuBar(menuBar);
            menuBar.add(new Menu("File"));
            frame.add("Ad", new Label("Buy Aol"));
            frame.add("BuddyList", new TextArea("Buddies\nGo\nHere\n"));
            frame.add("Info", new Button("Info"));
            frame.add("IM", new Button("Im"));
            frame.add("News", new Button("News"));
            frame.add("Evil", new Label("Evil"));
            superLayout.setInput(new BufferedReader(new StringReader(string)));
            frame.pack();
            frame.show();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void infotest() {
        try {
            String string = "Warnings     \t north=SIDE offset=1 west=SIDE east=IdleTime eastoffset=SAME\nIdleTime     \t north=Warnings offset=1 west=SIDE east=SIZE\nOnSince     \t north=IdleTime offset=1 west=SIDE east=IdleTime eastoffset=SAME\nWarningsA     \t north=SIDE offset=1 west=Warnings\nIdleTimeA     \t north=Warnings offset=1 west=IdleTime\nOnSinceA     \t north=IdleTime offset=1 west=OnSince\nClass     \t north=SIDE offset=1 east=ClassA\nMemberS     \t north=Warnings offset=1 east=MemberSA\nClassA     \t north=SIDE offset=1 west=SIZE east=SIDE\nMemberSA     \t north=Warnings offset=1 west=ClassA westoffset=SAME east=SIDE\nDisplayArea\t north=OnSince south=RateBar east=SIDE west=SIDE\nRateBar         south=IM west=SIDE east=SIDE\nIM              south=SIDE west=SIDE westoffset=BETWEEN east=SIDE eastoffset=BETWEEN\n";
            SuperLayout superLayout = new SuperLayout();
            Frame frame = new Frame("Info Test");
            frame.setLayout(superLayout);
            frame.add("Warnings", new Label("Warnings:"));
            frame.add("WarningsA", new Label("0"));
            frame.add("IdleTime", new Label("Idle Time:"));
            frame.add("IdleTimeA", new Label("1"));
            frame.add("OnSince", new Label("On Since:"));
            frame.add("OnSinceA", new Label("2"));
            frame.add("Class", new Label("Class:"));
            frame.add("ClassA", new Label("3"));
            frame.add("MemberS", new Label("Member Since:"));
            frame.add("MemberSA", new Label("4"));
            frame.add("DisplayArea", new TextArea("Info goes here"));
            frame.add("RateBar", new Label(" ---=== Rate Bar === ---", 1));
            frame.add("IM", new Button("IM"));
            superLayout.setInput(new BufferedReader(new StringReader(string)));
            frame.pack();
            frame.show();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void main(String[] stringArray) {
        SuperLayout.test1();
        SuperLayout.test2();
        SuperLayout.test3();
        SuperLayout.imtest();
        SuperLayout.buddytest();
        SuperLayout.infotest();
        JUtil.sleep(10000);
    }

    static {
        defaultHandler = null;
    }
}

